/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public final class Arity {
    private static Map arities = new HashMap();
    private final int value;

    private Arity(int value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Arity createArity(int value) {
        Arity result;
        Integer integerValue = new Integer(value);
        Map map = arities;
        synchronized (map) {
            result = (Arity)arities.get(integerValue);
            if (result == null) {
                result = new Arity(value);
                arities.put(integerValue, result);
            }
        }
        return result;
    }

    public static Arity fixed(int arity) {
        Asserts.isTrue(arity >= 0);
        return Arity.createArity(arity);
    }

    public static Arity optional() {
        return Arity.createArity(-1);
    }

    public static Arity required(int minimum) {
        Asserts.isTrue(minimum >= 0);
        return Arity.createArity(-(1 + minimum));
    }

    public static Arity noArguments() {
        return Arity.createArity(0);
    }

    public static Arity singleArgument() {
        return Arity.createArity(1);
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(Ruby ruby, IRubyObject[] args) {
        if (this.isFixed()) {
            if (args.length != this.required()) {
                throw new ArgumentError(ruby, "wrong # of arguments(" + args.length + " for " + this.required() + ")");
            }
        } else if (args.length < this.required()) {
            throw new ArgumentError(ruby, "wrong # of arguments(at least " + this.required() + ")");
        }
    }

    private boolean isFixed() {
        return this.value >= 0;
    }

    private int required() {
        if (this.value < 0) {
            return -(1 + this.value);
        }
        return this.value;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }
}

