/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.internal.util.collections.Stack;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Namespace;

public class FrameStack
extends Stack {
    private Ruby runtime;

    public FrameStack(Ruby ruby) {
        this.runtime = ruby;
    }

    public Frame getPrevious() {
        if (this.isEmpty()) {
            return null;
        }
        return (Frame)this.previous();
    }

    public void push() {
        Namespace ns = this.peek() != null ? ((Frame)this.peek()).getNamespace() : null;
        this.push(new Frame(null, null, null, null, ns, null, this.runtime.getPosition(), this.runtime.getCurrentIter()));
    }

    public Object pop() {
        Frame frame = (Frame)super.pop();
        this.runtime.setPosition(frame.getPosition());
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameStack duplicate() {
        FrameStack newStack = new FrameStack(this.runtime);
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            newStack.list = new ArrayList(this.list.size());
            int i = 0;
            int size = this.list.size();
            while (i < size) {
                newStack.list.add(((Frame)this.list.get(i)).duplicate());
                ++i;
            }
        }
        return newStack;
    }
}

