/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.runtime.Arity;
import org.jruby.runtime.Callback;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public final class IndexedCallback
implements Callback {
    private final int index;
    private final Arity arity;

    private IndexedCallback(int index, Arity arity) {
        this.index = index;
        this.arity = arity;
    }

    public static IndexedCallback create(int index, int arity) {
        return new IndexedCallback(index, Arity.fixed(arity));
    }

    public static IndexedCallback createOptional(int index) {
        return new IndexedCallback(index, Arity.optional());
    }

    public static IndexedCallback createOptional(int index, int minimum) {
        Asserts.isTrue(minimum >= 0);
        return new IndexedCallback(index, Arity.required(minimum));
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
        this.arity.checkArity(recv.getRuntime(), args);
        return ((IndexCallable)((Object)recv)).callIndexed(this.index, args);
    }

    public Arity getArity() {
        return this.arity;
    }
}

