/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.runtime.Scope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.AbstractStack;
import org.jruby.util.collections.StackElement;

public class ScopeStack
extends AbstractStack {
    private Ruby ruby;

    public ScopeStack(Ruby ruby) {
        this.ruby = ruby;
    }

    public void push(List localNames) {
        this.push();
        this.resetLocalVariables(localNames);
    }

    public void push(StackElement newElement) {
        if (this.current() != null) {
            // empty if block
        }
        super.push(newElement);
    }

    public void push() {
        this.push(new Scope(this.ruby));
    }

    public StackElement pop() {
        Scope result = (Scope)super.pop();
        return result;
    }

    public void setTop(StackElement newElement) {
        this.top = newElement;
    }

    public Scope current() {
        return (Scope)this.top;
    }

    public IRubyObject getSuperObject() {
        return this.current().getSuperObject();
    }

    public void setSuperObject(IRubyObject superObject) {
        this.current().setSuperObject(superObject);
    }

    public List getLocalNames() {
        return this.current().getLocalNames();
    }

    public void resetLocalVariables(List localNames) {
        this.current().resetLocalVariables(localNames);
    }

    public void addLocalVariables(List localNames) {
        this.current().addLocalVariables(localNames);
    }

    public boolean hasLocalVariables() {
        return this.current().hasLocalVariables();
    }

    public IRubyObject getValue(int count) {
        return this.current().getValue(count);
    }

    public void setValue(int count, IRubyObject value) {
        this.current().setValue(count, value);
    }
}

