/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.oro.io.GlobFilenameFilter;

public class Glob {
    private File pattern;

    public Glob(String pattern) {
        this.pattern = new File(pattern);
    }

    private String[] splitPattern() {
        ArrayList<String> dirs = new ArrayList<String>();
        String path = this.pattern.getPath();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int size = path.length();
        while (i < size) {
            if (path.charAt(i) == File.separatorChar) {
                if (sb.length() > 0) {
                    dirs.add(sb.toString());
                    sb = new StringBuffer();
                }
                if (dirs.size() == 0) {
                    sb.append(File.separator);
                }
            } else {
                sb.append(path.charAt(i));
            }
            ++i;
        }
        if (sb.length() > 0) {
            dirs.add(sb.toString());
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    public File[] getFiles() {
        String[] dirs = this.splitPattern();
        File root = new File(dirs[0]);
        int idx = 1;
        if (dirs[0].indexOf(42) > -1 || dirs[0].indexOf(63) > -1) {
            root = new File(".");
            idx = 0;
        }
        int size = dirs.length;
        while (idx < size) {
            if (dirs[idx].indexOf(42) != -1 || dirs[idx].indexOf(63) != -1) break;
            root = new File(root, dirs[idx]);
            ++idx;
        }
        if (idx == dirs.length) {
            return new File[]{root};
        }
        ArrayList<File> matchingFiles = new ArrayList<File>();
        matchingFiles.add(root);
        int length = dirs.length;
        while (idx < length) {
            ArrayList currentMatchingFiles = new ArrayList();
            int i = 0;
            int size2 = matchingFiles.size();
            while (i < size2) {
                boolean isDirectory = idx + 1 != length;
                String pattern = dirs[idx];
                File parent = (File)matchingFiles.get(i);
                currentMatchingFiles.addAll(this.getMatchingFiles(parent, pattern, isDirectory));
                ++i;
            }
            matchingFiles = currentMatchingFiles;
            ++idx;
        }
        return matchingFiles.toArray(new File[matchingFiles.size()]);
    }

    private Collection getMatchingFiles(final File parent, final String pattern, final boolean isDirectory) {
        if (pattern.equals("**")) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(parent.listFiles(new FileFilter(){
            FilenameFilter filter;
            {
                this.filter = new GlobFilenameFilter(pattern);
            }

            public boolean accept(File pathname) {
                return (pathname.isDirectory() || !isDirectory) && this.filter.accept(parent, pathname.getName());
            }
        }));
    }

    public String[] getNames() {
        File[] files = this.getFiles();
        String[] names = new String[files.length];
        int i = 0;
        int size = files.length;
        while (i < size) {
            names[i] = files[i].getPath();
            ++i;
        }
        return names;
    }
}

