/*$Id: stack.h,v 1.2 2002/07/24 10:13:17 aa5779 Exp $*/
/*
	Copyright (C) 2001, 2002 Artem V. Andreev (artem@AA5779.spb.edu)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef STACKS_H
#define STACKS_H

typedef struct stack_t
{
	void *stack;
	int elsize;
	int depth;
	int maxdepth;
	int delta;
} stack_t;

#define STACK_DEFAULT_DELTA 16

void stack_init(stack_t *s, int elsize, int delta);
stack_t *stack_alloc(int elsize, int delta);
void stack_destroy(stack_t *s);
void stack_free(stack_t *s);

void *stack_push(stack_t *s);

int stack_isempty(stack_t *s);
int stack_depth(stack_t *s);
void *stack_peek(stack_t *s);
void *stack_pop(stack_t *s);

void stack_clear(stack_t *s);

#define intstack_alloc() (stack_alloc(sizeof int, 0))
#define intstack_push(s, i) ((void)(*(int *)stack_push(s) = (i)))
#define intstack_peek(s) (*(int *)stack_peek(s))
#define intstack_pop(s) (*(int *)stack_pop(s))

#endif
