--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
deferred class CALL
   --
   -- For all sort of feature calls with result value.
   -- So it does not include procedure calls (see PROC_CALL).
   --
   -- Classification: CALL_0 when 0 argument, CALL_1 when
   -- 1 argument and CALL_N when N arguments.
   --

inherit
   CALL_PROC_CALL
   EXPRESSION redefine verify_scoop end

feature {CALL_PROC_CALL}

feature

   is_writable: BOOLEAN is false

   is_current: BOOLEAN is false

   is_manifest_string: BOOLEAN is false

   is_result: BOOLEAN is false

   is_void: BOOLEAN is false

   c_simple: BOOLEAN is false

   start_lookup_class: BASE_CLASS is
      local
         bc: BASE_CLASS; e_feature: E_FEATURE; rt: E_TYPE
      do
         bc := target.start_lookup_class
         if bc /= Void then
            e_feature := bc.e_feature(feature_name)
            if e_feature /= Void then
               rt := e_feature.result_type
               if rt /= Void then
		  Result := rt.start_lookup_class
               end
            end
         end
      end

   frozen mapping_c_target(formal_type: E_TYPE) is
      local
         flag: BOOLEAN; actual_type: like result_type
      do
         flag := cpp.call_invariant_start(formal_type)
         actual_type := result_type.run_type
         if actual_type.is_reference then
            if formal_type.is_reference then
               -- Reference into Reference:
               formal_type.mapping_cast
               cpp.put_character('(')
               compile_to_c
               cpp.put_character(')')
            else
               -- Reference into Expanded:
               compile_to_c
            end
         else
            if formal_type.is_reference then
               -- Expanded into Reference:
               compile_to_c
            else
               -- Expanded into Expanded:
               if formal_type.need_c_struct then
                  cpp.put_character('&')
                  cpp.put_character('(')
                  compile_to_c
                  cpp.put_character(')')
               else
                  compile_to_c
               end
            end
         end
         if flag then
            cpp.call_invariant_end
         end
      end

   frozen mapping_c_arg(formal_arg_type: E_TYPE) is
      do
         compile_to_c
      end

   frozen c_frame_descriptor(format, locals: STRING) is
      do
         target.c_frame_descriptor(format,locals)
         if arg_count > 0 then
            arguments.c_frame_descriptor(format,locals)
         end
      end

   print_as_target is
      do
         pretty_print
         pretty_printer.put_character('.')
      end

   frozen compile_target_to_jvm is
      do
         standard_compile_target_to_jvm
      end

   frozen compile_to_jvm_into(dest: E_TYPE): INTEGER is
      do
         Result := standard_compile_to_jvm_into(dest)
      end

   frozen jvm_assign_creation, jvm_assign is
      do
      end

   frozen stupid_switch(run_time_set: RUN_TIME_SET): BOOLEAN is
      do
         Result := call_proc_call_stupid_switch(run_time_set)
         if Result then
            Result := not result_type.run_type.is_native_array
         end
      end

feature

   verify_scoop(allowed: FORMAL_ARG_LIST): BOOLEAN is
      do
         Result := target.result_type.is_separate
         Result := target.verify_scoop(allowed) or else Result
         if allowed /= Void then
            if allowed.verify_scoop(target) then
               Result := true
            end
         elseif target.result_type.is_separate and then not target.is_current then
            target.scoop_error
         end
      end

feature {NONE}

   frozen run_feature_has_result is
      do
         if run_feature.result_type = Void then
            error_handler.add_position(run_feature.start_position)
            error_handler.add_position(feature_name.start_position)
            fatal_error("Feature found is a procedure.")
         end
      end

   basic_conversion(e: EXPRESSION; e_type, type: E_TYPE): EXPRESSION is
      require
	 e.result_type = e_type
	 type /= Void
      local
	 e_type_rtm, type_rtm: STRING
      do
	 Result := e
	 if e_type.is_basic_eiffel_expanded then
	    if type.is_basic_eiffel_expanded then
	       type_rtm := type.run_time_mark
	       e_type_rtm := e_type.run_time_mark
	       if type_rtm /= e_type_rtm then
		  if e_type.is_a(type) then
		     Result := assignment_handler.implicit_cast(e, type)
		  else
		     error_handler.cancel
		  end
	       end
	    end
	 end
      ensure
	 Result /= Void
      end
   
end -- CALL
