--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
deferred class CALL_INFIX1

inherit CALL_INFIX

feature

   frozen result_type: E_TYPE is
      local
         tla: TYPE_LIKE_ARGUMENT
      do
         Result := run_feature.result_type
	 tla ?= Result
	 if tla /= Void then
	    Result := arg1.result_type.run_type
	 end
      end

   frozen to_runnable(ct: E_TYPE): like Current is
      local
         argument_type, target_type: E_TYPE
      do
	 if current_type = Void then
	    current_type := ct
	    runnable_target(ct)
	    arguments := runnable_arguments(ct)
	    target_type := target.result_type
	    argument_type := arg1.result_type
	    target := basic_conversion(target, target_type, argument_type)
	    run_feature_for(ct)
	    Result := Current
	    debug debug_info_update end
	    run_feature_match
	 else
	    create Result.with(target,feature_name,arguments)
	    Result := Result.to_runnable(ct)
	 end
      end

   frozen assertion_check(tag: CHARACTER) is
      do
         if tag = 'R' then
            run_feature.vape_check_from(start_position)
         end
         target.assertion_check(tag)
         arg1.assertion_check(tag)
      end

   frozen static_value: INTEGER is
      do
         Result := static_value_mem
      end

feature {RUN_FEATURE_3,RUN_FEATURE_4}

   finalize is
      local
         rc: RUN_CLASS; rf: RUN_FEATURE
      do
         rf := run_feature
         rc := rf.run_class
         run_feature := rc.run_time_set.first.dynamic(rf)
      end

feature {NONE}

   frozen with(t: like target; fn: like feature_name; a: like arguments) is
      require
         t /= Void
         fn /= Void
         a.count = 1
      do
         target := t
         feature_name := fn
         arguments := a
      ensure
         target = t
         feature_name = fn
         arguments = a
      end

   static_value_mem: INTEGER

   frozen call_is_static: BOOLEAN is
      local
         rc: RUN_CLASS; run_time_set: RUN_TIME_SET; rf: like run_feature
      do
         if run_feature /= Void then
            rc := run_feature.run_class
            if rc /= Void then
               run_time_set := rc.run_time_set
               if run_time_set.count = 1 then
                  rf := run_time_set.first.dynamic(run_feature)
                  if rf.is_static then
                     static_value_mem := rf.static_value_mem
                     Result := true
                  end
               end
            end
         end
      end

   frozen afd_check_hook is
      do
      end

end -- CALL_INFIX1

