--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class INTEGER_CONSTANT
   --
   -- For Manifest Constant of class INTEGER.
   --

inherit BASE_TYPE_CONSTANT

creation make

feature

   value_memory: INTEGER_64
	 -- We use here a 64 bit INTEGER to be able to store large values.

   size: INTEGER -- is 8, 16, 32 or 64.

   result_type: TYPE_INTEGER
   
   value: INTEGER is
      do
	 Result := value_memory.to_integer
      end

   is_static: BOOLEAN is
      do
	 Result := size < 64
      end

   static_value, to_integer_or_error: INTEGER is
      do
	 Result := value
      end

   compile_to_c is
      do
	 if value_memory = Minimum_integer_8  then
	    cpp.put_string(once "INT8_MIN")
	 elseif value_memory = Minimum_integer_16 then
	    cpp.put_string(once "INT16_MIN")
	 elseif value_memory = Minimum_integer_32 then
	    cpp.put_string(once "INT32_MIN")
	 elseif value_memory = Minimum_integer_64 then
	    cpp.put_string(once "INT64_MIN")
-- *** This code may replace above code if inspect accept INTEGER_64 values
--	 inspect value_memory
--	    when Minimum_integer_8  then cpp.put_string(once "INT8_MIN")
--	    when Minimum_integer_16 then cpp.put_string(once "INT16_MIN")
--	    when Minimum_integer_32 then cpp.put_string(once "INT32_MIN")
--	    when Minimum_integer_64 then cpp.put_string(once "INT64_MIN")
	 else
	    cpp.put_string(once "INT")
	    cpp.put_integer(size)
	    cpp.put_string(once "_C(")
	    cpp.put_integer(value_memory)
	    cpp.put_character(')')
	 end
      end

   compile_target_to_jvm, compile_to_jvm is
      do
         code_attribute.opcode_push_integer(value)
      end

   jvm_branch_if_false: INTEGER is
      do
      end

   jvm_branch_if_true: INTEGER is
      do
      end

   compile_to_jvm_into(dest: E_TYPE): INTEGER is
      do
         Result := standard_compile_to_jvm_into(dest)
      end

   c_simple: BOOLEAN is
      do
         Result := true
      end

   to_string: STRING is
         -- *** SHOULD ADD PRINTING MODE WITH/WITHOUT UNDESCORE.
      do
         Result := value.to_string
      end

feature {TMP_FEATURE}

   to_real_constant: REAL_CONSTANT is
      do
         create Result.make(start_position,value.to_string)
      end

feature {NONE}
   
   make(sign: INTEGER_8; a_value: INTEGER_64; sp: like start_position) is
	 -- `a_value' has to be negative because negative range is 
	 -- bigger than positive one. If `sign' tell the value is 
	 -- positive, then the oposite will be used.
      require
	 sign = -1 or sign = 0
	 a_value <= 0
      do
         start_position := sp
	 if sign >= 0 then
	    value_memory := -a_value
	    if value_memory <= 127 then
	       size := 8
	       create result_type.integer_8(sp)
	    elseif value_memory <= 32767 then
	       size := 16
	       create result_type.integer_16(sp)
	    elseif value_memory <= 2147483647 then
	       size := 32
	       create result_type.integer_32(sp)
	    else
	       size := 64
	       create result_type.integer_64(sp)
	    end
	 else
	    value_memory := a_value
	    if value_memory >= -128 then
	       size := 8
	       create result_type.integer_8(sp)
	    elseif value_memory >= -32768 then
	       size := 16
	       create result_type.integer_16(sp)
	    elseif value_memory >= -2147483648 then
	       size := 32
	       create result_type.integer_32(sp)
	    else
	       size := 64
	       create result_type.integer_64(sp)
	    end
	 end
      end

invariant

   size = 8 or size = 16 or size = 32 or size = 64

   size = (8 * result_type.c_sizeof)
   
end -- INTEGER_CONSTANT


