--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
deferred class WHEN_ITEM
--
--     WHEN_ITEM_1 for a single value.
--     WHEN_ITEM_2 for a slice.
--

inherit GLOBALS

feature

   e_when: E_WHEN
         -- Corresponding one when checked

   start_position: POSITION is
      deferred
      end

   pretty_print is
      deferred
      end

feature {E_WHEN}

   verify_scoop(allowed: FORMAL_ARG_LIST) is
      deferred
      end

   to_runnable_integer(ew: E_WHEN): like Current is
      require
         ew /= Void
      deferred
      ensure
         Result.e_when = ew
      end

   to_runnable_character(ew: E_WHEN): like Current is
      require
         ew /= Void
      deferred
      ensure
         Result.e_when = ew
      end

   clear_e_when is
      do
         e_when := Void
      ensure
         e_when = Void
      end

end -- WHEN_ITEM

