# $Id: Config.pm,v 1.12 2001/04/17 05:14:14 muhri Exp $
# -*- perl -*-
package Pronto::Config;
use strict;
use SelfLoader;
1;
__DATA__
sub init_config {

	my ($main, $vbox1, $tab1_label, $tab2_label, $tab3_label, $tab4_label, $page1_vbox, $page2_vbox, 
	    $page3_vbox, $page4_vbox, $page1_hbox, $page1_hbox2, $page2_rr, $page2_import, $page1_wrap, 
	    $page2_hbox1, $page2_hbox2, $page2_check1, $page2_check2, $page3_hbox1, $page3_hbox2, 
	    $page3_hbox3, $page3_hbox5, $page5_fm_label, $page5_fm_label2, $page5_fm_label3, 
	    $page5_fm_label4, $page5_hbox8, $page5_hbox7, $page5_fn_but, $page5_fn_but2, $page5_fn_but3, 
	    $page3_date, $page5_fn_but4, $page4_hbox1, $page4_label, $page4_hbox2, $page4_label2, 
	    $page4_label3, $page4_hbox3, $hbox_but, $ok_but, $cancel_but, $help_but, $tab5_label, 
	    $page5_vbox, $notebook, $page5_hbox1, $page5_hbox2, $page3_mra1, $page3_mra2, $page5_hbox3, 	
	    $page5_hbox4, $page5_hbox5, $page5_hbox6, $page1_hbox1, $page1_hbox3, $page1_check1_lbl, 
	    $page5_hbox9, $page5_hbox10, $page5_fn_but5, $page5_fm_label5,
	    $page1_check2_lbl, $page3_check1_lbl, $page3_check2_lbl, $page1_hbox4, $page1_check3_lbl, 
	    $page3_print, $page3_hbox6, $page3_hbox7, $page1_hbox5, $page1_hbox6, $page1_quotepre, 
	    $page1_quotewith, $page1_hbox7, $page2_scoring, $page2_hbox3, $page2_hbox4, $page2_hbox5, 
	    $page2_hbox6, $page2_sndcmd, $page2_sndfl, $page2_hbox7, $page2_dupe, $page2_sound, $tab6_label, 
	    $page6_vbox, $page6_hbox3, $page6_hbox4, $page6_hbox5, $page6_hbox6, $page6_label2, $page6_label3,
	    $page6_button2,    $page6_button3, $page6_frame1, $page6_icons, $page3_check9_lbl, $page3_check10_lbl, 
	    $page3_check11_lbl, $page3_check12_lbl, $page3_check13_lbl, $page3_check3_lbl, $page3_hbox8,  $page3_hbox9, 
	    $page3_hbox10, $page3_hbox11, $page3_hbox12, $page3_hbox13, $tab7_label, $page7_vbox, $page2_hbox8,
       	    $page7_proxy, $page7_proxyport, $page7_hbox1, $page7_hbox2, $page7_hbox3, $page7_homepage, $page1_hbox8,
            $page1_check4_lbl, $page1_hbox9, $page1_check5_lbl, $page2_check, $page2_hbox,
    	    $page5_checkbox,$page5_check_label,$page2_check3, $page2_check4,$page2_hbox9);


	$main = new Gtk::Window("toplevel");
	$main->set_title(_("Pronto Configuration"));
	$main->set_default_size(&main::get_win_size("config",500,330));
	$main->position(-mouse);
	$main->signal_connect("destroy" => sub {$main->destroy;});
	$main->signal_connect("delete_event" => \&Gtk::false);
	$notebook = new Gtk::Notebook;

	#  Page One of Notebook
	$tab1_label = new Gtk::Label(_("Send"));
	$notebook->{'forksend'} = new Gtk::CheckButton();
	my $forklabel = new Gtk::Label(_("Fork Send process?"));
	if ($main::prefs{'forksend'} == 0) { $notebook->{'forksend'}->set_active(0) }
	if ($main::prefs{'forksend'} == 1) { $notebook->{'forksend'}->set_active(1) }
        $page1_hbox = new Gtk::HBox(0,5);
	$page1_hbox->pack_start($notebook->{'forksend'},0,0,0);
	$page1_hbox->pack_start($forklabel,0,0,0);
	$notebook->{'SendImmediately'} = new Gtk::CheckButton();
	if ($main::prefs{'SendImmediately'} eq "y") { $notebook->{'SendImmediately'}->set_active('1'); }
	if ($main::prefs{'SendImmediately'} eq "n") { $notebook->{'SendImmediately'}->set_active('0'); }
	$notebook->{'SendImmediately'}->set_usize(16,17);
	$page1_check1_lbl = new Gtk::Label(_("Send Messages Immediately?"));
	$page1_check1_lbl->set_alignment(0.0,0.5);
	$page1_hbox1 = new Gtk::HBox(0,5);
	$page1_hbox1->pack_start($notebook->{'SendImmediately'},0,0,0);
	$page1_hbox1->pack_start($page1_check1_lbl,0,0,0);
	$notebook->{'AddReplytoAB'} = new Gtk::CheckButton();
	if ($main::prefs{'AddReplytoAB'} eq "y") { $notebook->{'AddReplytoAB'}->set_active('1'); }	
	if ($main::prefs{'AddReplytoAB'} eq "n") { $notebook->{'AddReplytoAB'}->set_active('0'); }
	$notebook->{'AddReplytoAB'}->set_usize(16,17);
	$page1_check2_lbl = new Gtk::Label(_("Automatically put people I reply to in my addressbook?"));
	$page1_check2_lbl->set_alignment(0.0,0.5);
	$page1_hbox2 = new Gtk::HBox(0,5);
	$page1_hbox2->pack_start($notebook->{'AddReplytoAB'},0,0,0);
	$page1_hbox2->pack_start($page1_check2_lbl,0,0,0);
	$notebook->{'ForwardAttachments'} = new Gtk::CheckButton();
	if ($main::prefs{'ForwardAttachments'} eq "y") { $notebook->{'ForwardAttachments'}->set_active('1'); }
	if ($main::prefs{'ForwardAttachments'} eq "n") { $notebook->{'ForwardAttachments'}->set_active('0'); }
	$notebook->{'ForwardAttachments'}->set_usize(16,17);
	$page1_check3_lbl = new Gtk::Label(_("Forward Attachments?"));
	$page1_check3_lbl->set_alignment(0.0,0.5);
	$page1_hbox3 = new Gtk::HBox(0,5);
	$page1_hbox3->pack_start($notebook->{'ForwardAttachments'},0,0,0);
	$page1_hbox3->pack_start($page1_check3_lbl,0,0,0);
	$notebook->{'ForwardHeader'} = new Gtk::CheckButton();
	if ($main::prefs{'ForwardHeader'} eq "y") { $notebook->{'ForwardHeader'}->set_active('1'); }
	if ($main::prefs{'ForwardHeader'} eq "n") { $notebook->{'ForwardHeader'}->set_active('0'); }
	$notebook->{'ForwardHeader'}->set_usize(16,17);
	$page1_check4_lbl = new Gtk::Label(_("When Forwarding, include a brief header?"));
	$page1_check4_lbl->set_alignment(0.0,0.5);
	$page1_hbox8 = new Gtk::HBox(0,5);
	$page1_hbox8->pack_start($notebook->{'ForwardHeader'},0,0,0);
	$page1_hbox8->pack_start($page1_check4_lbl,0,0,0);
	$notebook->{'autospell'} = new Gtk::CheckButton();
	if ($main::prefs{'autospell'} eq "y") { $notebook->{'autospell'}->set_active('1'); }
	if ($main::prefs{'autospell'} eq "n") { $notebook->{'autospell'}->set_active('0'); }
	$notebook->{'autospell'}->set_usize(16,17);
	$page1_check5_lbl = new Gtk::Label(_("Check Spelling on Send?"));
	$page1_check5_lbl->set_alignment(0.0,0.5);
	$page1_hbox9 = new Gtk::HBox(0,5);
	$page1_hbox9->pack_start($notebook->{'autospell'},0,0,0);
	$page1_hbox9->pack_start($page1_check5_lbl,0,0,0);
	$page1_wrap = new Gtk::Label(_("Wrap after how many columns"));
	$page1_wrap->set_alignment(0.0,0.5);
       	$notebook->{'WrapAfter'} = new Gtk::Entry;
	$notebook->{'WrapAfter'}->set_text($main::prefs{'WrapAfter'});
	$notebook->{'WrapAfter'}->set_editable('1');
	$notebook->{'WrapAfter'}->set_usize(45,22);
	$page1_hbox4 = new Gtk::HBox(0,5);
	$page1_hbox4->pack_start($page1_wrap,0,0,5);
	$page1_hbox4->pack_start($notebook->{'WrapAfter'},0,0,5);
	$page1_quotepre = new Gtk::Label(_("Put the following line in front of Quoted Messages:\n(%n, %d, %s and %t  will be replaced with Name, Date, Subject and SentTo)"));
	$page1_quotepre->set_usize(400,40);
	$page1_quotepre->set_alignment(0.0,0.5);
	$page1_quotepre->set_line_wrap(1);
	$page1_hbox5 = new Gtk::HBox(0,5);
	$page1_hbox5->pack_start($page1_quotepre,0,0,5);
	$notebook->{'QuoteHeader'} = new Gtk::Text(undef, undef);
	$notebook->{'QuoteHeader'}->set_usize(400,82);
	$notebook->{'QuoteHeader'}->set_editable(1);
	$notebook->{'QuoteHeader'}->set_word_wrap(1);
	(my $Header_Text = $main::prefs{'QuoteHeader'}) =~ s/\*n/\n/g;
	$notebook->{'QuoteHeader'}->insert(undef, undef, undef, $Header_Text);
	my $QuoteHeader_vScrollbar = new Gtk::VScrollbar( $notebook->{'QuoteHeader'}->vadj );
	$page1_hbox6 = new Gtk::HBox(0,0);
	$page1_hbox6->pack_start($notebook->{'QuoteHeader'},0,0,0);
	$page1_hbox6->pack_start( $QuoteHeader_vScrollbar, 0, 0, 0);
	$QuoteHeader_vScrollbar->show();
	$page1_quotewith = new Gtk::Label(_("Quote Character?"));
	$page1_quotewith->set_alignment(0.0,0.5);
	$notebook->{'QuoteWith'} = new Gtk::Entry;
	$notebook->{'QuoteWith'}->set_text($main::prefs{'QuoteWith'});
	$notebook->{'QuoteWith'}->set_editable('1');
	$notebook->{'QuoteWith'}->set_usize(35,22);
	$page1_hbox7 = new Gtk::HBox(0,5);
	$page1_hbox7->pack_start($page1_quotewith,0,0,0);
	$page1_hbox7->pack_start($notebook->{'QuoteWith'},0,0,5);
	my $siglabel = new Gtk::Label(_("Use this application to provide my signatures instead: "));
	$notebook->{'ExternalSig'} = new Gtk::CheckButton();
	$notebook->{'ExternalSig'}->set_usize(16,17);
	$notebook->{'SigCmd'} = new Gtk::Entry;
	$notebook->{'SigCmd'}->set_usize(150,22);
	$notebook->{'SigCmd'}->set_text($main::prefs{'SigCmd'}) if (defined $main::prefs{'SigCmd'} && $main::prefs{'SigCmd'} ne "");
	$notebook->{'ExternalSig'}->signal_connect("toggled", sub { if ($notebook->{'ExternalSig'}->active) { $notebook->{'SigCmd'}->set_sensitive(1) } else { $notebook->{'SigCmd'}->set_sensitive(0); }});
	my $sigbox = new Gtk::HBox(0,5);
	$sigbox->pack_start($notebook->{'ExternalSig'},0,0,0);
	$sigbox->pack_start($siglabel,0,0,0);
	$sigbox->pack_start($notebook->{'SigCmd'},0,0,0);
	if ($main::prefs{'ExternalSig'}) { $notebook->{'ExternalSig'}->set_active(1);  }
	if (!$main::prefs{'ExternalSig'}) { $notebook->{'ExternalSig'}->set_active(0); $notebook->{'SigCmd'}->set_sensitive(0); }
	$page1_vbox = new Gtk::VBox(0,5);
	$page1_vbox->set_border_width(5);
	$page1_vbox->pack_start($page1_hbox,0,0,0);
	$page1_vbox->pack_start($page1_hbox1,0,0,0);
	$page1_vbox->pack_start($page1_hbox2,0,0,0);
	$page1_vbox->pack_start($page1_hbox3,0,0,0);
	$page1_vbox->pack_start($page1_hbox8,0,0,0);
	$page1_vbox->pack_start($page1_hbox9,0,0,0);
	$page1_vbox->pack_start($page1_hbox4,0,0,0);
	$page1_vbox->pack_start($page1_hbox5,0,0,0);
	$page1_vbox->pack_start($page1_hbox6,0,0,0);
	$page1_vbox->pack_start($page1_hbox7,0,0,0);
	$page1_vbox->pack_start($sigbox,0,0,0);

	#  Page Two of Notebook
	$tab2_label = new Gtk::Label(_("Receive"));
	$notebook->{'forkget'} = new Gtk::CheckButton();
	$forklabel = new Gtk::Label(_("Fork Get process?"));
	if ($main::prefs{'forkget'} == 0) { $notebook->{'forkget'}->set_active(0) }
	if ($main::prefs{'forkget'} == 1) { $notebook->{'forkget'}->set_active(1) }
        my $page2_hboxf = new Gtk::HBox(0,5);
	$page2_hboxf->pack_start($notebook->{'forkget'},0,0,0);
	$page2_hboxf->pack_start($forklabel,0,0,0);
	$notebook->{'CheckMailOnStartup'} = new Gtk::CheckButton();
	$notebook->{'CheckMailOnStartup'}->set_usize(16,17);
	if ($main::prefs{'CheckMailOnStartup'} eq "y") { $notebook->{'CheckMailOnStartup'}->set_active(1) }
	if ($main::prefs{'CheckMailOnStartup'} eq "n") { $notebook->{'CheckMailOnStartup'}->set_active(0) }
	$page2_check = new Gtk::Label(_("Check Mail on Startup?"));
	$page2_check->set_alignment(0.0,0.5);
	$page2_hbox = new Gtk::HBox(0,5);
	$page2_hbox->pack_start($notebook->{'CheckMailOnStartup'},0,0,0);
	$page2_hbox->pack_start($page2_check,0,0,0);
	$notebook->{'POP3Verbose'} = new Gtk::CheckButton();
	$notebook->{'POP3Verbose'}->set_usize(16,17);
	$notebook->{'POP3Verbose'}->set_active(1) if $main::prefs{'POP3Verbose'};
	my $verbose_label = new Gtk::Label(_("Verbose Error Output on pop3 check?"));
	$verbose_label->set_alignment(0.0,0.5);
	my $verbose_box = new Gtk::HBox(0,0);
	$verbose_box->pack_start($notebook->{'POP3Verbose'},0,0,0);
	$verbose_box->pack_start($verbose_label,0,0,0);		
	$page2_check1 = new Gtk::Label(_("Check mail every"));
	$page2_check1->set_alignment(0.0,0.5);
	$page2_check2 = new Gtk::Label(_("Minutes (0 to disable)"));
	$page2_check2->set_alignment(0.0,0.5);
	$notebook->{'AutoCheckTime'} = new Gtk::Entry;
	$notebook->{'AutoCheckTime'}->set_text($main::prefs{'AutoCheckTime'});
	$notebook->{'AutoCheckTime'}->set_editable('1');
	$notebook->{'AutoCheckTime'}->set_usize(45,22);

	$page2_check3 = new Gtk::Label(_("Do NOT download if message is greater than"));
	$page2_check3->set_alignment(0.0,0.5);
	$page2_check4 = new Gtk::Label(_("Kbytes (0 to disable) - POP3 only"));
	$page2_check4->set_alignment(0.0,0.5);
	$notebook->{'MaxFetchSize'} = new Gtk::Entry;
	$notebook->{'MaxFetchSize'}->set_text($main::prefs{'MaxFetchSize'});
	$notebook->{'MaxFetchSize'}->set_editable('1');
	$notebook->{'MaxFetchSize'}->set_usize(45,22);
	
		
	$page2_hbox1 = new Gtk::HBox(0,5);
	$page2_hbox1->pack_start($page2_check1,0,0,5);
	$page2_hbox1->pack_start($notebook->{'AutoCheckTime'},0,0,0);
	$page2_hbox1->pack_start($page2_check2,0,0,5);

	$page2_hbox9 = new Gtk::HBox(0,5);
	$page2_hbox9->pack_start($page2_check3,0,0,5);
	$page2_hbox9->pack_start($notebook->{'MaxFetchSize'},0,0,0);
	$page2_hbox9->pack_start($page2_check4,0,0,5);

	$notebook->{'AutoCheckProgress'} = new Gtk::CheckButton;
	$notebook->{'AutoCheckProgress'}->set_usize(16,17);
	if ($main::prefs{'AutoCheckProgress'} == 0) { $notebook->{'AutoCheckProgress'}->set_active(0); }
	if ($main::prefs{'AutoCheckProgress'} == 1) { $notebook->{'AutoCheckProgress'}->set_active(1); }
	my $acklbl = new Gtk::Label(_("Auto Check Reports Progress?"));
	my $autockbox = new Gtk::HBox(0,5);
	$autockbox->pack_start($notebook->{'AutoCheckProgress'},0,0,0);
	$autockbox->pack_start($acklbl,0,0,0);
	$page2_rr = new Gtk::Label(_("Return Receipt"));
	$page2_rr->set_alignment(0.0,0.5);
	$notebook->{'RetRecAsk'} = new Gtk::RadioButton(_("Ask"));
	$notebook->{'RetRecAlways'} = new Gtk::RadioButton(_("Always"),$notebook->{'RetRecAsk'});
	$notebook->{'RetRecNever'} = new Gtk::RadioButton(_("Never"), $notebook->{'RetRecAlways'});
	if (defined $main::prefs{'SendReceipt'} && $main::prefs{'SendReceipt'} eq "never"){
		$notebook->{'RetRecNever'}->set_active(1);
	} elsif (defined $main::prefs{'SendReceipt'} && $main::prefs{'SendReceipt'} eq "all") {
		$notebook->{'RetRecAlways'}->set_active(1);
	} else {
		$notebook->{'RetRecAsk'}->set_active(1);
	}
	$page2_hbox2 = new Gtk::HBox(0,5);
	$page2_hbox2->pack_start($page2_rr,0,0,5);
	$page2_hbox2->pack_start($notebook->{'RetRecAsk'},0,0,0);
	$page2_hbox2->pack_start($notebook->{'RetRecAlways'},0,0,0);
	$page2_hbox2->pack_start($notebook->{'RetRecNever'},0,0,0);
	my $page2_popnew= new Gtk::Label(_("Mark messages as new if they were read on the server?"));
	$notebook->{'popalwaysnew'} = new Gtk::CheckButton;
	$notebook->{'popalwaysnew'}->set_usize(16,17);
	if (defined $main::prefs{'popalwaysnew'} && $main::prefs{'popalwaysnew'} eq "y") { $notebook->{'popalwaysnew'}->set_active(1) }
	if (defined $main::prefs{'popalwaysnew'} && $main::prefs{'popalwaysnew'} eq "n") { $notebook->{'popalwaysnew'}->set_active(0) }
	my $popbox = new Gtk::HBox(0,5);
	$popbox->pack_start($notebook->{'popalwaysnew'},0,0,0);
	$popbox->pack_start($page2_popnew,0,0,0);
	$page2_scoring = new Gtk::Label(_("Use Message Scoring System?"));
	$page2_scoring->set_alignment(0.0,0.5);
	$notebook->{'Scoring'} = new Gtk::CheckButton();
	$notebook->{'Scoring'}->set_usize(16,17);
	if (defined $main::prefs{'Scoring'} && $main::prefs{'Scoring'} eq "y") {$notebook->{'Scoring'}->set_active('1'); }
	if (defined $main::prefs{'Scoring'} && $main::prefs{'Scoring'} eq "n") {$notebook->{'Scoring'}->set_active('0'); }
	$page2_hbox3 = new Gtk::HBox(0,5);
	$page2_hbox3->pack_start($notebook->{'Scoring'},0,0,0);
	$page2_hbox3->pack_start($page2_scoring,0,0,0);
	$page2_import = new Gtk::Label(_("When importing mail, mark it as new?"));
	$page2_import->set_alignment(0.0,0.5);
	$notebook->{'import'} = new Gtk::CheckButton();
	$notebook->{'import'}->set_usize(16,17);
	if (defined $main::prefs{'import'} && $main::prefs{'import'} eq "y") {$notebook->{'import'}->set_active('1'); }
	if (defined $main::prefs{'import'} && $main::prefs{'import'} eq "n") {$notebook->{'import'}->set_active('0'); }
	$page2_hbox7 =  new Gtk::HBox(0,5);
	$page2_hbox7->pack_start($notebook->{'import'},0,0,0);
	$page2_hbox7->pack_start($page2_import,0,0,0);
	$page2_dupe = new Gtk::Label(_("Dupe check mails over all accounts?"));
	$page2_dupe->set_alignment(0.0,0.5);
	$notebook->{'checkDupeOnAll'} = new Gtk::CheckButton();
	$notebook->{'checkDupeOnAll'}->set_usize(16,17);
	if (defined $main::prefs{'checkDupeOnAll'} && $main::prefs{'checkDupeOnAll'} eq "y") {$notebook->{'checkDupeOnAll'}->set_active('1'); }
	if (defined $main::prefs{'checkDupeOnAll'} && $main::prefs{'checkDupeOnAll'} eq "n") {$notebook->{'checkDupeOnAll'}->set_active('0'); }
	$page2_hbox8 =  new Gtk::HBox(0,5);
	$page2_hbox8->pack_start($notebook->{'checkDupeOnAll'},0,0,0);
	$page2_hbox8->pack_start($page2_dupe,0,0,0);
	$page2_sound = new Gtk::Label(_("Play sound if I have new mail?"));
	$page2_sound->set_alignment(0.0,0.5);
	$notebook->{'PlaySound'} = new Gtk::CheckButton();
	$notebook->{'PlaySound'}->set_usize(16,17);
	$page2_hbox4 = new Gtk::HBox(0,5);
	$page2_hbox4->pack_start($notebook->{'PlaySound'},0,0,0);
	$page2_hbox4->pack_start($page2_sound,0,0,0);
	$page2_sndcmd = new Gtk::Label(_("Sound Command:"));
	$page2_sndcmd->set_usize(90,10);
	$page2_sndcmd->set_alignment(0.0,0.5);
	$notebook->{'SndCmd'} = new Gtk::Entry;
	$notebook->{'SndCmd'}->set_usize(120,22);

	if (defined $main::prefs{'SndCmd'}) { $notebook->{'SndCmd'}->set_text($main::prefs{'SndCmd'}); }

	$page2_hbox5 = new Gtk::HBox(0,5);
	$page2_hbox5->pack_start($page2_sndcmd,0,0,5);
	$page2_hbox5->pack_start($notebook->{'SndCmd'},0,0,5);

	$page2_sndfl = new Gtk::Label(_("Sound File:"));
	$page2_sndfl->set_usize(90,10);
	$page2_sndfl->set_alignment(0.0,0.5);
	$notebook->{'SndFl'} = new Gtk::Entry;
	$notebook->{'SndFl'}->set_usize(200,22);
	
	if (defined $main::prefs{'SndFl'}) { $notebook->{'SndFl'}->set_text($main::prefs{'SndFl'}) ;}

	if (defined $main::prefs{'PlaySound'} && $main::prefs{'PlaySound'} eq "y") {
		$notebook->{'PlaySound'}->set_active('1');  
		$notebook->{'SndCmd'}->set_sensitive(1);
		$notebook->{'SndFl'}->set_sensitive(1);
       	}

	if (defined $main::prefs{'PlaySound'} && $main::prefs{'PlaySound'} eq "n") {
		$notebook->{'PlaySound'}->set_active('0'); 
		$notebook->{'SndCmd'}->set_sensitive(0);
		$notebook->{'SndFl'}->set_sensitive(0);
       	}

	$notebook->{'PlaySound'}->signal_connect("toggled", sub {
						if ($notebook->{'PlaySound'}->active) {
							$notebook->{'SndCmd'}->set_sensitive(1);
							$notebook->{'SndFl'}->set_sensitive(1);
       						  } else {
       							  $notebook->{'SndCmd'}->set_sensitive(0);
							  $notebook->{'SndFl'}->set_sensitive(0);
							  }
							});
	$page2_hbox6 = new Gtk::HBox(0,5);
	$page2_hbox6->pack_start($page2_sndfl,0,0,5);
	$page2_hbox6->pack_start($notebook->{'SndFl'},0,0,5);

	$page2_vbox = new Gtk::VBox(0,5);
	$page2_vbox->set_border_width(5);
	$page2_vbox->pack_start($page2_hboxf,0,0,0);
	$page2_vbox->pack_start($page2_hbox,0,0,0);
	$page2_vbox->pack_start($verbose_box,0,0,0);
	$page2_vbox->pack_start($page2_hbox1,0,0,0);
	$page2_vbox->pack_start($page2_hbox9,0,0,0);
	$page2_vbox->pack_start($autockbox,0,0,0);
	$page2_vbox->pack_start($page2_hbox2,0,0,0);
	$page2_vbox->pack_start($popbox,0,0,0);
	$page2_vbox->pack_start($page2_hbox3,0,0,0);
	$page2_vbox->pack_start($page2_hbox7,0,0,0);
	$page2_vbox->pack_start($page2_hbox8,0,0,0);
	$page2_vbox->pack_start($page2_hbox4,0,0,0);
	$page2_vbox->pack_start($page2_hbox5,0,0,0);
	$page2_vbox->pack_start($page2_hbox6,0,0,0);

	#  Page Three of Notebook
	$tab3_label = new Gtk::Label(_("View"));
	$notebook->{'InlineImages'} = new Gtk::CheckButton();
	if ($main::prefs{'InlineImages'} eq "y") { $notebook->{'InlineImages'}->set_active('1'); }
	if ($main::prefs{'InlineImages'} eq "n") { $notebook->{'InlineImages'}->set_active('0'); }
	$notebook->{'InlineImages'}->set_usize(16,17);
	$page3_check1_lbl = new Gtk::Label(_("Display image attachments inline in the message view window?"));
	$page3_check1_lbl->set_alignment(0.0,0.5);
	$page3_hbox1 = new Gtk::HBox(0,5);
	$page3_hbox1->pack_start($notebook->{'InlineImages'},0,0,0);
	$page3_hbox1->pack_start($page3_check1_lbl,0,0,0);
	$notebook->{'InlineAttachments'} = new Gtk::CheckButton();
	if ($main::prefs{'InlineAttachments'} eq "y") { $notebook->{'InlineAttachments'}->set_active('1'); }
	if ($main::prefs{'InlineAttachments'} eq "n") { $notebook->{'InlineAttachments'}->set_active('0'); }
	$notebook->{'InlineAttachments'}->set_usize(16,17);
	$page3_check12_lbl = new Gtk::Label(_("Display attachments inline in the message view window?"));
	$page3_check12_lbl->set_alignment(0.0,0.5);
	$page3_hbox12 = new Gtk::HBox(0,5);
	$page3_hbox12->pack_start($notebook->{'InlineAttachments'},0,0,0);
	$page3_hbox12->pack_start($page3_check12_lbl,0,0,0);
	$notebook->{'InlineIcons'} = new Gtk::CheckButton();
	if ($main::prefs{'InlineIcons'} eq "y") { $notebook->{'InlineIcons'}->set_active('1'); }
	if ($main::prefs{'InlineIcons'} eq "n") { $notebook->{'InlineIcons'}->set_active('0'); }
	$notebook->{'InlineIcons'}->set_usize(16,17);
	$page3_check13_lbl = new Gtk::Label(_("Display icons for attachments inline with the message view window?"));
	$page3_check13_lbl->set_alignment(0.0,0.5);
	$page3_hbox13 = new Gtk::HBox(0,5);
	$page3_hbox13->pack_start($notebook->{'InlineIcons'},0,0,0);
	$page3_hbox13->pack_start($page3_check13_lbl,0,0,0);
	
	$notebook->{'DeleteMarksAsRead'} = new Gtk::CheckButton();
	$notebook->{'DeleteMarksAsRead'}->set_usize(16,17); 
	if ($main::prefs{'DeleteMarksAsRead'} eq "y") { $notebook->{'DeleteMarksAsRead'}->set_active('1'); } 
	if ($main::prefs{'DeleteMarksAsRead'} eq "n") { $notebook->{'DeleteMarksAsRead'}->set_active('0'); }
	$page3_check3_lbl = new Gtk::Label(_("Deleting new messages marks them as read?"));
	$page3_check3_lbl->set_alignment(0.0,0.5);
	$page3_hbox8 = new Gtk::HBox(0,5);
	$page3_hbox8->pack_start($notebook->{'DeleteMarksAsRead'},0,0,0);
	$page3_hbox8->pack_start($page3_check3_lbl,0,0,0);
	$page3_mra1 = new Gtk::Label(_("Mark messages as read in viewpane after"));
	$page3_mra1->set_alignment(0.0,0.5);
	$notebook->{'MarkAsReadDelay'} = new Gtk::Entry;
	$notebook->{'MarkAsReadDelay'}->set_editable('1');
	$notebook->{'MarkAsReadDelay'}->set_text($main::prefs{'MarkAsReadDelay'});
	$notebook->{'MarkAsReadDelay'}->set_usize(35,22);
	$page3_mra2 = new Gtk::Label("seconds.");
	$page3_mra2->set_alignment(0.0,0.5);
	$page3_hbox3 = new Gtk::HBox(0,5);
	$page3_hbox3->pack_start($page3_mra1,0,0,5);
	$page3_hbox3->pack_start($notebook->{'MarkAsReadDelay'},0,0,0);
	$page3_hbox3->pack_start($page3_mra2,0,0,5);
	$page3_print = new Gtk::Label(_("Print Command"));
	$page3_print->set_alignment(0.0,0.5);
	$page3_print->set_usize(150,10);
	$notebook->{'PrintCommand'} = new Gtk::Entry;
	$notebook->{'PrintCommand'}->set_editable('1');
	$notebook->{'PrintCommand'}->set_text($main::prefs{'PrintCommand'});
	$notebook->{'PrintCommand'}->set_usize(170,20);
	$page3_hbox5 = new Gtk::HBox(0,5);
	$page3_hbox5->pack_start($page3_print,0,0,0);
	$page3_hbox5->pack_start($notebook->{'PrintCommand'},0,0,0);
	$page3_date = new Gtk::Label(_("Date format: (%M = Month, %d = Day, %y = 2 digit Year, %Y = 4 digit year, %h = Hour, %m = Minute, %s = Second)"));
	$page3_date->set_usize(400,38);
	$page3_date->set_line_wrap(1);
	$page3_date->set_alignment(0.0,0.5);
	$page3_hbox6 = new Gtk::HBox(0,5);
	$page3_hbox6->pack_start($page3_date,0,0,5);
	$notebook->{'DateDisplayFormat'} =  new Gtk::Entry;
	$notebook->{'DateDisplayFormat'}->set_text($main::prefs{'DateDisplayFormat'});
	$notebook->{'DateDisplayFormat'}->set_editable('1');
	$notebook->{'DateDisplayFormat'}->set_usize(200,22);
	$page3_hbox7 = new Gtk::HBox(0,5);
	$page3_hbox7->pack_start($notebook->{'DateDisplayFormat'},0,0,5);
	$notebook->{'saveSize'} = new Gtk::CheckButton();
	if ($main::prefs{'saveSize'} eq "y") { $notebook->{'saveSize'}->set_active('1'); }
	if ($main::prefs{'saveSize'} eq "n") { $notebook->{'saveSize'}->set_active('0'); }
	$notebook->{'saveSize'}->set_usize(16,17);
	$page3_check9_lbl = new Gtk::Label(_("Save window size on exit"));
	$page3_check9_lbl->set_alignment(0.0,0.5);
	$page3_hbox9 = new Gtk::HBox(0,5);
	$page3_hbox9->pack_start($notebook->{'saveSize'},0,0,0);
	$page3_hbox9->pack_start($page3_check9_lbl,0,0,0);
	$notebook->{'useAlternateViewer'} = new Gtk::CheckButton();
	if ($main::prefs{'useAlternateViewer'} eq "y") { $notebook->{'useAlternateViewer'}->set_active('1'); }
	if ($main::prefs{'useAlternateViewer'} eq "n") { $notebook->{'useAlternateViewer'}->set_active('0'); }
	$notebook->{'useAlternateViewer'}->set_usize(16,17);
	$page3_check10_lbl = new Gtk::Label(_("Use Alternate Browser with GtkHTML/CscHTML"));
	$page3_check10_lbl->set_alignment(0.0,0.5);
	$page3_hbox10 = new Gtk::HBox(0,5);
	$page3_hbox10->pack_start($notebook->{'useAlternateViewer'},0,0,0);
	$page3_hbox10->pack_start($page3_check10_lbl,0,0,0);
	$notebook->{'attachLeftView'} = new Gtk::CheckButton();
	if ($main::prefs{'attachLeftView'} eq "y") { $notebook->{'attachLeftView'}->set_active('1'); }
	if ($main::prefs{'attachLeftView'} eq "n") { $notebook->{'attachLeftView'}->set_active('0'); }
	$notebook->{'attachLeftView'}->set_usize(16,17);
	$page3_check11_lbl = new Gtk::Label(_("Left Click on Attachment opens Viewer instead of Save"));
	$page3_check11_lbl->set_alignment(0.0,0.5);
	$page3_hbox11 = new Gtk::HBox(0,5);
	$page3_hbox11->pack_start($notebook->{'attachLeftView'},0,0,0);
	$page3_hbox11->pack_start($page3_check11_lbl,0,0,0);         
	$notebook->{'ToolTips'} = new Gtk::CheckButton();
	$notebook->{'ToolTips'}->set_active(1) if $main::prefs{'ToolTips'};
	$notebook->{'ToolTips'}->set_usize(16,17);
	my $tooltips_label = new Gtk::Label(_("Enable Tooltips?"));
	my $tooltipbox = new Gtk::HBox(0,0);
	$tooltipbox->pack_start($notebook->{'ToolTips'},0,0,0);
	$tooltipbox->pack_start($tooltips_label,0,0,0);
	my ($lbl, $combobox, $combobox2);
	$lbl = new Gtk::Label(_("Start in folder:"));
	$lbl->set_usize(150,10);
	$lbl->set_alignment(0.0,0.5);
	$notebook->{'startin'} = new Gtk::Combo;
	$notebook->{'startin'}->set_popdown_strings(_("None"), keys(%main::foldernametoid));
	$notebook->{'startin'}->entry->set_text($main::prefs{'startin'});
	$combobox = new Gtk::HBox(0,5);
	$combobox->pack_start($lbl,0,0,0);
	$combobox->pack_start($notebook->{'startin'},0,0,0);
	$lbl = new Gtk::Label(_("On Folder Change, move to "));
	$lbl->set_alignment(0.0,0.5);
	$lbl->set_usize(150,10);
	$notebook->{'onfolderchange'} = new Gtk::Combo;
	$notebook->{'onfolderchange'}->set_popdown_strings("no","top","next unread");
	$notebook->{'onfolderchange'}->entry->set_text($main::prefs{'onfolderchange'});
	$combobox2 = new Gtk::HBox(0,5);
	$combobox2->pack_start($lbl,0,0,0);
	$combobox2->pack_start($notebook->{'onfolderchange'},0,0,0);
	$lbl = new Gtk::Label(_(" message of folder"));
	$lbl->set_alignment(0.0,0.5);
	$combobox2->pack_start($lbl,0,0,0);
	$page3_vbox = new Gtk::VBox(0,5);
	$page3_vbox->set_border_width(5);
	$page3_vbox->pack_start($page3_hbox1,0,0,0);
	$page3_vbox->pack_start($page3_hbox12,0,0,0);
	$page3_vbox->pack_start($page3_hbox13,0,0,0);
	$page3_vbox->pack_start($page3_hbox8,0,0,0);
	$page3_vbox->pack_start($page3_hbox9,0,0,0);
	$page3_vbox->pack_start($page3_hbox10,0,0,0);
	$page3_vbox->pack_start($page3_hbox11,0,0,0);
	$page3_vbox->pack_start($tooltipbox,0,0,0);
	$page3_vbox->pack_start($page3_hbox3,0,0,0);
	$page3_vbox->pack_start($page3_hbox5,0,0,0);
	$page3_vbox->pack_start($combobox,0,0,0);
	$page3_vbox->pack_start($combobox2,0,0,0);
	$page3_vbox->pack_start($page3_hbox6,0,0,0);
	$page3_vbox->pack_start($page3_hbox7,0,0,0);

	#  Page Four of Notebook
	$tab4_label = new Gtk::Label("Database");
	$page4_label = new Gtk::Label(_("Database Driver (CSV, Pg, mysql..)"));
	$page4_label->set_usize(200,10);
	$page4_label->set_alignment(0.0,0.5);
	$notebook->{'DatabaseDriver'} = new Gtk::Entry;
	$notebook->{'DatabaseDriver'}->set_editable('1');
	$notebook->{'DatabaseDriver'}->set_text($main::prefs{'DatabaseDriver'});
	$page4_hbox1 = new Gtk::HBox(0,5);
	$page4_hbox1->pack_start($page4_label,0,0,5);
	$page4_hbox1->pack_start($notebook->{'DatabaseDriver'},0,0,5);
	$page4_label2 = new Gtk::Label(_("Database Username"));
	$page4_label2->set_usize(200,10);
	$page4_label2->set_alignment(0.0,0.5);
	$notebook->{'DatabaseUser'} = new Gtk::Entry;
	$notebook->{'DatabaseUser'}->set_editable('1');
	if (defined $main::prefs{'DatabaseUser'}) {
		$notebook->{'DatabaseUser'}->set_text($main::prefs{'DatabaseUser'});
	}
	$page4_hbox2 = new Gtk::HBox(0,5);
	$page4_hbox2->pack_start($page4_label2,0,0,5);
	$page4_hbox2->pack_start($notebook->{'DatabaseUser'},0,0,5);
	$page4_label3 = new Gtk::Label(_("Database Username Password"));
	$page4_label3->set_usize(200,10);
	$page4_label3->set_alignment(0.0,0.5);
	$notebook->{'DatabasePassword'} = new Gtk::Entry;
	$notebook->{'DatabasePassword'}->set_editable('1');
	$notebook->{'DatabasePassword'}->set_visibility('0');
	if (defined $main::prefs{'DatabasePassword'}) {
		$notebook->{'DatabasePassword'}->set_text($main::prefs{'DatabasePassword'});
	}
		
	$page4_hbox3 = new Gtk::HBox(0,5);
	$page4_hbox3->pack_start($page4_label3,0,0,5);
	$page4_hbox3->pack_start($notebook->{'DatabasePassword'},0,0,5);
	my $hostlabel = new Gtk::Label(_("Database Host"));
	$hostlabel->set_alignment(0.0,0.5);
	$hostlabel->set_usize(200,10);
	$notebook->{'DatabaseHost'} = new Gtk::Entry;
	$notebook->{'DatabaseHost'}->set_text($main::prefs{'DatabaseHost'});	
	my $page4_hbox4 = new Gtk::HBox(0,5);
	$page4_hbox4->pack_start($hostlabel,0,0,5);
	$page4_hbox4->pack_start($notebook->{'DatabaseHost'},0,0,5);
	my $portlabel = new Gtk::Label(_("Database Port"));
	$portlabel->set_alignment(0.0,0.5);
	$portlabel->set_usize(200,10);
	$notebook->{'MySQLPort'} = new Gtk::Entry;
	$notebook->{'MySQLPort'}->set_text($main::prefs{'MySQLPort'}) if $main::prefs{'DatabaseDriver'} eq "mysql";
	$notebook->{'MySQLPort'}->set_text($main::prefs{'PgSQLPort'}) if $main::prefs{'DatabaseDriver'} eq "Pg";
	my $portbox = new Gtk::HBox(0,5);
	$portbox->pack_start($portlabel,0,0,5);
	$portbox->pack_start($notebook->{'MySQLPort'},0,0,5);
	$notebook->{'MsgInDB'} = new Gtk::CheckButton();
	if ($main::prefs{'MsgInDB'} eq "y") { $notebook->{'MsgInDB'}->set_active(1) }
	if ($main::prefs{'MsgInDB'} eq "n") { $notebook->{'MsgInDB'}->set_active(0); }	
	my $storeindb = new Gtk::Label(_("Store Messages in DB?"));
	$storeindb->set_usize(200,10);
	$storeindb->set_alignment(0.0,0.5);
	
	my $page4_hbox5 = new Gtk::HBox(0,5);
	$page4_hbox5->pack_start($notebook->{'MsgInDB'},0,0,5);
	$page4_hbox5->pack_start($storeindb,0,0,0);
	
	$notebook->{'empty_trash_on_exit'} = new Gtk::CheckButton();
	my $del_label = new Gtk::Label(_("Empty the contents of Deleted Items on exit?"));
	$del_label->set_alignment(0.0,0.5);
	if ($main::prefs{'empty_trash_on_exit'}) { $notebook->{'empty_trash_on_exit'}->set_active(1) }
	if (!$main::prefs{'empty_trash_on_exit'}) { $notebook->{'empty_trash_on_exit'}->set_active(0) }
	
	my $page4_hbox6 = new Gtk::HBox(0,5);
	$page4_hbox6->pack_start($notebook->{'empty_trash_on_exit'},0,0,5);
	$page4_hbox6->pack_start($del_label,0,0,0);
	
	
	$page4_vbox = new Gtk::VBox(0,5);
	$page4_vbox->set_border_width(5);
	$page4_vbox->pack_start($page4_hbox1,0,0,0);
	$page4_vbox->pack_start($page4_hbox2,0,0,0);
	$page4_vbox->pack_start($page4_hbox3,0,0,0);
	$page4_vbox->pack_start($page4_hbox4,0,0,0);
	$page4_vbox->pack_start($portbox,0,0,0);
	$page4_vbox->pack_start($page4_hbox5,0,0,0);
	$page4_vbox->pack_start($page4_hbox6,0,0,0);
	
	if ($main::prefs{'DatabaseDriver'} eq "CSV") {
		$notebook->{'DatabaseHost'}->set_sensitive(0);
		$notebook->{'MsgInDB'}->set_sensitive(0);
		$storeindb->set_sensitive(0);
		$notebook->{'MySQLPort'}->set_sensitive(0);
		$portlabel->set_sensitive(0);
	}	
	
	#  Page Five of Notebook
	$tab5_label = new Gtk::Label(_("Fonts"));
	$notebook->{'BoldMsg'} = new Gtk::CheckButton();
	if ($main::prefs{'BoldMsg'}) { 
		$notebook->{'BoldMsg'}->set_active(1); 
       	} else {
		$notebook->{'BoldMsg'}->set_active(0);
	}
	my $page5_lbl = new Gtk::Label(_("Change Message Font if its new?"));
	$page5_lbl->set_alignment(0.0,0.5);
	my $page5_hbox = new Gtk::HBox(0,5);
	$page5_hbox->pack_start($notebook->{'BoldMsg'},0,0,0);
	$page5_hbox->pack_start($page5_lbl,0,0,0);
	$notebook->{'FolderNewBold'} = new Gtk::CheckButton();
	if ($main::prefs{'FolderNewBold'} eq "y") { $notebook->{'FolderNewBold'}->set_active('1'); }
	if ($main::prefs{'FolderNewBold'} eq "n") { $notebook->{'FolderNewBold'}->set_active('0'); }
	$notebook->{'FolderNewBold'}->set_usize(16,17);
	$page3_check2_lbl = new Gtk::Label(_("Change folder font if it contains new mail?"));
	$page3_check2_lbl->set_alignment(0.0,0.5);
	$page3_hbox2 = new Gtk::HBox(0,5);
	$page3_hbox2->pack_start($notebook->{'FolderNewBold'},0,0,0);
	$page3_hbox2->pack_start($page3_check2_lbl,0,0,0);
	$page5_fm_label = new Gtk::Label(_("Font used for new items:"));
	$page5_fm_label->set_alignment(0.0,0.5);
	$page5_hbox1 = new Gtk::HBox(0,5);
	$page5_hbox1->pack_start($page5_fm_label,0,0,5);
	$notebook->{'FontMLBold'} = new Gtk::Entry;
	$notebook->{'FontMLBold'}->set_editable('0');
	$notebook->{'FontMLBold'}->set_text($main::prefs{'FontMLBold'});
	$page5_fn_but = new Gtk::Button(_("Change"));
	$page5_fn_but->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontMLBold'});
	$page5_fn_but->set_usize(55,25);
	$page5_hbox2 = new Gtk::HBox(0,5);
	$page5_hbox2->pack_start($notebook->{'FontMLBold'},1,1,5);
	$page5_hbox2->pack_end($page5_fn_but,0,0,5);
	$page5_fm_label2 = new Gtk::Label(_("Font used for normal items:"));
	$page5_fm_label2->set_alignment(0.0,0.5);
	$page5_hbox3 = new Gtk::HBox(0,5);
	$page5_hbox3->pack_start($page5_fm_label2,0,0,5);
	$notebook->{'FontMLNormal'} = new Gtk::Entry;
	$notebook->{'FontMLNormal'}->set_editable('0');
	$notebook->{'FontMLNormal'}->set_text($main::prefs{'FontMLNormal'});
	$page5_fn_but2 = new Gtk::Button(_("Change"));
	$page5_fn_but2->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontMLNormal'});
	$page5_fn_but2->set_usize(55,25);
	$page5_hbox4 = new Gtk::HBox(0,5);
	$page5_hbox4->pack_start($notebook->{'FontMLNormal'},1,1,5);
	$page5_hbox4->pack_end($page5_fn_but2,0,0,5);
	$page5_fm_label3 = new Gtk::Label(_("Font used to display messages (CscHTML only)"));
	$page5_fm_label3->set_alignment(0.0,0.5);
	$page5_hbox5 = new Gtk::HBox(0,5);
	$page5_hbox5->pack_start($page5_fm_label3,0,0,5);
	$notebook->{'FontMessages'} = new Gtk::Entry;
	$notebook->{'FontMessages'}->set_text($main::prefs{'FontMessages'});
	$notebook->{'FontMessages'}->set_editable('0');
	$page5_fn_but3 = new Gtk::Button(_("Change"));
	$page5_fn_but3->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontMessages'});
	$page5_fn_but3->set_usize(55,25);
	$page5_hbox6 =  new Gtk::HBox(0,5);
	$page5_hbox6->pack_start($notebook->{'FontMessages'},1,1,5);
	$page5_hbox6->pack_end($page5_fn_but3,0,0,5);
	$notebook->{'FontSwitch'} = new Gtk::CheckButton;
	$notebook->{'FontSwitch'}->set_usize(16,17);
	my $page5_checkbox2 = new Gtk::HBox(0,5);
	$page5_checkbox2->pack_start($notebook->{'FontSwitch'},0,0,0);
	my $page5_check_label2 = new Gtk::Label(_("Allow messages to switch fonts?"));
	$page5_check_label2->set_alignment(0.0,0.5);
	$page5_checkbox2->pack_start($page5_check_label2,0,0,0);
	$notebook->{'FontSwitch'}->set_active($main::prefs{'FontSwitch'});
	$page5_fm_label4 = new Gtk::Label(_("Font used for labels in the Header Panel"));
	$page5_fm_label4->set_alignment(0.0,0.5);
	$page5_hbox7 = new Gtk::HBox(0,5);
	$page5_hbox7->pack_start($page5_fm_label4,0,0,5);
	$notebook->{'FontUIBold'} = new Gtk::Entry;
	$notebook->{'FontUIBold'}->set_editable('0');
	$notebook->{'FontUIBold'}->set_text($main::prefs{'FontUIBold'});
	$page5_fn_but4 = new Gtk::Button(_("Change"));
	$page5_fn_but4->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontUIBold'});
	$page5_fn_but4->set_usize(55,25);
	$page5_hbox8 = new Gtk::HBox(0,5);
	$page5_hbox8->pack_start($notebook->{'FontUIBold'},1,1,5);
	$page5_hbox8->pack_end($page5_fn_but4,0,0,5);
	$notebook->{'useGtkFontComposer'} = new Gtk::CheckButton;
	$notebook->{'useGtkFontComposer'}->set_usize(16,17);
	$page5_checkbox = new Gtk::HBox(0,5);
	$page5_checkbox->pack_start($notebook->{'useGtkFontComposer'},0,0,0);
	$page5_check_label = new Gtk::Label(_("Use my Gtk font in the composer window"));
	$page5_check_label->set_alignment(0.0,0.5);
	$page5_checkbox->pack_start($page5_check_label,0,0,0);
	$page5_fm_label5 = new Gtk::Label(_("Font used for the Message Composer"));
	$page5_fm_label5->set_alignment(0.0,0.5);
	$page5_hbox9 = new Gtk::HBox(0,5);
	$page5_hbox9->pack_start($page5_fm_label5,0,0,5);
	$notebook->{'FontComposer'} = new Gtk::Entry;
	$notebook->{'FontComposer'}->set_editable(0);
	$notebook->{'FontComposer'}->set_text($main::prefs{'FontComposer'});
	$page5_fn_but5 = new Gtk::Button(_("Change"));
	$page5_fn_but5->signal_connect("clicked" => \&init_font_dlg, $notebook->{'FontComposer'});
	$page5_fn_but5->set_usize(55,25);
	$page5_hbox10 = new Gtk::HBox(0,5);
	$page5_hbox10->pack_start($notebook->{'FontComposer'},1,1,5);
	$page5_hbox10->pack_end($page5_fn_but5,0,0,5);
	if ($main::HTMLWIDGET ne "CscHTML") {
		$notebook->{'FontSwitch'}->set_sensitive(0);
		$notebook->{'FontMessages'}->set_sensitive(0);
		$page5_fn_but3->set_sensitive(0)
	}
	if ($main::prefs{'useGtkFontComposer'} eq "y") { 
				$notebook->{'useGtkFontComposer'}->set_active(1); 
				$notebook->{'FontComposer'}->set_sensitive(0);
				$page5_fn_but5->set_sensitive(0);
	}
	if ($main::prefs{'useGtkFontComposer'} eq "n") { $notebook->{'useGtkFontComposer'}->set_active(0) }
	$notebook->{'useGtkFontComposer'}->signal_connect("toggled", sub { 
			if ($notebook->{'useGtkFontComposer'}->active) {
				$notebook->{'FontComposer'}->set_sensitive(0); 
				$page5_fn_but5->set_sensitive(0);
			} else {
				$notebook->{'FontComposer'}->set_sensitive(1);
				$page5_fn_but5->set_sensitive(1);
			}});

	$page5_vbox = new Gtk::VBox(0,5);
	$page5_vbox->set_border_width(5);
	$page5_vbox->pack_start($page5_hbox,0,0,0);
	$page5_vbox->pack_start($page3_hbox2,0,0,0);
	$page5_vbox->pack_start($page5_hbox1,0,0,0);
	$page5_vbox->pack_start($page5_hbox2,0,0,0);
	$page5_vbox->pack_start($page5_hbox3,0,0,0);
	$page5_vbox->pack_start($page5_hbox4,0,0,0);
	$page5_vbox->pack_start($page5_hbox5,0,0,0);
	$page5_vbox->pack_start($page5_hbox6,0,0,0);
	$page5_vbox->pack_start($page5_checkbox2,0,0,0);
	$page5_vbox->pack_start($page5_hbox7,0,0,0);
	$page5_vbox->pack_start($page5_hbox8,0,0,0);
	$page5_vbox->pack_start($page5_checkbox,0,0,0);
	$page5_vbox->pack_start($page5_hbox9,0,0,0);
	$page5_vbox->pack_start($page5_hbox10,0,0,0);

	# page 6
	$tab6_label=new Gtk::Label(_("Paths"));
	$page6_label2=new Gtk::Label(_("Ispell or Aspell Path"));
	$page6_label2->set_alignment(0.0,0.5);
	$page6_hbox3=new Gtk::HBox(0,5);
	$page6_hbox3->pack_start($page6_label2,0,0,5);
	$notebook->{'ispellpath'} = new Gtk::Entry;
	$notebook->{'ispellpath'}->set_text($main::prefs{'ispellpath'});
	$page6_button2=new Gtk::Button(_("Browse"));
	$page6_button2->signal_connect("clicked" => \&init_browse_dlg, $notebook->{'ispellpath'}, "ispell_path");
	$page6_button2->set_usize(55,25);
	$page6_hbox4=new Gtk::HBox(0,5);
	$page6_hbox4->pack_start($notebook->{'ispellpath'},1,1,5);
	$page6_hbox4->pack_end($page6_button2,0,0,5);
	$page6_label3 = new Gtk::Label(_("Path to URL Viewer (XmHTML and Alternate Viewer for GtkHTML/CscHTML)"));
	$page6_label3->set_alignment(0.0,0.5);
	$page6_hbox5 = new Gtk::HBox(0,5);
	$page6_hbox5->pack_start($page6_label3,0,0,5);
	$notebook->{'ViewerPath'} = new Gtk::Entry;
	$notebook->{'ViewerPath'}->set_text($main::prefs{'ViewerPath'});
	$page6_button3=new Gtk::Button(_("Browse"));
	$page6_button3->signal_connect("clicked" => \&init_browse_dlg, $notebook->{'ViewerPath'}, "viewer_path");
	$page6_button3->set_usize(55,25);
	$page6_hbox6=new Gtk::HBox(0,5);
	$page6_hbox6->pack_start($notebook->{'ViewerPath'},1,1,5);
	$page6_hbox6->pack_end($page6_button3,0,0,5);
	my $page6_label4 = new Gtk::Label(_("Path to GPG"));
	$page6_label4->set_alignment(0.0,0.5);
	my $page6_hbox7 = new Gtk::HBox(0,5);
	$page6_hbox7->pack_start($page6_label4,0,0,5);
	$notebook->{'gpgpath'} = new Gtk::Entry;
	$notebook->{'gpgpath'}->set_text($main::prefs{'gpgpath'});
	my $page6_button4=new Gtk::Button(_("Browse"));
	$page6_button4->signal_connect("clicked" => \&init_browse_dlg, $notebook->{'ViewerPath'}, "gpg_path");
	$page6_button4->set_usize(55,25);
	my $page6_hbox8=new Gtk::HBox(0,5);
	$page6_hbox8->pack_start($notebook->{'gpgpath'},1,1,5);
	$page6_hbox8->pack_end($page6_button4,0,0,5);
	$page6_vbox = new Gtk::VBox(0,5);
	$page6_vbox->set_border_width(5);
	$page6_vbox->pack_start($page6_hbox3,0,0,0);
	$page6_vbox->pack_start($page6_hbox4,0,0,0);
	$page6_vbox->pack_start($page6_hbox5,0,0,0);
	$page6_vbox->pack_start($page6_hbox6,0,0,0);
	$page6_vbox->pack_start($page6_hbox7,0,0,0);
	$page6_vbox->pack_start($page6_hbox8,0,0,0);
	# page 7
	$tab7_label=new Gtk::Label(_("Web Browser"));
	$page7_homepage = new Gtk::Label(_("Homepage"));
	$page7_homepage->set_usize(90,10);
	$page7_homepage->set_alignment(0.0,0.5);
	$notebook->{'HomePage'} =  new Gtk::Entry;
	$notebook->{'HomePage'}->set_text($main::prefs{'HomePage'});
	$notebook->{'HomePage'}->set_usize(250,22);
	$page7_hbox1 = new Gtk::HBox(0,5);
	$page7_hbox1->pack_start($page7_homepage,0,0,5);
	$page7_hbox1->pack_start($notebook->{'HomePage'},0,0,5);
	$page7_proxy=new Gtk::Label(_("Proxy Server"));
	$page7_proxy->set_usize(90,10);
	$page7_proxy->set_alignment(0.0,0.5);
	$notebook->{'Proxy'} = new Gtk::Entry;
	$notebook->{'Proxy'}->set_usize(250,22);

	if (defined $main::prefs{'Proxy'}) {
		$notebook->{'Proxy'}->set_text($main::prefs{'Proxy'});
	}
	$page7_hbox2=new Gtk::HBox(0,5);
	$page7_hbox2->pack_start($page7_proxy,0,0,5);
	$page7_hbox2->pack_start($notebook->{'Proxy'},0,0,5);
	$page7_proxyport=new Gtk::Label(_("Proxy Port"));
	$page7_proxyport->set_usize(90,10);
	$page7_proxyport->set_alignment(0.0,0.5);
	$notebook->{'ProxyPort'} = new Gtk::Entry;
	$notebook->{'ProxyPort'}->set_usize(50,22);
	if (defined $main::prefs{'ProxyPort'}) {
		$notebook->{'ProxyPort'}->set_text($main::prefs{'ProxyPort'});
	}
	$page7_hbox3=new Gtk::HBox(0,5);
	$page7_hbox3->pack_start($page7_proxyport,0,0,5);
	$page7_hbox3->pack_start($notebook->{'ProxyPort'},0,0,5);
	$page7_vbox = new Gtk::VBox(0,5);
	$page7_vbox->set_border_width(5);
	$page7_vbox->pack_start($page7_hbox1,0,0,0);
	$page7_vbox->pack_start($page7_hbox2,0,0,0);
	$page7_vbox->pack_start($page7_hbox3,0,0,0);

	#page8
	my ($tab8_label, $msg_label, $color1_label, $color1_button, 
	$color2_label, $color2_button,$color3_label, $color3_button, $color4_label, $color4_button, $color5_label, $color5_button, $quote_lbl, 
	$page8_hbox, $page8_hbox1, $page8_hbox2, $page8_hbox3, $page8_hbox4, $page8_hbox5, $page8_hbox6, 
	$page8_vbox, $default);

	$tab8_label=new Gtk::Label(_("Msg Colors/etc"));
	$notebook->{'msgcolors'} = new Gtk::CheckButton;
	$notebook->{'msgcolors'}->set_usize(16,17);
	if ($main::prefs{'UseMessageColors'} eq "y") { $notebook->{'msgcolors'}->set_active(1)}
	if ($main::prefs{'UseMessageColors'} eq "n") { $notebook->{'msgcolors'}->set_active(0) }
	$msg_label = new Gtk::Label(_("Colorize Messages?"));
	$msg_label->set_alignment(0.0,0.5);
	$page8_hbox = new Gtk::HBox(0,5);
	$page8_hbox->pack_start($notebook->{'msgcolors'},0,0,0);
	$page8_hbox->pack_start($msg_label,0,0,0);
	$page8_vbox = new Gtk::VBox(0,5);
	$page8_vbox->set_border_width(5);
	my $colorlimit = new Gtk::Label(_("Don't colorize Messages bigger than  "));
	$notebook->{'MaxLength'} = new Gtk::Entry;
	$notebook->{'MaxLength'}->set_usize(60,22);
	$notebook->{'MaxLength'}->set_text($main::prefs{'UseMessageColorsMaxLength'});
	my $colorlimit2 = new Gtk::Label(_(" chars ..."));
	my $colorlimit_hbox = new Gtk::HBox(0,5);
	$colorlimit_hbox->pack_start($colorlimit,0,0,0);
	$colorlimit_hbox->pack_start($notebook->{'MaxLength'},0,0,0);
	$colorlimit_hbox->pack_start($colorlimit2,0,0,0);
	$quote_lbl = new Gtk::Label(_("Color replies based on these symbols, seperate by commas."));
	$quote_lbl->set_alignment(0.0,0.5);
	$notebook->{'QuoteSymbol'} = new Gtk::Entry;
	$notebook->{'QuoteSymbol'}->set_usize(60,22);
	$notebook->{'QuoteSymbol'}->set_text($main::prefs{'QuoteSymbols'});
	$notebook->{'QuoteSymbol'}->set_editable(1);
	$page8_hbox1 = new Gtk::HBox(0,5);
	$page8_hbox1->pack_start($quote_lbl,0,0,0);
	$page8_hbox1->pack_start($notebook->{'QuoteSymbol'},0,0,0);
	my $arrow_label = new Gtk::Label(_("Use this symbol instead of the  subjects in  threads when I have it turned on."));
	$arrow_label->set_alignment(0.0,0.5);
	$notebook->{'threadarrow'} = new Gtk::Entry;
	$notebook->{'threadarrow'}->set_text($main::prefs{'threadarrow'});
	$notebook->{'threadarrow'}->set_usize(40,22);
	my $arrowbox = new Gtk::HBox(0,5);
	$arrowbox->pack_start($arrow_label,0,0,0);
	$arrowbox->pack_start($notebook->{'threadarrow'},0,0,0);
	$color1_label = new Gtk::Label(_("Message Color "));
	$color1_label->set_alignment(0.0,0.5);
	$color1_label->set_usize(80,10);
	$notebook->{'MessageColor'} = new Gtk::Entry;
	$notebook->{'MessageColor'}->set_editable(1);
	$notebook->{'MessageColor'}->set_text($main::prefs{'MessageColor'});
	$notebook->{'MessageColor'}->set_usize(60,22);
	$color1_button = new Gtk::Button(_("Change"));
	$color1_button->signal_connect("clicked" => \&select_color, $notebook->{'MessageColor'}, "message");
	$default->{'color1'} = new Gtk::Button(_("Default"));
	$default->{'color1'}->signal_connect("clicked", sub { $notebook->{'MessageColor'}->set_text("000000")});
	$page8_hbox2 = new Gtk::HBox(0,5);
	$page8_hbox2->pack_start($color1_label,0,0,0);
	$page8_hbox2->pack_start($notebook->{'MessageColor'},0,0,0);
	$page8_hbox2->pack_start($color1_button,0,0,0);
	$page8_hbox2->pack_start($default->{'color1'},0,0,0);
	$color2_label= new Gtk::Label(_("Quote Color 1"));
	$color2_label->set_alignment(0.0,0.5);
	$color2_label->set_usize(80,10);
	$notebook->{'QuoteColor1'} = new Gtk::Entry;
	$notebook->{'QuoteColor1'}->set_text($main::prefs{'QuoteColor1'});
	$notebook->{'QuoteColor1'}->set_usize(60,22);
	$notebook->{'QuoteColor1'}->set_editable(1);
	$color2_button = new Gtk::Button(_("Change"));
	$color2_button->signal_connect("clicked" => \&select_color, $notebook->{'QuoteColor1'}, "quote1");
	$default->{'color2'} = new Gtk::Button(_("Default"));
	$default->{'color2'}->signal_connect("clicked", sub { $notebook->{'QuoteColor1'}->set_text("FF0000");});
	$page8_hbox3 = new Gtk::HBox(0,5);
	$page8_hbox3->pack_start($color2_label,0,0,0);
	$page8_hbox3->pack_start($notebook->{'QuoteColor1'},0,0,0);
	$page8_hbox3->pack_start($color2_button,0,0,0);
	$page8_hbox3->pack_start($default->{'color2'},0,0,0);
	$color3_label= new Gtk::Label(_("Quote Color 2"));
	$color3_label->set_alignment(0.0,0.5);
	$color3_label->set_usize(80,10);
	$notebook->{'QuoteColor2'} = new Gtk::Entry;
	$notebook->{'QuoteColor2'}->set_text($main::prefs{'QuoteColor2'});
	$notebook->{'QuoteColor2'}->set_usize(60,22);
	$notebook->{'QuoteColor2'}->set_editable(1);
	$color3_button = new Gtk::Button(_("Change"));
	$color3_button->signal_connect("clicked" => \&select_color, $notebook->{'QuoteColor2'}, "quote2");
	$default->{'color3'} = new Gtk::Button(_("Default"));
	$default->{'color3'}->signal_connect("clicked", sub { $notebook->{'QuoteColor2'}->set_text("0000FF");});
	$page8_hbox4 = new Gtk::HBox(0,5);
	$page8_hbox4->pack_start($color3_label,0,0,0);
	$page8_hbox4->pack_start($notebook->{'QuoteColor2'},0,0,0);
	$page8_hbox4->pack_start($color3_button,0,0,0);
	$page8_hbox4->pack_start($default->{'color3'},0,0,0);
	$color4_label= new Gtk::Label(_("Quote Color 3"));
	$color4_label->set_usize(80,10);
	$color4_label->set_alignment(0.0,0.5);
	$notebook->{'QuoteColor3'} = new Gtk::Entry;
	$notebook->{'QuoteColor3'}->set_text($main::prefs{'QuoteColor3'});
	$notebook->{'QuoteColor3'}->set_usize(60,22);
	$notebook->{'QuoteColor3'}->set_editable(1);
	$color4_button = new Gtk::Button(_("Change"));
	$color4_button->signal_connect("clicked" => \&select_color, $notebook->{'QuoteColor3'}, "quote3");
	$default->{'color4'} = new Gtk::Button(_("Default"));
	$default->{'color4'}->signal_connect("clicked", sub { $notebook->{'QuoteColor3'}->set_text("FF00FF");});
	$page8_hbox5 = new Gtk::HBox(0,5);
	$page8_hbox5->pack_start($color4_label,0,0,0);
	$page8_hbox5->pack_start($notebook->{'QuoteColor3'},0,0,0);
	$page8_hbox5->pack_start($color4_button,0,0,0);
	$page8_hbox5->pack_start($default->{'color4'},0,0,0);
	$color5_label = new Gtk::Label(_("Body Color"));
	$color5_label->set_alignment(0.0,0.5);
	$color5_label->set_usize(80,10);
	$notebook->{'MessageBgColor'} = new Gtk::Entry;
	$notebook->{'MessageBgColor'}->set_editable(1);
	$notebook->{'MessageBgColor'}->set_text($main::prefs{'MessageBgColor'});
	$notebook->{'MessageBgColor'}->set_usize(60,22);
	$color5_button = new Gtk::Button(_("Change"));
	$color5_button->signal_connect("clicked" => \&select_color, $notebook->{'MessageBgColor'}, "bg");
	$default->{'color5'} = new Gtk::Button(_("Default"));
	$default->{'color5'}->signal_connect("clicked", sub { $notebook->{'MessageBgColor'}->set_text("FFFFFF");});
	$page8_hbox6 = new Gtk::HBox(0,5);
	$page8_hbox6->pack_start($color5_label,0,0,0);
	$page8_hbox6->pack_start($notebook->{'MessageBgColor'},0,0,0);
	$page8_hbox6->pack_start($color5_button,0,0,0);
	$page8_hbox6->pack_start($default->{'color5'},0,0,0);
	if ($main::HTMLWIDGET eq "text") { $notebook->{'MessageBgColor'}->set_sensitive(0);
       		     $color5_button->set_sensitive(0);
		     $default->{'color5'}->set_sensitive(0);
	}
	$page8_vbox->pack_start($page8_hbox,0,0,0);
	$page8_vbox->pack_start($colorlimit_hbox,0,0,0);
	$page8_vbox->pack_start($page8_hbox1,0,0,0);
	$page8_vbox->pack_start($arrowbox,0,0,0);
	$page8_vbox->pack_start($page8_hbox2,0,0,0);
	$page8_vbox->pack_start($page8_hbox3,0,0,0); 
	$page8_vbox->pack_start($page8_hbox4,0,0,0);
	$page8_vbox->pack_start($page8_hbox5,0,0,0);
	$page8_vbox->pack_start($page8_hbox6,0,0,0);
	
	#page 9 htmlwidget
	my ($tab9_label, $page9_vbox,$page9_hbox,$page9_label,$page9_label2,$page9_hbox2);
	$tab9_label = new Gtk::Label(_("HTML"));
	$notebook->{'NoHTML'} = new Gtk::CheckButton;
	$notebook->{'NoHTML'}->set_usize(16,17);
	if ($main::prefs{'NoHTML'} eq "y") { $notebook->{'NoHTML'}->set_active(1) }
	if ($main::prefs{'NoHTML'} eq "n") { $notebook->{'NoHTML'}->set_active(0) }
	$page9_label = new Gtk::Label(_("Don't use an HTML Widget to display mail"));
	$page9_label->set_alignment(0.0,0.5);
	$page9_hbox = new Gtk::HBox(0,5);
	$page9_hbox->show;
	$page9_hbox->pack_start($notebook->{'NoHTML'},0,0,0);
	$page9_hbox->pack_start($page9_label,0,0,0);
	$page9_label2 = new Gtk::Label (
_("If you check this button, Pronto will not use an HTML widget to display your
mail. Such widgets are GtkHTML and GtkXmHTML. Regardless, if you uncheck this 
button and you do not have an appropriate HTML widget installed Pronto will
fall back to the regular text widget. However, if an HTML widget is found, the 
order of fall back is CscHTML, GtkHTML, GtkXmHTML or if neither then GtkText. You should
understand that activating this option means that you will not be able to 
utilize some of  Pronto's functions such as displaying image attachments 
inline. Clickable URL's are supported with the right mouse button in this widget
instead of left to allow for uninterrupted selection."));
	$page9_label2->set_justify('left');
	$page9_label2->set_alignment(0.0,0.5);
	$page9_hbox2 = new Gtk::HBox(0,5);
	$page9_hbox2->show;
	$page9_hbox2->pack_start($page9_label2,0,0,0);
	$page9_vbox = new Gtk::VBox(0,5);
	$page9_vbox->set_border_width(5);

	$page9_vbox->pack_start($page9_hbox,0,0,0);
	$page9_vbox->pack_start($page9_hbox2,0,1,0);
	
	#page 10
	
       	my ($page10);
	$page10->{'vbox'} = new Gtk::VBox(0,5);
	$page10->{'vbox'}->set_border_width(5);
	$page10->{'label'} = new Gtk::Label(_("Advanced"));
	$page10->{'warning'} = new Gtk::Label(_("These options are only for advanced users if you dont know what they mean, you are better off leaving them on the defaults\n\n"));
	$page10->{'warning'}->set_line_wrap(1);
	$page10->{'warning'}->set_alignment(0.0,0.5);
	$page10->{'vbox'}->pack_start($page10->{'warning'},0,0,0);
	
	$page10->{'charset'} = new Gtk::Label(_("Character set: "));
	$page10->{'charset'}->set_alignment(0.0,0.5);
	$notebook->{'CharSet'} = new Gtk::Entry;
	$notebook->{'CharSet'}->set_text($main::prefs{'CharSet'});
	$page10->{'charsetbox'} = new Gtk::HBox(0,0);
	$page10->{'charsetbox'}->pack_start($page10->{'charset'},0,0,0);
	$page10->{'charsetbox'}->pack_start($notebook->{'CharSet'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'charsetbox'},0,0,0);
	
	$notebook->{'IncludeReplyTo'} = new Gtk::CheckButton();
	$notebook->{'IncludeReplyTo'}->set_usize(16,17);
	$page10->{'replyto'} = new Gtk::Label(_(" Include a reply-to header?"));
	$notebook->{'IncludeReplyTo'}->set_active($main::prefs{'IncludeReplyTo'});
	$page10->{'replybox'} = new Gtk::HBox(0,0);
	$page10->{'replybox'}->pack_start($notebook->{'IncludeReplyTo'},0,0,0);
	$page10->{'replybox'}->pack_start($page10->{'replyto'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'replybox'},0,0,0);
	
	$notebook->{'Splash'} = new Gtk::CheckButton();
	$page10->{'splash_label'} = new Gtk::Label(_("Don't show a splash screen on startup?"));
	$page10->{'splash_box'} = new Gtk::HBox(0,0);
	$page10->{'splash_box'}->pack_start($notebook->{'Splash'},0,0,0);
	$page10->{'splash_box'}->pack_start($page10->{'splash_label'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'splash_box'},0,0,0);
	$notebook->{'Splash'}->set_active(1) if !$main::prefs{'Splash'};
	
	$notebook->{'SliceSig'} = new Gtk::CheckButton();
	$notebook->{'SliceSig'}->set_active(1) if $main::prefs{'SliceSig'};
	$page10->{'slicelabel'} = new Gtk::Label(_("Remove Signature of sender on reply?"));
	$page10->{'slicebox'} = new Gtk::HBox(0,0);
	$page10->{'slicebox'}->pack_start($notebook->{'SliceSig'},0,0,0);
	$page10->{'slicebox'}->pack_start($page10->{'slicelabel'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'slicebox'},0,0,0);
	
	$notebook->{'EmptyNoBlock'} = new Gtk::CheckButton();
	$notebook->{'EmptyNoBlock'}->set_active(1) if $main::prefs{'EmptyNoBlock'};
	$page10->{'empty_label'} = new Gtk::Label(_("Empty operations (Folder/Trash) are non-blocking?"));
	$page10->{'ebox'} = new Gtk::HBox(0,0);
	$page10->{'ebox'}->pack_start($notebook->{'EmptyNoBlock'},0,0,0);
	$page10->{'ebox'}->pack_start($page10->{'empty_label'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'ebox'},0,0,0);
	
	$notebook->{'Drag'} = new Gtk::CheckButton();
	$notebook->{'Drag'}->set_active(1) if $main::prefs{'Drag'};
	$page10->{'drag_label'} = new Gtk::Label(_("Enable Drag and Drop (Enabling Drag and Drop disables FolderTree reording)"));
	$page10->{'dragbox'} = new Gtk::HBox(0,0);
	$page10->{'dragbox'}->pack_start($notebook->{'Drag'},0,0,0);
	$page10->{'dragbox'}->pack_start($page10->{'drag_label'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'dragbox'},0,0,0);
	
	$notebook->{'autosave'} = new Gtk::CheckButton();
	$notebook->{'autosave'}->set_active(1) if $main::prefs{'autosave'};
	$page10->{'autosave_label'} = new Gtk::Label(_("Auto save compose sessions?"));
	$page10->{'autosave_box'} = new Gtk::HBox(0,0);
	$page10->{'autosave_box'}->pack_start($notebook->{'autosave'},0,0,0);
	$page10->{'autosave_box'}->pack_start($page10->{'autosave_label'},0,0,0);
	$page10->{'vbox'}->pack_start($page10->{'autosave_box'},0,0,0);
	
	# Main View
	$notebook->append_page($page1_vbox, $tab1_label);
	$notebook->append_page($page2_vbox, $tab2_label);
	$notebook->append_page($page3_vbox, $tab3_label);
	$notebook->append_page($page4_vbox, $tab4_label);
	$notebook->append_page($page5_vbox, $tab5_label);
	$notebook->append_page($page6_vbox, $tab6_label);
	$notebook->append_page($page7_vbox, $tab7_label);
	$notebook->append_page($page8_vbox, $tab8_label);
	$notebook->append_page($page9_vbox, $tab9_label);
	$notebook->append_page($page10->{'vbox'},$page10->{'label'});
	
	$ok_but = new Gtk::Button(_("OK"));
	$ok_but->set_usize(55,25);
	$ok_but->signal_connect("clicked" => \&update_conf, $main, $notebook);
	my $apply_but = new Gtk::Button(_("Apply"));
	$apply_but->set_usize(55,25);
	$apply_but->signal_connect("clicked" =>\&update_conf, $main, $notebook,"apply");	
	$cancel_but = new Gtk::Button(_("Cancel"));
	$cancel_but->signal_connect("clicked", sub {$main->destroy;});
	$cancel_but->set_usize(55,25);
	$help_but = new Gtk::Button(_("Help"));
	$help_but->signal_connect("clicked" => \&Pronto::Help::help_win, "option.html" );
	$help_but->set_usize(55,25);
	$hbox_but = new Gtk::HBox(0,5);
	$hbox_but->pack_start($ok_but,1,0,0);
	$hbox_but->pack_start($apply_but,1,0,0);
	$hbox_but->pack_start($cancel_but,1,0,0);
	$hbox_but->pack_start($help_but,1,0,0);
	$vbox1 = new Gtk::VBox(0,5);
	$vbox1->set_border_width(5);
	my $main_hbox = new Gtk::HBox(0,0);
	$vbox1->pack_start($main_hbox,0,0,0);
	my $ctree = new_with_titles Gtk::CTree(0,("Pronto!"));
	$ctree->set_usize(120,0);
	$main_hbox->pack_start($ctree,1,1,0);
	$main_hbox->pack_start($notebook,1,1,0);
	$vbox1->pack_start($hbox_but,0,0,0);
	$notebook->set_show_tabs(0);
	$ctree->signal_connect("tree_select_row", \&switch_page, $notebook);
	
	my @nodes = (_("Send"),
		     _("Receive"),
		     _("View"),
		     _("Database"),
		     _("Fonts"),
		     _("Paths"),
		     _("Web Browser"),
		     _("Message Colors"),
		     _("HTML"),
		     _("Advanced")
		     );
	my $i = 0;
	foreach my $item (@nodes) {
		my $j = $i;
		my $title = [$item];
		my $node = $ctree->insert_node(undef,undef,$title,5,undef,undef,undef,undef,0,1);
		$ctree->node_set_row_data($node, \$j);
		$ctree->select($node) if ($i == 0);
		$i++;
	}	
	

	
	$main->add($vbox1);
	
	show_all $main;
	$main->signal_connect("size-request" => \&main::save_win_size, "config", $main->window);

	return 1;
}

sub switch_page
{
	my ($ctree,$notebook,$node,$col) = @_;
	my $data = ${$ctree->node_get_row_data($node)};
	$notebook->set_page($data);
	return 1;
}	

sub select_color {
	my ($widget, $entry, $name) = @_;
	my ($dialog,$colorsel);
	if ($name eq "quote1") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Quote Color 1"));
	}
	if ($name eq "quote2") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Quote Color 2"));
	}
	if ($name eq "quote3") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Quote Color 3"));
	}
	if ($name eq "message") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Message text Color"));
	}
	if ($name eq "bg") {
		$dialog = new Gtk::ColorSelectionDialog(_("Select Body Background Color"));
	}
	$dialog->show;
	$colorsel = $dialog->colorsel;
	$dialog->signal_connect("destroy", sub { $dialog->destroy; });
	$dialog->signal_connect("delete_event" => \&Gtk::false);
	$dialog->ok_button->signal_connect("clicked", sub { $dialog->destroy; });
	$dialog->cancel_button->signal_connect("clicked", sub { 
                                        if ($name eq "quote1") {
						$entry->set_text($main::prefs{'QuoteColor1'})
					}
					
					if ($name eq "quote2") {
                	                        $entry->set_text($main::prefs{'QuoteColor2'})
                                        }

					if ($name eq "quote3") {
                        	                $entry->set_text($main::prefs{'QuoteColor3'})
                                        }
					
					if ($name eq "message") {
						$entry->set_text($main::prefs{'MessageColor'})
					}
					
					if ($name eq "bg") {
						$entry->set_text($main::prefs{'MessageBgColor'});
					}
					
                                        $dialog->destroy;});
	$colorsel->signal_connect("color_changed", sub { 
             
				     my @color=$colorsel->get_color();
				     my ($red, $green, $blue, $gdk_color);
	     

    		        	     $gdk_color->{ 'red' } = $color[0] * 65535.0;
    				     $gdk_color->{ 'green' } = $color[1] * 65535.0;
    				     $gdk_color->{ 'blue' } = $color[2] * 65535.0;
	    
          			     # Convert to HTML format
          			     $red = $gdk_color->{ 'red' } / 256;
          			     $green = $gdk_color->{ 'green' } / 256;
          			     $blue = $gdk_color->{ 'blue' } / 256;
			    
			             $red = uc( sprintf( "%lx", $red ) );
	                             $green = uc( sprintf( "%lx", $green ) );
          			     $blue = uc( sprintf( "%lx", $blue ) );
					
	                             $red = "0" . $red if ( $red =~ /^\d$/ );
          			     $green = "0" . $green if ( $green =~ /^\d$/ );
	  			     $blue = "0" . $blue if ( $blue =~ /^\d$/ );
						    
          		             $entry->set_text($red.$green.$blue);});
}
								      
sub update_conf {

	my ($widget, $window, $notebook,$apply) = @_;
	my $remade_layout = 0;
	$main::prefs{'SigCmd'} = $notebook->{'SigCmd'}->get_text;
	$main::prefs{'AutoCheckTime'} = $notebook->{'AutoCheckTime'}->get_text;
	$main::prefs{'MaxFetchSize'} = $notebook->{'MaxFetchSize'}->get_text;
	$main::prefs{'MarkAsReadDelay'} = $notebook->{'MarkAsReadDelay'}->get_text;
	$main::prefs{'DatabaseDriver'} = $notebook->{'DatabaseDriver'}->get_text;
	$main::prefs{'DatabaseUser'} = $notebook->{'DatabaseUser'}->get_text;
	$main::prefs{'DatabasePassword'} = $notebook->{'DatabasePassword'}->get_text;
	$main::prefs{'DatabaseHost'} = $notebook->{'DatabaseHost'}->get_text;
	$main::prefs{'MySQLPort'} = $notebook->{'MySQLPort'}->get_text if ($main::prefs{'DatabaseDriver'} eq "mysql");
	$main::prefs{'PgSQLPort'} = $notebook->{'MySQLPort'}->get_text if ($main::prefs{'DatabaseDriver'} eq "Pg");
	$main::prefs{'DateDisplayFormat'} = $notebook->{'DateDisplayFormat'}->get_text;
	($main::prefs{'QuoteHeader'} = $notebook->{'QuoteHeader'}->get_chars(0,-1)) =~ s/\n/*n/g;
	$main::prefs{'QuoteWith'} = $notebook->{'QuoteWith'}->get_text;
	$main::prefs{'HomePage'} = $notebook->{'HomePage'}->get_text;
	$main::prefs{'FontMLBold'} = $notebook->{'FontMLBold'}->get_text;
	$main::prefs{'FontMLNormal'} = $notebook->{'FontMLNormal'}->get_text;
	$main::prefs{'FontMessages'} = $notebook->{'FontMessages'}->get_text;
	$main::prefs{'UseMessageColorsMaxLength'} = $notebook->{'MaxLength'}->get_text;
	$main::prefs{'threadarrow'} = $notebook->{'threadarrow'}->get_text;
	$main::prefs{'CharSet'} = $notebook->{'CharSet'}->get_text;
	my @fields = split /-/, $main::prefs{'FontMessages'};
	$main::prefs{'MsgFontFace'} = $fields[2];
	if ($notebook->{'FontSwitch'}->active) { $main::prefs{'FontSwitch'} = 1 } else { $main::prefs{'FontSwitch'} = 0 }
	if ($notebook->{'IncludeReplyTo'}->active) { $main::prefs{'IncludeReplyTo'} = 1; } else { $main::prefs{'IncludeReplyTo'} = 0; }
	if ($notebook->{'POP3Verbose'}->active) { $main::prefs{'POP3Verbose'} = 1; } else { $main::prefs{'POP3Verbose'} = 0; }	
	if ($main::HTMLWIDGET eq "CscHTML") {
		$main::root_window->{'html_view'}->set_default_font_face($main::prefs{'MsgFontFace'});
		$main::root_window->{'html_view'}->allow_font_switch($main::prefs{'FontSwitch'});
		if (defined $main::view_window and $main::prefs{'viewpane'} eq "n") {
			$main::view_window->{'html'}->set_default_font_face($main::prefs{'MsgFontFace'});
			$main::view_window->{'html'}->allow_font_switch($main::prefs{'FontSwitch'});
		}
	}
	
	if ($notebook->{'ToolTips'}->active) {
		$main::root_window->{'toolbar'}->set_tooltips(1);
		$main::prefs{'ToolTips'} = 1;
	} else {
		$main::root_window->{'toolbar'}->set_tooltips(0);
		$main::prefs{'ToolTips'} = 0;
	}	
	
	$main::prefs{'FontUIBold'} = $notebook->{'FontUIBold'}->get_text;
	$main::prefs{'FontComposer'} = $notebook->{'FontComposer'}->get_text;
	$main::prefs{'WrapAfter'} = $notebook->{'WrapAfter'}->get_text;
	$main::prefs{'ViewerPath'} = $notebook->{'ViewerPath'}->get_text;
	$main::prefs{'gpgpath'} = $notebook->{'gpgpath'}->get_text;
	$main::prefs{'PrintCommand'} = $notebook->{'PrintCommand'}->get_text;
	$main::prefs{'Proxy'} = $notebook->{'Proxy'}->get_text;
	$main::prefs{'ProxyPort'} = $notebook->{'ProxyPort'}->get_text;
	$main::prefs{'SndCmd'} = $notebook->{'SndCmd'}->get_text;
	$main::prefs{'SndFl'} = $notebook->{'SndFl'}->get_text;
	$main::prefs{'ispellpath'} = $notebook->{'ispellpath'}->get_text;
	$main::prefs{'QuoteSymbols'} = $notebook->{'QuoteSymbol'}->get_text;
	$main::prefs{'MessageColor'} = $notebook->{'MessageColor'}->get_text;
	$main::prefs{'QuoteColor1'} = $notebook->{'QuoteColor1'}->get_text;
	$main::prefs{'QuoteColor2'} = $notebook->{'QuoteColor2'}->get_text;
	$main::prefs{'QuoteColor3'} = $notebook->{'QuoteColor3'}->get_text;
	$main::prefs{'MessageBgColor'} = $notebook->{'MessageBgColor'}->get_text;
	$main::prefs{'startin'} = $notebook->{'startin'}->entry->get_text;
	$main::prefs{'onfolderchange'} = $notebook->{'onfolderchange'}->entry->get_text;
	if($notebook->{'AutoCheckProgress'}->active) { $main::prefs{'AutoCheckProgress'} = 1 } else { $main::prefs{'AutoCheckProgress'} = 0 }
	if($notebook->{'RetRecAsk'}->active){$main::prefs{'SendReceipt'}='ask';}
	if($notebook->{'RetRecAlways'}->active){$main::prefs{'SendReceipt'}='all';}
	if($notebook->{'RetRecNever'}->active){$main::prefs{'SendReceipt'}='never';}
	if ($notebook->{'forksend'}->active){ $main::prefs{'forksend'} = 1 } else { $main::prefs{'forksend'} = 0 }
	if ($notebook->{'forkget'}->active){ $main::prefs{'forkget'} = 1 } else { $main::prefs{'forkget'} = 0 }
	if ($notebook->{'SendImmediately'}->active) { $main::prefs{'SendImmediately'} = "y"; } else { $main::prefs{'SendImmediately'} = "n"; }
	if ($notebook->{'CheckMailOnStartup'}->active) { $main::prefs{'CheckMailOnStartup'} = "y"; } else { $main::prefs{'CheckMailOnStartup'} = "n";}
	if ($notebook->{'saveSize'}->active) { $main::prefs{'saveSize'} = "y"; } else { $main::prefs{'saveSize'} = "n"; }
        if ($notebook->{'ExternalSig'}->active) { $main::prefs{'ExternalSig'} = 1; } else { $main::prefs{'ExternalSig'} = 0; }
	if ($notebook->{'useAlternateViewer'}->active) { $main::prefs{'useAlternateViewer'} = "y"; } else { $main::prefs{'useAlternateViewer'} = "n"; }
	if ($notebook->{'attachLeftView'}->active) { $main::prefs{'attachLeftView'} = "y"; } else { $main::prefs{'attachLeftView'} = "n"; }
	if ($notebook->{'Scoring'}->active) { $main::prefs{'Scoring'} = "y"; $main::message_clist->set_column_visibility(3, 1); } else { $main::prefs{'Scoring'} = "n"; $main::message_clist->set_column_visibility(3, 0); }
	if ($notebook->{'import'}->active) { $main::prefs{'import'} = "y"; } else { $main::prefs{'import'} = "n";}
	if ($notebook->{'popalwaysnew'}->active) { $main::prefs{'popalwaysnew'} = "y"; } else { $main::prefs{'popalwaysnew'} = "n";}
	if ($notebook->{'checkDupeOnAll'}->active) { $main::prefs{'checkDupeOnAll'} = "y"; } else { $main::prefs{'checkDupeOnAll'} = "n";}
	if ($notebook->{'PlaySound'}->active) { $main::prefs{'PlaySound'} = "y"; } else { $main::prefs{'PlaySound'} = "n";}
	if ($notebook->{'InlineImages'}->active) { $main::prefs{'InlineImages'} = "y"; } else { $main::prefs{'InlineImages'} = "n";}
	if ($notebook->{'empty_trash_on_exit'}->active) { $main::prefs{'empty_trash_on_exit'} = 1; } else { $main::prefs{'empty_trash_on_exit'} = 0; }
	if ($notebook->{'InlineAttachments'}->active) { $main::prefs{'InlineAttachments'} = "y"; } else { $main::prefs{'InlineAttachments'} = "n";}
	if ($notebook->{'InlineIcons'}->active) { $main::prefs{'InlineIcons'} = "y"; } else { $main::prefs{'InlineIcons'} = "n";}
	if ($notebook->{'Splash'}->active) { $main::prefs{'Splash'} = 0;} else { $main::prefs{'Splash'} = 1; }
	if ($notebook->{'SliceSig'}->active) { $main::prefs{'SliceSig'} = 1;} else { $main::prefs{'SliceSig'} = 0; }
	if ($notebook->{'EmptyNoBlock'}->active) { $main::prefs{'EmptyNoBlock'} = 1; } else { $main::prefs{'EmptyNoBlock'} = 0; }
	if ($notebook->{'FolderNewBold'}->active) { $main::prefs{'FolderNewBold'} = "y"; } else {$main::prefs{'FolderNewBold'} = "n";}
	if ($notebook->{'BoldMsg'}->active) { $main::prefs{'BoldMsg'} = 1; } else { $main::prefs{'BoldMsg'} = 0; }
	if ($notebook->{'AddReplytoAB'}->active) { $main::prefs{'AddReplytoAB'} = "y";} else {$main::prefs{'AddReplytoAB'} = "n"; }
	if ($notebook->{'MsgInDB'}->active) {
		$main::prefs{'MsgInDB'} = "y"; 
       		if ($main::prefs{'DatabasrDriver'} eq "Pg" && $main::prefs{'DriverVersion'} < 0.96) {
			&main::err_dialog(_("Your DBD::Pg version is less than 0.96 which is the required version for storing messages in the database for PostgreSQL, turning MsgInDB off"));
			$main::prefs{'MsgInDB'} = "n";
		}	
	} else { 
		$main::prefs{'MsgInDB'} = "n"; 
       	}
	if ($notebook->{'ForwardAttachments'}->active) { $main::prefs{'ForwardAttachments'} = "y";} else {$main::prefs{'ForwardAttachments'} = "n"; }
	if ($notebook->{'ForwardHeader'}->active) {$main::prefs{'ForwardHeader'} = "y";} else { $main::prefs{'ForwardHeader'} = "n"; }
        if ($notebook->{'autospell'}->active) {$main::prefs{'autospell'} = "y";} else { $main::prefs{'autospell'} = "n"; }
	if ($notebook->{'DeleteMarksAsRead'}->active) { $main::prefs{'DeleteMarksAsRead'} = "y"; } else { $main::prefs{'DeleteMarksAsRead'} = "n"; }
	if ($notebook->{'autosave'}->active()) { $main::prefs{'autosave'} = 1; } else { $main::prefs{'autosave'} = 0;}
	if ($notebook->{'msgcolors'}->active) { $main::prefs{'UseMessageColors'} = "y"; } else { $main::prefs{'UseMessageColors'} = "n";}
	if ($notebook->{'NoHTML'}->active) { 
		$main::prefs{'NoHTML'} = "y";
		if ($main::HTMLWIDGET ne "text") {
			$main::HTMLWIDGET = "text";
			&Pronto::MainWindow::make_layout("flag");
			$remade_layout = 1;
		}	
        } else { 
		$main::prefs{'NoHTML'} = "n";
		if ($main::HTMLWIDGET eq "text" && $main::hashtml == 1) {
			$main::HTMLWIDGET = $main::hashtml_widget;
			&Pronto::MainWindow::make_layout("flag");
      			$remade_layout = 1;
		}	
	}
	
	my $old_drag = $main::prefs{'Drag'};
	if ($notebook->{'Drag'}->active) { 		
		$main::prefs{'Drag'} = 1;
		if (!$old_drag && !$remade_layout) {
			&Pronto::MainWindow::make_layout("flag");
		}
	} else {		
		$main::prefs{'Drag'} = 0;
		if ($old_drag && !$remade_layout) {
			&Pronto::MainWindow::make_layout("flag");
		}
	}	

	if ($notebook->{'useGtkFontComposer'}->active) { $main::prefs{'useGtkFontComposer'} = "y"} else { $main::prefs{'useGtkFontComposer'} = "n"}
	if ($main::check_timer) { Gtk->timeout_remove($main::check_timer); }
	if ($main::prefs{'AutoCheckTime'} > 0) {
		my $seconds = 60*$main::prefs{'AutoCheckTime'};
		alarm $seconds;
	}
	&main::save_prefs;
	#apply fonts
	$main::bold->font(Gtk::Gdk::Font->load($main::prefs{'FontMLBold'}));
	$main::normal->font(Gtk::Gdk::Font->load($main::prefs{'FontMLNormal'}));	  

	&Pronto::FolderTree::refresh_folder_tree;
	&Pronto::MessageList::refresh_messages;
	if (not defined $apply or $apply ne "apply"){
		$window->destroy;
	}
	return 1;  
}

sub init_browse_dlg {
	my ($widget, $entry, $dlg_type) = @_;
	my ($fs_window);
	$fs_window = new Gtk::FileSelection _("Choose Directory...");
	$fs_window->position(-mouse);
	$fs_window->signal_connect("destroy", sub {$fs_window->destroy;});
	$fs_window->signal_connect("delete_event" => \&Gtk::false);
	if($dlg_type eq "ispell_path") {
		$fs_window->set_title(_("Select Ispell or Aspell path ..."));
		$fs_window->ok_button->signal_connect("clicked", \&check_ispell_path, $fs_window, $entry);
	}
	elsif($dlg_type eq "viewer_path") {
                $fs_window->set_title(_("Select Viewer path ..."));
                $fs_window->ok_button->signal_connect("clicked", \&check_viewer_path, $fs_window, $entry);
      	} elsif($dlg_type eq "install_theme") {
		$fs_window->set_title(_("Select Theme ..."));
                $fs_window->ok_button->signal_connect("clicked", \&check_install_theme, $fs_window, $entry);
        } elsif($dlg_type eq "gpg_path") {
		$fs_window->set_title(_("Select GPG Path ..."));
		$fs_window->ok_button->signal_connect("clicked", \&check_gpg_path, $fs_window, $entry);
	}	
	$fs_window->cancel_button->signal_connect("clicked", sub {$fs_window->destroy;});
	$fs_window->show;
	return 1;
}

sub check_ispell_path {
        my ($widget, $fs_window, $entry) = @_;
	if (($fs_window->get_filename =~ /ispell/) || ($fs_window->get_filename =~ /aspell/)) {
		$entry->set_text($fs_window->get_filename);
                $fs_window->destroy;
                return 1;
        } else {
                &main::err_dialog(_("You must select the location of ispell"));
                return 1;
        }
}

sub check_gpg_path {
	my ($widget, $fs_window, $entry)=@_;
	if (($fs_window->get_filename =~ /gpg/) || ($fs_window->get_filename =~ /pgp/)) {
		$entry->set_text($fs_window->get_filename);
		$fs_window->destroy;
		return 1;
	} else {
		&main::err_dialog(_("Select an appropriate GPG path please !"));
		return 1;
	}
}	

sub check_viewer_path {
        my ($widget, $fs_window, $entry) = @_;
        if (($fs_window->get_filename =~ /netscape/) || (-f $fs_window->get_filename)) {
                $entry->set_text($fs_window->get_filename);
                $fs_window->destroy;
                return 1;
        } else {
                &main::err_dialog(_("The path to the viewer you entered does not exist!"));
                return 1;
        }
}

sub init_font_dlg {
	my ($widget, $entry) = @_;
	my ($font_dlg);
	$font_dlg = new Gtk::FontSelectionDialog(_("Select Font"));
	$font_dlg->position(-mouse);
	$font_dlg->set_font_name($entry->get_text);
	$font_dlg->set_preview_text("Pronto $main::version");
	$font_dlg->signal_connect("destroy", sub {$font_dlg->destroy;});
	$font_dlg->ok_button->signal_connect("clicked", sub {$entry->set_text($font_dlg->get_font_name()); $font_dlg->destroy; return 1;});
	$font_dlg->cancel_button->signal_connect("clicked", sub {$font_dlg->destroy;});
	$font_dlg->show;
}

sub check_install_theme {
        my ($widget, $fs_window, $entry) = @_;
        if ((-f $fs_window->get_filename) && ($fs_window->get_filename =~ /\.tar\.gz$/i)) {
		my $filename =  $fs_window->get_filename();
                $fs_window->destroy;
		if(!(-f $main::prefs{'MailDir'} . "/pixmaps")) {
			system("mkdir " . $main::prefs{'MailDir'} . "/pixmaps");
		}
		system("cp $filename " . $main::prefs{'MailDir'} . "/pixmaps");
        	my $file;
        	foreach(split(/\//, $filename)) {
                	$file = $_;
        	}
        	system("tar zxf " . $main::prefs{'MailDir'} . "/pixmaps/$file --directory=" . $main::prefs{'MailDir'} . "/pixmaps");
        	system("rm -f " . $main::prefs{'MailDir'} . "/pixmaps/$file");
		$entry->signal_emit("activate");
		return 1;
        } else {
                &main::err_dialog(_("You must select a Theme in .tar.gz format"));
                return 1;
        }
}



1;
