package Pronto::Data::MessageOp;
# -*- perl -*-
use strict;
use SelfLoader;
use Text::ParseWords;
1;
__DATA__
sub edit {
	my ($msgid, $sql, $query, $acctid, $subject, $cc, $to, @fields);
	$msgid = &Pronto::MessageList::get_selected_msgid();
	if (! $msgid) {      
	    &main::err_dialog(_("Select a message to edit!"));
	    return 1; 
	}
	$sql = "select accountid, subject, cc, sentto from messages where id=?";
	$query=$main::conn->prepare($sql);
	$query->execute($msgid);
	($acctid, $subject, $cc, $to) = $query->fetchrow_array();
	$fields[0] = $to;
	$fields[1] = $cc;
	$fields[2] = $subject;
	&Pronto::Compose::init_msg_window(0, undef, \@fields, $msgid, $acctid, 3);
	return 1;
}

sub parse_csv {
	return quotewords(",",1, $_[0]);
}

sub reply {
	my ($widget, $quote) = @_;
	my ($msgid, $sql, $query, $acctid, $subject, $reply, $from, @fields);
	$msgid = &Pronto::MessageList::get_selected_msgid();
	if (! $msgid) {      
	    &main::err_dialog(_("Select a message to reply to!"));
	    return 1; 
	}
	$sql = "select accountid, subject, replyto, sentfrom from messages where id=?";
	$query=$main::conn->prepare($sql);
	$query->execute($msgid);
	($acctid, $subject, $reply, $from) = $query->fetchrow_array();
	if (!$reply) { $reply = $from; }
	unless ($subject =~ /^Re: /i) {
		$subject = "Re: " . $subject;
	}
	$fields[0] = $reply;
	$fields[1] = "";
	$fields[2] = $subject;
	foreach(0..1) {
		my @tmp=split(/,/,$fields[$_]);
		foreach(@tmp) {
			s/\(.*\)$//;			
		}
		$fields[$_] = join(',',@tmp);
	}	
	if (defined $quote and $quote eq "y") {
		&Pronto::Compose::init_msg_window(0, undef, \@fields, $msgid, $acctid, 1);
	} else {
		&Pronto::Compose::init_msg_window(0, undef, \@fields, $msgid, $acctid, 5);
	}
	return 1;
}

sub reply_to_list
{

	my ($msgid, $sql, $query, $acctid, $subject, $reply, $from, @fields,$slice);
	$msgid = &Pronto::MessageList::get_selected_msgid();
	if (! $msgid) {      
	    &main::err_dialog(_("Select a message to reply to!"));
	    return 1; 
	}
	my $headers = &Pronto::Data::Message::get_headers($msgid);
	$slice = 0;
	$sql = "select accountid, subject, replyto, sentfrom from messages where id=?";
	$query=$main::conn->prepare($sql);
	$query->execute($msgid);
	($acctid, $subject, $reply, $from) = $query->fetchrow_array();
	if (!$reply) { $reply = $from; }
	if (defined $headers->{'x-beenthere'}) {
		$reply = $headers->{'x-beenthere'};
		$slice = 1;
	} elsif (defined $headers->{'x-mailinglist'}) {
		$reply = $headers->{'x-mailinglist'};
		$slice = 1;
	} elsif (defined $headers->{'x-mailing-list'}) {
		$reply = $headers->{'x-mailing-list'};
		$slice = 1;
	}	
	
	unless ($subject =~ /^Re: /i) {
		$subject = "Re: " . $subject;
	}
	
	if ($slice) {
		#some lists have the xmailing field as <list@domain.com> sometext so we wipe it out
		$reply =~ s/\<//g;
		$reply =~ s/\>//g;
		$reply =~ s/ (.*)//g;
	}	
	
	$fields[0] = $reply;
	$fields[1] = "";
	$fields[2] = $subject;
	&Pronto::Compose::init_msg_window(0, undef, \@fields, $msgid, $acctid, 1);

	return 1;
}


sub reply_all {
 	my ($widget, $remove_self) = @_;
	my ($msgid, $sql, $query, $acctid, $subject, $reply, $from, 
     	$to, $cc, @msgbody, @row, @fields, @temp);
	$msgid = &Pronto::MessageList::get_selected_msgid();
	if (! $msgid) {      
	    &main::err_dialog(_("Select a message to reply to!"));
	    return 1; 
	}
 	$sql = "select accountid, subject, replyto, sentto, cc, sentfrom from messages where id=?";
 	$query=$main::conn->prepare($sql); 
 	$query->execute($msgid);
 	($acctid, $subject, $reply, $to, $cc, $from) = $query->fetchrow_array();
 	if (!$reply) { $reply = $from; }
 	unless ($subject =~ /^Re: /i) {
  		$subject = "Re: " . $subject;
 	}
	
       	$fields[0] = $reply . ", " . $to;
	if ($reply =~ /$to/i) {
		$fields[0] =~ s/$reply,//;
	}	
  	# add from field to the to listing if the reply to is set...
 	$fields[0].= ", ".$from if ($reply && $reply ne $from);
 	$fields[1] = $cc;
 	$fields[2] = $subject;
 	
	if ($remove_self and $remove_self eq "y") {
		$sql = "select friendly,reply from accounts where id = ?";
		$query=$main::conn->prepare($sql);
		$query->execute($acctid);
	
		while (my ($friendly, $email) = $query->fetchrow_array()) {			


			my @temp = parse_csv($fields[0]);

			$fields[0] = "";
			foreach(@temp) {
				if (/$email/i) { # just in case and to fix the commas
   					$_ = "";
				}
				$fields[0].= ",".$_ if $_ ne "" && $fields[0] ne "";
				$fields[0] = $_ if $_ ne "" && $fields[0] eq "";
			}	


			@temp = parse_csv($fields[1]);

			$fields[1] = "";
			foreach(@temp) {
				if (/$email/i) { #just in case again
				       $_ = "";
				}
		       		$fields[1].=  ",".$_ if $_ ne "" && $fields[1] ne "";
				$fields[1] = $_ if $_ ne "" && $fields[1] eq "";
			}	
		
       		}
	}
	
	&Pronto::Compose::init_msg_window(0, undef, \@fields, $msgid, $acctid, 1);
 
 	return 1;
}

sub forward {
 
 	my ($msgid, $sql, $query, @selection, $acctid, $subject, @msgbody, @row, @fields);
	$msgid = &Pronto::MessageList::get_selected_msgid();
	if (! $msgid) {      
		&main::err_dialog(_("Select message to forward!"));
	    return 1; 
	}
 	$sql = "select accountid, subject from messages where id = ?";
 	$query=$main::conn->prepare($sql);
 	$query->execute($msgid);
 	($acctid, $subject) = $query->fetchrow_array();
 	unless ($subject =~ /^Fw: /i) {
  	$subject = "Fw: " . $subject;
 	}
 	$fields[0] = "";
 	$fields[1] = "";
 	$fields[2] = $subject;
 	&Pronto::Compose::init_msg_window(0, undef, \@fields, $msgid, $acctid, 2);
 	return 1;
}
1;
