## $Id: smileys.py,v 1.3 2001/01/10 12:12:27 kjetilja Exp $

## System modules
from gtk import *
from gnome.ui import *
import string, marshal, re

SMILEY = 0
HEADER = 1

smileys = [ (HEADER, 'Misc smileys'),
            (SMILEY, ':-)', 'The standard smiley'),
            (SMILEY, ':-(', 'The sad smiley'),
            (SMILEY, ';-)', 'The winking smiley'),
            (SMILEY, ':-|', 'The apathetic smiley'),
            (SMILEY, ':-||', 'The angry smiley'),
            (SMILEY, '  ', 'The invisible smiley'),
            (SMILEY, ':-o', 'The shocked smiley'),
            (SMILEY, '8-O', 'The amazed smiley'),
            (SMILEY, '%-(', 'The confused smiley'),
            (SMILEY, '%-)', 'The confused smiley'),

            (HEADER, 'The crying smileys'),
            (SMILEY, ';-(', 'You want to cry'),
            (SMILEY, ':`-(', 'You are actually shedding tears'),
            (SMILEY, ':~-(', 'You are bawling'),
            
            (HEADER, 'Animals'),
            (SMILEY, '8)', 'Frog'),
            (SMILEY, '8:)', 'Pig'),
            (SMILEY, '3:-o', 'Cow'),
            (SMILEY, 'pp#', 'Another Cow'),
            (SMILEY, "pq`#'", 'Bull'),
            (SMILEY, '.\/', 'Duck'),
            (SMILEY, '8^', 'Chicken'),
            (SMILEY, '<:>==', 'Turkey'),
            
            (HEADER, 'Smiley caricatures'),
            (SMILEY, '5:-)', 'Elvis Presley'),
            (SMILEY, ':-)B', 'Dolly Parton'),
            (SMILEY, ':-O', 'Mick Jagger'),
            (SMILEY, ':-.)', 'Madonna'),

            (HEADER, 'Presidential smileys'),
            (SMILEY, '=|:-)', 'Abe Lincon'),
            (SMILEY, ":'-}", 'Richard Nixon'),
            (SMILEY, ':(=)', 'Jimmy Carter'),
            (SMILEY, '7:^]', 'Ronald Reagan'),
            (SMILEY, '\|=//', 'George Bush'),
            (SMILEY, '=:o]', 'Bill Clinton'),

            
          ]

##
## Main filter window class
##
##
class SmileysWindow:
    ##
    ## Method __init__ (self, folder window class instance)
    ##
    ##    Folder edit widget constructor.
    ##
    ##
    def __init__(self, edit):
        self.edit = edit 
        self.prefs = self.edit.prefs
        self.win = GnomeDialog(':Pygmy - Smileys', STOCK_BUTTON_CLOSE)
        self.win.set_parent(self.edit.win)
        self.vbox = self.win.vbox
        self.win.connect('clicked', self.handle_callbacks)
	self.win.connect('delete_event', self.destroy)
	self.win.connect('destroy', self.destroy)

        self.init_smileys()
        self.win.show()

    def init_smileys(self):
        size = (len(smileys)+1)/2 
        size = 10
        #print size
        t = GtkTable(size,size, 1)
        t.show()

        x, y = (0,0)
        for smiley in smileys:
            if smiley[0] == HEADER:
                l = GtkLabel(smiley[1])
                l.show()
                t.attach(l, 0, size, y+1, y+2)
                x, y = (0, y+2)
            else:
                b = GtkButton(smiley[1])
                b.connect('clicked', self.insert_callback, smiley[1])
                b.show()
                tt = GtkTooltips()
                tt.set_tip(b, smiley[2], 'nop')
                t.attach(b, x, x+1, y, y+1) 
        
                if x == size - 1:
                    x, y = (0, y+1)
                else:
                    x = x + 1

        self.vbox.pack_start(t)

    def insert_callback(self, button, smiley=None):
        self.edit.insert_smiley(smiley)

    def handle_callbacks(self, button, no):
        if no == 0:
            self.destroy()
        else:
            print "filter -- got unknown button callback event"

    
    def destroy(self, foo=None, bar=None):
        self.edit.smileys_active = 0
        self.win.destroy()
