## $Id: cite.py,v 1.7 2001/09/24 18:20:55 kjetilja Exp $

##
## Function citebody (text, date, char)
##
##    Insert cite characters in the beginning of each body line.
##
##
def citebody(text, date, who, char='>'):
    import string
    return string.replace("On %s, %s wrote:\n%s" % (date, who, text),
                          '\n', '\n'+char+' ')


##
## Function citesubject (text, prefix)
##
##    Insert response prefix in subject text.
##
##
def citesubject(text, prefix='Re:'):
    import string
    if text != '' and text is not None:
        oldprefix = string.lower(text[:3])
        if oldprefix == 're:':
            return text
        else:
            return prefix + ' ' + text
    else:
        return prefix


##
## Function body_forward (text)
##
##    Insert forward-message text in body text
##
##
def body_forward(text, sub, frm, date, cc, to):
    template = "\n\n----------- Forwarded message -----------\n"
    if frm:
        template = template + 'From: %s\n' % frm
    if to:
        template = template + 'To: %s\n' % to
    if cc:
        template = template + 'Cc: %s\n' % cc
    if date:
        template = template + 'Date: %s\n' % date
    if sub:
        template = template + 'Subject: %s\n' % sub
    return template + '\n' + text

    
##
## Function subject_forward (text)
##
##    Insert forward-message in subject text.
##
##
def subject_forward(text):
    return (text or "") + " (fwd)"
