/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: rmath.hpp,v 1.3 2001/08/09 11:37:59 cxsc Exp $ */

#ifndef rmath_included
#define rmath_included

#include "real.hpp"

namespace cxsc {

inline real sqr    (const real&) throw();        // Sqr(x)
inline real sqrt   (const real&);        // Sqrt(x)
inline real sqrt   (const real &, int);  // Sqrt(x, n)
inline real sqrtm1 (const real&);        // Sqrt(x+1) - 1

inline real sin    (const real&) throw();        // Sin(x)
inline real cos    (const real&) throw();        // Cos(x)
inline real tan    (const real&) throw();        // Tan(x)
inline real cot    (const real&) throw();        // Cot(x)

inline real asin   (const real&);        // ASin(x)
inline real acos   (const real&);        // ACos(x)
inline real atan   (const real&);        // ATan(x) 
inline real acot   (const real&);        // ACot(x)

inline real expm1  (const real&) throw();        // Exp(x)-1
inline real lnp1   (const real&);        // Ln(x)+1

inline real exp    (const real&) throw();        // Exp(x)
inline real ln     (const real&);        // Ln(x)
inline real sinh   (const real&) throw();        // Sinh(x)
inline real cosh   (const real&) throw();        // Cosh(x)
inline real tanh   (const real&) throw();        // Tanh(x) 
inline real coth   (const real&) throw();        // Coth(x)

inline real asinh  (const real&);        // ASinh(x)
inline real acosh  (const real&);        // ACosh(x)
inline real atanh  (const real&);        // ATanh(x)
inline real acoth  (const real&);        // ACoth(x)

inline real pow    (const real&, const real&);  // Pow(x,y)
inline real power  (const real&, const int);    // Power(x,n)

extern "C" {
   void r_lfsr(void); // Siehe real.hpp in real_ari...?!?!
}

} // namespace cxsc 

#include "rmath.inl"
#endif

