/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: lrvecimat.hpp,v 1.3 2001/08/09 11:37:58 cxsc Exp $ */

// Here are definitions for l_rvector x imatrix-Functions
#ifndef _CXSC_LRVECIMAT_HPP_INCLUDED
#define _CXSC_LRVECIMAT_HPP_INCLUDED

namespace cxsc {

	INLINE void accumulate(idotprecision &dp, const imatrix_subv & rv1, const l_rvector &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_rvector & rv1, const imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const imatrix_subv & rv1, const l_rvector_slice &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
	INLINE void accumulate(idotprecision &dp, const l_rvector_slice & rv1, const imatrix_subv &rv2)
#if(IndCheck)
	throw(OP_WITH_WRONG_DIM);
#else
	throw();
#endif
       
} // namespace cxsc 

#endif


