/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: imath.hpp,v 1.3 2001/08/09 11:37:55 cxsc Exp $ */

#ifndef imath_hpp_included
#define imath_hpp_included

#include "except.hpp"
#include "interval.hpp"

namespace cxsc {

interval sqr    (const interval&) throw();        // Sqr(x)
interval sqrt   (const interval&);        // Sqrt(x)

interval sqrt   (const interval &, int);  // Sqrt(x, n)

interval sin    (const interval&) throw();        // Sin(x)
interval cos    (const interval&) throw();        // Cos(x)
interval tan    (const interval&) throw();        // Tan(x)
interval cot    (const interval&) throw();        // Cot(x)

interval asin   (const interval&);        // ASin(x)
interval acos   (const interval&);        // ACos(x)
interval atan   (const interval&);        // ATan(x) 
interval acot   (const interval&);        // ACot(x)


interval exp    (const interval&) throw();        // Exp(x)
interval ln     (const interval&);        // Ln(x)

interval sinh   (const interval&) throw();        // Sinh(x)
interval cosh   (const interval&) throw();        // Cosh(x)
interval tanh   (const interval&) throw();        // Tanh(x) 
interval coth   (const interval&) throw();        // Coth(x)

interval asinh  (const interval&);        // ASinh(x)
interval acosh  (const interval&);        // ACosh(x)
interval atanh  (const interval&);        // ATanh(x)
interval acoth  (const interval&);        // ACoth(x)

interval pow    (const interval&, const interval&) throw(ERROR_INTERVAL_STD_FKT_OUT_OF_DEF);  // Pow(x,y)
interval power  (const interval&, const int);    // Power(x,n)

} // namespace cxsc 

// #include "imath.inl"

#endif

