! Illustration of logarithmic axes, and redefinition of window
      implicit none
      real*8 PI
      parameter (PI = 3.1415926535897932384)
		
      real*8 freql(0:100),ampl(0:100),phase(0:100), freq, f0
      integer i
      call plinit()
      call pladv(0)
      call plfont(2)

      f0 = 1000.0
      do 1 i=0,100
        freql(i)=1.0+ dble (i)/20.0
        freq=10.0**freql(i)
        ampl(i)=20.0*log10(1.0/sqrt(1.0+(freq/f0)**2))
        phase(i)=-(180.0/PI)*atan(freq/f0)
    1 continue

      call plvpor(dble (0.15), dble (0.85), dble (0.1), dble (0.9)) 
      call plwind(dble (1.0), dble (6.0), dble (-80.0), dble (0.0)) 
      call plcol(1)
      call plbox('bclnst', dble (0.0), 0, 'bnstv', dble (0.0), 0)
      call plcol(2)
      call plline(101,freql,ampl)
      call plcol(1)
      call plptex(dble (5.0), dble (-30.0), dble (1.0), dble (-20.0),
     &  dble (0.5), '-20 dB/decade')
      call plwind(dble (1.0), dble (6.0), dble (-100.0), dble (0.0)) 
      call plbox(' ', dble (0.0), 0, 'cmstv', dble (30.0), 3)
      call plcol(3)
      call plline(101,freql,phase)

      call plcol(1)
      call plmtex('b', dble (3.2), dble (0.5), dble (0.5), 'Frequency')
      call plmtex('t',dble (2.0), dble (0.5), dble (0.5),
     &  'Single Pole Low-Pass Filter')
      call plcol(2)
      call plmtex('l', dble (5.0), dble (0.5), dble (0.5),
     &  'Amplitude (dB)')
      call plcol(3)
      call plmtex('r', dble (5.0), dble (0.5), dble (0.5),
     &  'Phase shift (degrees)')

      call plend      
      end
