/*
 * Tiny Vector Matrix Library
 * Dense Vector Matrix Libary of Tiny size using Expression Templates
 *
 * Copyright (C) 2001, 2002 Olaf Petzold <opetzold@wit.regiocom.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *	
 * "$Id:"
 */

#ifndef TVMET_FUNCTIONAL_H
#define TVMET_FUNCTIONAL_H

#include <tvmet/tvmet.h>
#include <tvmet/TypePromotion.h>

namespace tvmet {

/**
 * \class Functional Functional.h "tvmet/Functional.h"
 * \brief Base class for all binary und unary functionals.
 *
 * All functional operators and functions have a static apply
 * member function for evaluating the expressions inside.
 */
struct Functional { };

/**
 * \class BinaryFunctional Functional.h "tvmet/Functional.h"
 * \brief Base class for all binary functions.
 */
struct BinaryFunctional : public Functional { };

/**
 * \class UnaryFunctional Functional.h "tvmet/Functional.h"
 * \brief Base class for all unary functions.
 */
struct UnaryFunctional : public Functional { };

} // namespace tvmet

#include <tvmet/BinaryFunctionals.h>
#include <tvmet/UnaryFunctionals.h>

#endif // TVMET_FUNCTIONAL_H

// Local Variables:
// mode:C++
// End:
