/*
 * Tiny Vector Matrix Library
 * Dense Vector Matrix Libary of Tiny size using Expression Templates
 *
 * Copyright (C) 2001, 2002 Olaf Petzold <opetzold@wit.regiocom.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * "$Id:"
 */

#ifndef TVMET_MATRIX_IMPL_H
#define TVMET_MATRIX_IMPL_H

#include <iomanip>			// setw

#include <tvmet/Functional.h>

namespace tvmet {

/*
 * member operators for i/o
 */
template<class T, std::size_t Rows, std::size_t Cols>
inline
std::ostream& Matrix<T, Rows, Cols>::print_on(std::ostream& os) const
{
  std::streamsize w = os.width();

  os << std::setw(0) << "Matrix<" << typeid(T).name() << ", "
     << Rows << ", " << Cols << "> = [\n";
  for(std::size_t i = 0; i < Rows; ++i) {
    os << " [";
    for(std::size_t j = 0; j < (Cols - 1); ++j) {
      os << std::setw(w) << this->operator()(i, j) << ", ";
    }
    os << std::setw(w) << this->operator()(i, Cols - 1) << "],\n";
  }
  os << "]";

  return os;
}

/*
 * member operators with scalars
 */
#define IMPLEMENT_BINARY_OPERATOR(OP)					\
template<class T, std::size_t Rows, std::size_t Cols>			\
inline Matrix<T, Rows, Cols>& 						\
Matrix<T, Rows, Cols>::operator OP (value_type rhs) {			\
  typedef XprLiteral<value_type> expr_type;				\
  *this OP XprMatrix<expr_type, Rows, Cols>(expr_type(rhs));		\
  return *this;								\
}

IMPLEMENT_BINARY_OPERATOR(+=)
IMPLEMENT_BINARY_OPERATOR(-=)
IMPLEMENT_BINARY_OPERATOR(*=)
IMPLEMENT_BINARY_OPERATOR(/=)
IMPLEMENT_BINARY_OPERATOR(%=)
IMPLEMENT_BINARY_OPERATOR(^=)
IMPLEMENT_BINARY_OPERATOR(&=)
IMPLEMENT_BINARY_OPERATOR(|=)
#undef IMPLEMENT_BINARY_OPERATOR

// shift only with int's
#define IMPLEMENT_BINARY_OPERATOR(OP)					\
template<class T, std::size_t Rows, std::size_t Cols>			\
inline Matrix<T, Rows, Cols>&  						\
Matrix<T, Rows, Cols>::operator OP (std::size_t rhs) {			\
  typedef XprLiteral<value_type> expr_type;				\
  *this OP XprMatrix<expr_type, Rows, Cols>(expr_type(rhs));		\
  return *this;								\
}

IMPLEMENT_BINARY_OPERATOR(<<=)
IMPLEMENT_BINARY_OPERATOR(>>=)
#undef IMPLEMENT_BINARY_OPERATOR

/*
 * member operators with matrizes
 */
#define IMPLEMENT_BINARY_OPERATOR(OP)					\
template<class T1, std::size_t Rows, std::size_t Cols>			\
template <class T2>					                \
inline 	Matrix<T1, Rows, Cols>&						\
Matrix<T1, Rows, Cols>::operator OP (const Matrix<T2, Rows, Cols>& rhs) { \
  *this OP XprMatrix<typename Matrix<T2, Rows, Cols>::ConstReference, Rows, Cols>(rhs.cref()); \
  return *this;					                	\
}

IMPLEMENT_BINARY_OPERATOR(=)
IMPLEMENT_BINARY_OPERATOR(+=)
IMPLEMENT_BINARY_OPERATOR(-=)
#ifdef KICK_MATH_SENSE // XXX not inside regression tests
IMPLEMENT_BINARY_OPERATOR(*=)
IMPLEMENT_BINARY_OPERATOR(/=)
IMPLEMENT_BINARY_OPERATOR(%=)
IMPLEMENT_BINARY_OPERATOR(^=)
IMPLEMENT_BINARY_OPERATOR(&=)
IMPLEMENT_BINARY_OPERATOR(|=)
IMPLEMENT_BINARY_OPERATOR(<<=)
IMPLEMENT_BINARY_OPERATOR(>>=)
#endif // KICK_MATH_SENSE
#undef IMPLEMENT_BINARY_OPERATOR

/*
 * member operators with expressions
 */
#define IMPLEMENT_BINARY_OPERATOR(OPNAME, OP)				\
template<class T,  std::size_t Rows,  std::size_t Cols>			\
template<class E>                                                    	\
inline Matrix<T, Rows, Cols>&						\
Matrix<T, Rows, Cols>::operator OP (XprMatrix<E, Rows, Cols> expr) {   	\
  assign(expr, OPNAME<value_type, typename E::value_type>());         	\
  return *this;                                                       	\
}

IMPLEMENT_BINARY_OPERATOR(fcnl_Assign, =)
IMPLEMENT_BINARY_OPERATOR(fcnl_AddUpd, +=)
IMPLEMENT_BINARY_OPERATOR(fcnl_SubUpd, -=)
IMPLEMENT_BINARY_OPERATOR(fcnl_MulUpd, *=)
IMPLEMENT_BINARY_OPERATOR(fcnl_DivUpd, /=)
IMPLEMENT_BINARY_OPERATOR(fcnl_ModUpd, %=)
IMPLEMENT_BINARY_OPERATOR(fcnl_BitwiseXorUpd, ^=)
IMPLEMENT_BINARY_OPERATOR(fcnl_BitwiseAndUpd, &=)
IMPLEMENT_BINARY_OPERATOR(fcnl_BitwiseOrUpd, |=)
IMPLEMENT_BINARY_OPERATOR(fcnl_ShlUpd, <<=)
IMPLEMENT_BINARY_OPERATOR(fcnl_ShrUpd, >>=)
#undef IMPLEMENT_BINARY_OPERATOR

} // namespace tvmet

#endif // TVMET_MATRIX_IMPL_H

// Local Variables:
// mode:C++
// End:
