/*
 * Tiny Vector Matrix Library
 * Dense Vector Matrix Libary of Tiny size using Expression Templates
 *
 * Copyright (C) 2001, 2002 Olaf Petzold <opetzold@wit.regiocom.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *	
 * "$Id:"
 */

#ifndef TVMET_CONFIG_GCC_H
#define TVMET_CONFIG_GCC_H

#if defined(__GNUC__)

/*
 * Optimizing und config switches, doxygen need this here (the desciption
 * should be inside tvmet.h)
 */

/**
 * \def TVMET_OPTIMIZE_XPR_CTOR_ARGS_BY_VALUE
 * Define this to optimize the constructor for expressions. The expressions
 * to functions are passed by value. This results in better asm code depending
 * from the used compiler.
 */
#define TVMET_OPTIMIZE_XPR_CTOR_ARGS_BY_VALUE

/**
 * \def TVMET_OPTIMIZE_XPR_MANUAL_CCTOR
 * Define this to optimize the copy constructor for expressions. This results 
 * in better asm code depending from the used compiler.
 */
#define TVMET_OPTIMIZE_XPR_MANUAL_CCTOR

#else // !defined(__GNUC__)

   // paranoia
#  warning "config header for gnuc included without defined __GNUC__"

#endif

#endif // TVMET_CONFIG_GCC_H

// Local Variables:
// mode:C++
// End:
