      SUBROUTINE INTERP(T,GROUP,LAST,NELIS,
     &                 NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                 NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                 L,DIM,X,NK,U,DUDX,NOP,NOPARM,DNOPDX,N,CU)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      INTERP   copies the input solution U to the output         ***
C**               file CU.                                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      formal parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      INTEGER            GROUP,LAST,NELIS,L,DIM,NK,N,
     &                   NRSP,RVP1,NRVP,NISP,IVP1,NIVP,NOP

      DOUBLE PRECISION   T,X(L,DIM),U(L,NK),DUDX(L,NK,DIM),
     &                   RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                   NOPARM(L,NOP),DNOPDX(L,NOP,DIM),CU(L,N)

      INTEGER            ISPARM(NISP),IVPARM(IVP1,NIVP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      INTEGER Z,I,TRIND(1),K
      COMMON /TRANS/TRIND
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      K=0
      DO 10 I=1,NK
	IF (TRIND(I).NE.0) THEN
	  K=K+1
          DO 13 Z=1,NELIS
            CU(Z,K)=U(Z,I)
13        CONTINUE
        ENDIF
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C**---end of INTERP-------------------------------------------------***
      E    N    D
      SUBROUTINE ERRORP(T,GROUP,LAST,NELIS,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  L,DIM,X,NK,U,DUDX,NOP,NOPARM,DNOPDX,N,CU)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      ERROR  computes the relative errors                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      formal parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      INTEGER            GROUP,LAST,NELIS,L,DIM,NK,N,
     &                   NRSP,RVP1,NRVP,NISP,IVP1,NIVP,NOP

      DOUBLE PRECISION   T,X(L,DIM),U(L,NK),DUDX(L,NK,DIM),
     &                   RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                   NOPARM(L,NOP),DNOPDX(L,NOP,DIM),CU(L,N)

      INTEGER            ISPARM(NISP),IVPARM(IVP1,NIVP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      INTEGER Z,I,TRIND(1)
      DOUBLE PRECISION NORMU(1),EPS
      COMMON /NORM/EPS,NORMU
      COMMON /TRANS/TRIND
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      DO 10 Z=1,NELIS
       CU(Z,1)=0.
10    CONTINUE

      DO 20 I=1,NK
	IF (TRIND(I).NE.0) THEN
          DO 21 Z=1,NELIS
           CU(Z,1)=MAX(CU(Z,1),ABS(U(Z,I)*%OUTPUT_ERRSCAL_)/MAX(NORMU(I),EPS))
21        CONTINUE
        ENDIF
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C**---end of ERRORP-------------------------------------------------***
      E    N    D
