/*
firestring.h - FireString string function declarations
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _FIRESTRING_H
#define _FIRESTRING_H

#include <stdlib.h>

struct firestring_conf_t {
	char *var;
	char *value;
	struct firestring_conf_t *next;
};

void *firestring_malloc(const size_t size);
void *firestring_realloc(void *old, const size_t new);
char *firestring_strdup(const char * const input);
void firestring_strncpy(char * const to, const char * const from, const size_t size);
void firestring_strncat(char * const to, const char * const from, const size_t size);
int firestring_snprintf(char * out, const size_t size, const char * const format, ...);
int firestring_strncasecmp(const char * const s1, const char * const s2, const size_t n);
int firestring_strcasecmp(const char * const s1, const char * const s2);
char *firestring_concat(const char *s, ...);
char *firestring_chomp(char *s);
char *firestring_chug(char *s);

/* configuration system functions */
struct firestring_conf_t *firestring_conf_parse(const char *filename);
struct firestring_conf_t *firestring_conf_add(struct firestring_conf_t *next, const char *var, const char *value);
const char *firestring_conf_find(struct firestring_conf_t *config, const char *var);
const char *firestring_conf_find_next(struct firestring_conf_t *config, const char *var, const char *prev);
void firestring_conf_free(struct firestring_conf_t *config);

#endif
