/* File     : get_backspace.c
 * Author   : Karyl F. Stein
 * Purpose  : Input and set the backspace key correctly.
 *
 * Notes    : This module is not especially bulletproof especially if the
 *            backspace key sends more than one character.  The only case I
 *            know of this happening is with the terminal program shipped with
 *            Windows 3.1[1] in which "^H ^H" is sent.  This will work fine,
 *            though, but perhaps there are other such things out there which
 *            will cause havoc.
 *
 *            Be sure to edit get_backsapce.h and change anything as needed.
 *
 * Copyright: (c)1997 Karyl F. Stein <steinkf@cs.purdue.edu>
 *
 *            Permission is granted to use this code in whole or in part for
 *            non-commercial purposes as long as the following conditions are
 *            met:
 *
 *            1) Any modifications to this code are clearly marked if the
 *               modified code is distributed to other people other than the
 *               modifier,
 *            2) This copyright remains with any distributed versions, and
 *            3) Credit is given to the author if parts of this code are used.
 *
 *            If you use this code to make money in any form or if you use
 *            this code on a commercial system, you must obtain a license from
 *            the holder of this copyright.  To obtain a license, mail the
 *            copyright holder listed at the top of this copyright notice.
 *
 * USE THIS PROGRAM AT YOUR OWN RISK.  This program is provided as-is without
 * any warranty of any kind, either expressed or implied, including, but not
 * limited to, the implied warranties of merchantability and fitness for a
 * particular purpose.  The entire risk as to the quality and performance of
 * this program is with you.  Should this program prove defective, you assume
 * the cost of all necessary servicing, repair, or correction.
 */

#include <termios.h>            /* Terminal manipulation */
#include <unistd.h>             /* Terminal manipulation */
#include <stdio.h>
#include "../get_input.h"
#include "../menu_func.h"

main(int argc, char *argv[]) {
  char bs, new_bs;
  int flag = 0;
  struct termios save_scr, secure_scr;

  /* Put the terminal into raw mode */
  if (tcgetattr(0, &save_scr) == -1) {
    fprintf(stderr, "Unable to get terminal settings\n");
    waitkey();
    exit(1);
  }
  secure_scr = save_scr;
  cfmakeraw(&secure_scr);
  secure_scr.c_oflag |= OPOST;
  if (tcsetattr(0, 0, &secure_scr) == -1) {
    fprintf(stderr, "Unable to set terminal settings\n");
    waitkey();
    exit(1);
  }

  /* Loop until a valid erase key is entered */
  while (1) {
    if (!flag) {
      printf("Please press your backspace key: ");
      bs = getc(stdin);
      putc('\n', stdout);
    } else {
      printf("\nYou have entered a non-standard backspace key.\n");
      printf("Please press your backspace key again: ");
      new_bs = getc(stdin);
      putc('\n', stdout);
      if (new_bs == bs)
        break;
      printf("\n\nYour entries do not match!  Let's try this again.\n\n");
      flag = 0;
      continue;
    }

    /* Check is a standard erase key was pressed.  This relies on ASCII. */
    if ((bs == 127) || (bs == 8))
      break;
    else flag = 1;
  }

  /* Reset the terminal settings */
  save_scr.c_cc[VERASE] = bs;
  if (tcsetattr(0, 0, &save_scr) == -1) {
    fprintf(stderr, "Unable to set terminal settings\n");
    waitkey();
    exit(1);
  }
}
