/* File     : set_cols.c
 * Author   : Karyl F. Stein <xenon@xenos.net>
 * Purpose  : Input and set the terminal rows.
 *
 * Copyright: (C)1998 Karyl F. Stein <xenon@xenos.net>
 *
 *            Permission is granted to use this code in whole or in part for
 *            non-commercial purposes as long as the following conditions are
 *            met:
 *
 *            1) Any modifications to this code are clearly marked if the
 *               modified code is distributed to other people other than the
 *               modifier,
 *            2) This copyright remains with any distributed versions, and
 *            3) Credit is given to the author if parts of this code are used.
 *
 *            If you use this code to make money in any form or if you use
 *            this code on a commercial system, you must obtain a license from
 *            the holder of this copyright.  To obtain a license, mail the
 *            copyright holder listed at the top of this copyright notice.
 *
 * USE THIS PROGRAM AT YOUR OWN RISK.  This program is provided as-is without
 * any warranty of any kind, either expressed or implied, including, but not
 * limited to, the implied warranties of merchantability and fitness for a
 * particular purpose.  The entire risk as to the quality and performance of
 * this program is with you.  Should this program prove defective, you assume
 * the cost of all necessary servicing, repair, or correction.
 */

#include <stdio.h>
#include <sys/ioctl.h>     /* ioctl() */
#include "../get_input.h"
#include "../menu_func.h"
#include "../xenmenu.h"

#define HELPFILE "/usr/noton/xnew/text/row_help.txt"

main(int argc, char *argv[]) {
  char *input;
  struct winsize win;

  ioctl(1,TIOCGWINSZ,&win);
  while (1) {
    puts("To exit, just press ENTER - For help, enter ?");
    input = get_input("Enter your screen height, (rows): ", 3, getcols(), NUMBER | HELP);
    if (input == NULL)
      printfile(HELPFILE, FALSE);
    else if (*input == '\0')
      exit(0);
    else break;
  }
  win.ws_row = atoi(input);
  ioctl(1,TIOCSWINSZ,&win);
}
