/*
 * Decompiled with CFR 0.152.
 */
package xnap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Properties;
import xnap.XNap;
import xnap.util.FileHelper;
import xnap.util.JarClassLoader;

public class XNapLoader {
    private static String[] arguments = new String[0];

    public static void main(String[] stringArray) {
        arguments = stringArray;
        XNapLoader.getXNapJar();
        File file = XNapLoader.checkForXNapJar();
        if (file != null) {
            try {
                XNapLoader.run(file);
                System.exit(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        XNap.main(stringArray);
    }

    public static File checkForXNapJar() {
        String string = FileHelper.getHomeDir() + "jars" + File.separatorChar;
        File file = new File(string, "xnap.jar");
        File file2 = new File(file.getAbsolutePath() + ".properties");
        if (!file2.canRead() || !file.canRead()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            try {
                long l = Long.parseLong(properties.getProperty("releaseNr"));
                if (l > 2003011801L) {
                    System.out.println("newer version found: " + properties.getProperty("version"));
                    return file;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static File getXNapJar() {
        URL uRL = FileHelper.getResource("xnap/XNap.class");
        String string = uRL.getFile();
        int n = string.lastIndexOf("!/");
        if (n > 0) {
            string = "//" + string.substring(5, n);
            File file = new File(string);
            System.out.println("found xnap.jar: " + file.getAbsolutePath());
            return file.exists() && file.canWrite() ? file : null;
        }
        return null;
    }

    public static void loadXNap(String[] stringArray) {
        JarClassLoader jarClassLoader = JarClassLoader.getInstance();
        jarClassLoader.init();
        try {
            Class<?> clazz = jarClassLoader.loadClass("xnap.XNap");
            Method method = clazz.getMethod("main", stringArray.getClass());
            ((AccessibleObject)method).setAccessible(true);
            int n = method.getModifiers();
            if (method.getReturnType() != Void.TYPE || !Modifier.isStatic(n) || !Modifier.isPublic(n)) {
                throw new NoSuchMethodException("main");
            }
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void run(String string, File file) throws IOException {
        String[] stringArray = new String[]{string, "-jar", file.getAbsolutePath()};
        String[] stringArray2 = new String[stringArray.length + arguments.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        System.arraycopy(arguments, 0, stringArray2, stringArray.length, arguments.length);
        System.out.print("running: ");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.print(stringArray2[n] + " ");
            ++n;
        }
        System.out.println();
        Process process = Runtime.getRuntime().exec(stringArray2);
    }

    public static void run(File file) throws IOException {
        try {
            XNapLoader.run("java", file);
        }
        catch (IOException iOException) {
            XNapLoader.run("/usr/bin/java", file);
        }
    }
}

