/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.cmdl.Console;
import xnap.gui.AbstractPanel;
import xnap.gui.AutoDownloadEditorDialog;
import xnap.gui.Dialogs;
import xnap.gui.XNapFrame;
import xnap.gui.action.MenuAction;
import xnap.gui.action.OpenFileWithMenu;
import xnap.gui.event.DoubleClickListener;
import xnap.gui.event.FileCollector;
import xnap.gui.event.OpenFileAction;
import xnap.gui.event.PopupListener;
import xnap.gui.event.UserSupport;
import xnap.gui.menu.UserMenu;
import xnap.gui.table.FilteredTransferTableModel;
import xnap.gui.table.TransferTableModel;
import xnap.net.AutoDownload;
import xnap.net.IDownloadContainer;
import xnap.net.ITransferContainer;
import xnap.net.IUploadContainer;
import xnap.net.IUser;
import xnap.net.UserContainer;
import xnap.util.DownloadQueue;
import xnap.util.TransferQueue;
import xnap.util.UploadQueue;
import xnap.util.launcher.LauncherSupport;

public class TransferSubPanel
extends AbstractPanel
implements FileCollector,
UserSupport {
    private boolean tabbed;
    private int dividerLoc = -1;
    private JTabbedPane jtp = null;
    private JSplitPane jsp = null;
    private JTable jtaDownloads;
    private TransferTableModel ttmDownloads;
    private JScrollPane jspDl;
    private JTable jtaUploads;
    private TransferTableModel ttmUploads;
    private JScrollPane jspUl;
    private AbortAction abortAction = new AbortAction();
    private ClearAction clearAction = new ClearAction();
    private DeleteAction deleteAction = new DeleteAction();
    private EditFilterAction acEditFilter = new EditFilterAction();
    private ResumeAction resumeAction = new ResumeAction();
    private OpenFileAction acOpenFile = new OpenFileAction(this);
    private ResumeSlashOpenAction acRSOAction = new ResumeSlashOpenAction();
    private MenuAction acMenu = new MenuAction(new UserMenu(this));

    private final void initialize(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        JButton jButton = new JButton(this.abortAction);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.clearAction);
        jPanel.add(jButton2);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.resumeAction);
        jPopupMenu.add(this.abortAction);
        jPopupMenu.add(this.acEditFilter);
        jPopupMenu.add(this.deleteAction);
        if (!bl) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.clearAction);
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.acOpenFile);
        jPopupMenu.add(new OpenFileWithMenu(this));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new UserMenu(this));
        this.ttmDownloads = bl ? new FilteredTransferTableModel(DownloadQueue.getInstance(), "download") : new TransferTableModel(DownloadQueue.getInstance(), "download", XNap.tr("Download Table"));
        this.jtaDownloads = this.ttmDownloads.createJTable();
        this.jtaDownloads.setShowGrid(false);
        this.jtaDownloads.addFocusListener(new FocusSelectionListener());
        PopupListener popupListener = new PopupListener(jPopupMenu);
        this.jtaDownloads.addMouseListener(popupListener);
        this.jtaDownloads.addMouseListener(new DoubleClickListener(this.acRSOAction, this.jtaDownloads));
        this.jtaDownloads.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.acRSOAction);
        this.jtaDownloads.getActionMap().put(this.acRSOAction, this.acRSOAction);
        this.jtaDownloads.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.deleteAction);
        this.jtaDownloads.getActionMap().put(this.deleteAction, this.deleteAction);
        this.jtaDownloads.getInputMap().put(KeyStroke.getKeyStroke(113, 0), this.acEditFilter);
        this.jtaDownloads.getActionMap().put(this.acEditFilter, this.acEditFilter);
        this.jspDl = new JScrollPane();
        this.jspDl.setViewportView(this.jtaDownloads);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        jPopupMenu2.add(new JMenuItem(new StartAction()));
        jPopupMenu2.add(new JMenuItem(this.abortAction));
        if (!bl) {
            jPopupMenu2.addSeparator();
            jPopupMenu2.add(new JMenuItem(this.clearAction));
        }
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(new JMenuItem(this.acOpenFile));
        jPopupMenu2.add(new OpenFileWithMenu(this));
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(new UserMenu(this));
        this.ttmUploads = bl ? new FilteredTransferTableModel(UploadQueue.getInstance(), "upload") : new TransferTableModel(UploadQueue.getInstance(), "upload", XNap.tr("Upload Table"));
        this.jtaUploads = this.ttmUploads.createJTable();
        this.jtaUploads.setShowGrid(false);
        this.jtaUploads.addFocusListener(new FocusSelectionListener());
        PopupListener popupListener2 = new PopupListener(jPopupMenu2);
        this.jtaUploads.addMouseListener(popupListener2);
        this.jtaUploads.addMouseListener(new DoubleClickListener(this.acOpenFile, this.jtaUploads));
        this.jtaUploads.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.acOpenFile);
        this.jtaUploads.getActionMap().put(this.acOpenFile, this.acOpenFile);
        this.jspUl = new JScrollPane();
        this.jspUl.setViewportView(this.jtaUploads);
        this.setLayout(new BorderLayout());
    }

    public AbstractAction[] getActions() {
        return new AbstractAction[]{this.resumeAction, null, this.abortAction, this.deleteAction, null, this.acMenu, null, this.clearAction};
    }

    public int getDividerLocation() {
        return this.tabbed ? this.dividerLoc : this.jsp.getDividerLocation();
    }

    public void setDividerLocation(int n) {
        this.dividerLoc = n;
        if (this.tabbed) {
            return;
        }
        if (n == -1) {
            this.jsp.setDividerLocation(0.5);
        } else {
            this.jsp.setDividerLocation(n);
        }
    }

    public void setTabbed(boolean bl) {
        this.tabbed = bl;
        if (this.tabbed) {
            this.jtp = new JTabbedPane();
            this.jtp.addTab(XNap.tr("Downloads"), this.jspDl);
            this.jtp.addTab(XNap.tr("Uploads"), this.jspUl);
            if (this.jsp != null) {
                this.dividerLoc = this.jsp.getDividerLocation();
                this.remove(this.jsp);
                this.jsp = null;
            }
            this.add((Component)this.jtp, "Center");
        } else {
            this.jsp = new JSplitPane(0);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder(XNap.tr("Downloads", 1)));
            jPanel.add((Component)this.jspDl, "Center");
            this.jsp.add((Component)jPanel, "top");
            jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder(XNap.tr("Uploads", 1)));
            jPanel.add((Component)this.jspUl, "Center");
            this.jsp.add((Component)jPanel, "bottom");
            this.jsp.setOneTouchExpandable(true);
            this.jsp.setResizeWeight(1.0);
            this.jsp.setDividerLocation(this.dividerLoc);
            if (this.jtp != null) {
                this.remove(this.jtp);
                this.jtp = null;
            }
            this.add((Component)this.jsp, "Center");
        }
    }

    protected JTable getSelectedTable() {
        if (this.tabbed) {
            if (this.jtp.getSelectedComponent() == this.jspDl) {
                return this.jtaDownloads;
            }
            if (this.jtp.getSelectedComponent() == this.jspUl) {
                return this.jtaUploads;
            }
        } else {
            if (this.jtaDownloads.getSelectedRowCount() > 0) {
                return this.jtaDownloads;
            }
            if (this.jtaUploads.getSelectedRowCount() > 0) {
                return this.jtaUploads;
            }
        }
        return null;
    }

    protected TransferQueue getSelectedQueue() {
        JTable jTable = this.getSelectedTable();
        if (jTable == null) {
            return null;
        }
        TransferTableModel transferTableModel = (TransferTableModel)jTable.getModel();
        return transferTableModel.getQueue();
    }

    protected ITransferContainer[] getSelectedTransfers() {
        JTable jTable = this.getSelectedTable();
        if (jTable == null) {
            return new ITransferContainer[0];
        }
        TransferTableModel transferTableModel = (TransferTableModel)jTable.getModel();
        int[] nArray = jTable.getSelectedRows();
        ITransferContainer[] iTransferContainerArray = new ITransferContainer[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            iTransferContainerArray[n] = transferTableModel.get(nArray[n]);
            ++n;
        }
        return iTransferContainerArray;
    }

    public File[] getFiles() {
        ITransferContainer[] iTransferContainerArray = this.getSelectedTransfers();
        File[] fileArray = new File[iTransferContainerArray.length];
        int n = 0;
        while (n < iTransferContainerArray.length) {
            fileArray[n] = iTransferContainerArray[n].getFile();
            ++n;
        }
        return fileArray;
    }

    public JMenu getDownloadTableMenu() {
        return this.ttmDownloads.createJMenu();
    }

    public JMenu getUploadTableMenu() {
        return this.ttmUploads.createJMenu();
    }

    public IUser[] getUsers() {
        ITransferContainer[] iTransferContainerArray = this.getSelectedTransfers();
        if (iTransferContainerArray.length == 0) {
            return null;
        }
        LinkedList<IUser> linkedList = new LinkedList<IUser>();
        int n = 0;
        while (n < iTransferContainerArray.length) {
            IUser iUser = iTransferContainerArray[n].getUser();
            if (iUser != null) {
                if (iUser instanceof UserContainer) {
                    linkedList.addAll(Arrays.asList(((UserContainer)iUser).getUsers()));
                } else {
                    linkedList.add(iUser);
                }
            }
            ++n;
        }
        IUser[] iUserArray = new IUser[linkedList.size()];
        System.arraycopy(linkedList.toArray(), 0, iUserArray, 0, iUserArray.length);
        return iUserArray;
    }

    public TransferSubPanel(boolean bl, boolean bl2) {
        this.initialize(bl);
        this.setTabbed(bl2);
    }

    private class AbortAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ITransferContainer[] iTransferContainerArray = TransferSubPanel.this.getSelectedTransfers();
            TransferQueue transferQueue = TransferSubPanel.this.getSelectedQueue();
            if (iTransferContainerArray.length == 0) {
                TransferSubPanel.this.setStatus(XNap.tr("Please select something first"));
            } else {
                int n = 0;
                while (n < iTransferContainerArray.length) {
                    if (!transferQueue.abort(iTransferContainerArray[n])) {
                        TransferSubPanel.this.setStatus(XNap.tr("Transfer not running"));
                    }
                    ++n;
                }
            }
        }

        public AbortAction() {
            this.putValue("Name", XNap.tr("Abort"));
            this.putValue("ShortDescription", XNap.tr("Abort the selected transfer(s)"));
            this.putValue("SmallIcon", XNapFrame.getIcon("stop.png"));
            this.putValue("MnemonicKey", new Integer(65));
        }
    }

    private class ClearAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TransferQueue transferQueue = TransferSubPanel.this.getSelectedQueue();
            if (transferQueue == null) {
                DownloadQueue.getInstance().clearFinished();
                UploadQueue.getInstance().clearFinished();
            } else {
                transferQueue.clearFinished();
            }
        }

        public ClearAction() {
            this.putValue("Name", XNap.tr("Clear finished"));
            this.putValue("ShortDescription", XNap.tr("Clear all finished transfers"));
            this.putValue("SmallIcon", XNapFrame.getIcon("edittrash.png"));
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (TransferSubPanel.this.getSelectedTable() != TransferSubPanel.this.jtaDownloads) {
                TransferSubPanel.this.setStatus(XNap.tr("You can only delete downloads."));
                return;
            }
            ITransferContainer[] iTransferContainerArray = TransferSubPanel.this.getSelectedTransfers();
            DownloadQueue downloadQueue = (DownloadQueue)TransferSubPanel.this.getSelectedQueue();
            if (iTransferContainerArray.length == 0) {
                TransferSubPanel.this.setStatus(XNap.tr("Please select something first"));
            } else if ((iTransferContainerArray = Dialogs.showDeleteDownloadsDialog(TransferSubPanel.this, iTransferContainerArray)) != null) {
                int n = 0;
                while (n < iTransferContainerArray.length) {
                    downloadQueue.delete((IDownloadContainer)iTransferContainerArray[n]);
                    ++n;
                }
            }
        }

        public DeleteAction() {
            this.putValue("Name", XNap.tr("Delete"));
            this.putValue("ShortDescription", XNap.tr("Delete incomplete file"));
            this.putValue("SmallIcon", XNapFrame.getIcon("editdelete.png"));
            this.putValue("MnemonicKey", new Integer(68));
        }
    }

    private class ResumeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (TransferSubPanel.this.getSelectedTable() != TransferSubPanel.this.jtaDownloads) {
                TransferSubPanel.this.setStatus(XNap.tr("You can only resume downloads."));
                return;
            }
            ITransferContainer[] iTransferContainerArray = TransferSubPanel.this.getSelectedTransfers();
            DownloadQueue downloadQueue = (DownloadQueue)TransferSubPanel.this.getSelectedQueue();
            if (iTransferContainerArray.length == 0) {
                TransferSubPanel.this.setStatus(XNap.tr("Please select something first"));
            } else {
                int n = 0;
                while (n < iTransferContainerArray.length) {
                    IDownloadContainer iDownloadContainer = (IDownloadContainer)iTransferContainerArray[n];
                    if (!downloadQueue.resume(iDownloadContainer)) {
                        iDownloadContainer.skip();
                        TransferSubPanel.this.setStatus(XNap.tr("Download already in progress or finished"));
                    }
                    ++n;
                }
            }
        }

        public ResumeAction() {
            this.putValue("Name", XNap.tr("Resume"));
            this.putValue("ShortDescription", XNap.tr("Resume Download"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class FocusSelectionListener
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == TransferSubPanel.this.jtaDownloads) {
                TransferSubPanel.this.jtaUploads.getSelectionModel().clearSelection();
            } else if (focusEvent.getSource() == TransferSubPanel.this.jtaUploads) {
                TransferSubPanel.this.jtaDownloads.getSelectionModel().clearSelection();
            }
        }

        FocusSelectionListener() {
        }
    }

    private class EditFilterAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ITransferContainer[] iTransferContainerArray = TransferSubPanel.this.getSelectedTransfers();
            if (iTransferContainerArray.length == 0) {
                TransferSubPanel.this.setStatus(XNap.tr("Please select something first"));
            } else if (iTransferContainerArray[0] instanceof AutoDownload) {
                AutoDownload autoDownload = (AutoDownload)iTransferContainerArray[0];
                AutoDownloadEditorDialog.showDialog(TransferSubPanel.this, autoDownload);
            } else {
                TransferSubPanel.this.setStatus(XNap.tr("This search filter can not be edited"));
            }
        }

        public EditFilterAction() {
            this.putValue("Name", XNap.tr("Edit search filter"));
            this.putValue("ShortDescription", XNap.tr("Edit search filter"));
            this.putValue("SmallIcon", XNapFrame.getIcon("edit.png"));
            this.putValue("MnemonicKey", new Integer(69));
        }
    }

    private class StartAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (TransferSubPanel.this.getSelectedTable() != TransferSubPanel.this.jtaUploads) {
                TransferSubPanel.this.setStatus(XNap.tr("You can only start downloads"));
                return;
            }
            ITransferContainer[] iTransferContainerArray = TransferSubPanel.this.getSelectedTransfers();
            UploadQueue uploadQueue = (UploadQueue)TransferSubPanel.this.getSelectedQueue();
            if (iTransferContainerArray.length == 0) {
                TransferSubPanel.this.setStatus(XNap.tr("Please select something first"));
            } else {
                int n = 0;
                while (n < iTransferContainerArray.length) {
                    IUploadContainer iUploadContainer = (IUploadContainer)iTransferContainerArray[n];
                    uploadQueue.startUpload(iUploadContainer);
                    ++n;
                }
            }
        }

        public StartAction() {
            this.putValue("Name", XNap.tr("Start"));
            this.putValue("ShortDescription", XNap.tr("Start Upload"));
            this.putValue("SmallIcon", XNapFrame.getIcon("misc.png"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }

    private class ResumeSlashOpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (TransferSubPanel.this.getSelectedTable() != TransferSubPanel.this.jtaDownloads) {
                return;
            }
            ITransferContainer[] iTransferContainerArray = TransferSubPanel.this.getSelectedTransfers();
            DownloadQueue downloadQueue = (DownloadQueue)TransferSubPanel.this.getSelectedQueue();
            if (iTransferContainerArray.length == 0) {
                TransferSubPanel.this.setStatus(XNap.tr("Please select something first"));
            } else {
                int n = 0;
                while (n < iTransferContainerArray.length) {
                    IDownloadContainer iDownloadContainer = (IDownloadContainer)iTransferContainerArray[n];
                    if (iDownloadContainer.isResumable()) {
                        if (!downloadQueue.resume(iDownloadContainer)) {
                            TransferSubPanel.this.setStatus(XNap.tr("Download already in progress or finished"));
                        }
                    } else {
                        try {
                            LauncherSupport.open(iDownloadContainer.getFile());
                        }
                        catch (IOException iOException) {
                            Console.getInstance().println(iOException.getMessage());
                        }
                    }
                    ++n;
                }
            }
        }
    }
}

