/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.table.DefaultTableCellRenderer;
import xnap.gui.util.GUIHelper;
import xnap.util.Formatter;
import xnap.util.Preferences;
import xnap.util.Progress;

public class ProgressCellRenderer
extends DefaultTableCellRenderer {
    protected double progress = 0.0;
    protected String text = "";
    private Preferences prefs = Preferences.getInstance();
    private Color runningColor = GUIHelper.getColor("progressRunning");
    private Color finishedColor = GUIHelper.getColor("progressFinished");

    protected void setValue(Object object) {
        if (object instanceof Progress) {
            Progress progress = (Progress)object;
            this.progress = progress.progress;
            this.text = progress.toString();
            this.setToolTipText(Formatter.formatNumber(this.progress, 2) + "%" + (this.text.length() == 0 ? "" : ", " + this.text));
        }
        super.setValue(null);
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        graphics.setColor(Color.lightGray);
        graphics.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        if (this.progress > 0.0) {
            int n2 = (this.getWidth() - 2) * (int)this.progress / 100;
            n = this.getHeight() - 2;
            graphics.setColor(this.progress < 100.0 ? this.runningColor : this.finishedColor);
            graphics.fillRect(1, 1, n2, n);
        }
        if (this.text != null && this.text.length() > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.stringWidth(this.text);
            int n3 = (this.getWidth() - n) / 2;
            int n4 = this.getHeight() - 3;
            graphics.setColor(this.getForeground());
            graphics.drawString(this.text, n3 > 1 ? n3 : 1, n4);
        }
    }
}

