/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.util.AbstractCollection;
import java.util.ArrayList;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.LinkSpeedCellRenderer;
import xnap.gui.table.NumberCellRenderer;
import xnap.net.IUser;
import xnap.util.LinkSpeed;
import xnap.util.Preferences;

public class UserTableModel
extends AbstractDynamicTableModel {
    public static final int NAME = 0;
    public static final int FILE_COUNT = 1;
    public static final int LINK_SPEED = 2;
    public static final int STATUS = 3;
    public static final int DOWNLOADS = 4;
    public static final int UPLOADS = 5;
    public static final int CLIENT = 6;
    public static final int COMMENT = 7;
    protected Column[] columns = new Column[]{new Column(XNap.tr("User"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UserTableModel.class$("java.lang.String"))), new Column(XNap.tr("File Count"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = UserTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(XNap.tr("Link Speed"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UserTableModel.class$("java.lang.String")), new LinkSpeedCellRenderer()), new Column(XNap.tr("Status"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UserTableModel.class$("java.lang.String"))), new Column(XNap.tr("Downloads"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = UserTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(XNap.tr("Uploads"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = UserTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(XNap.tr("Client"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UserTableModel.class$("java.lang.String"))), new Column(XNap.tr("Comment"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = UserTableModel.class$("java.lang.String")))};
    protected ArrayList rows = new ArrayList();
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Integer;

    public void add(IUser iUser, boolean bl) {
        if (!bl || !this.contains(iUser)) {
            this.rows.add(iUser);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }
    }

    public void add(IUser iUser) {
        this.add(iUser, true);
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public boolean contains(IUser iUser) {
        return this.rows.contains(iUser);
    }

    public IUser get(int n) {
        return (IUser)this.rows.get(this.mapToIndex(n));
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object get(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        IUser iUser = (IUser)this.rows.get(n);
        if (iUser == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return iUser.getName();
            }
            case 1: {
                return new Integer(iUser.getFileCount());
            }
            case 2: {
                return new LinkSpeed(iUser.getLinkSpeed()).toString();
            }
            case 3: {
                return iUser.getStatusText();
            }
            case 4: {
                return new Integer(iUser.getLocalDownloadCount());
            }
            case 5: {
                return new Integer(iUser.getLocalUploadCount());
            }
            case 6: {
                return iUser.getClientInfo();
            }
            case 7: {
                return iUser.getComment();
            }
        }
        return "";
    }

    public String getTableName() {
        return XNap.tr("User Table");
    }

    public int indexOf(IUser iUser) {
        int n = this.rows.indexOf(iUser);
        return n != -1 ? this.mapToIndex(n) : -1;
    }

    public void remove(IUser iUser) {
        int n = this.rows.indexOf(iUser);
        if (n != -1) {
            ((AbstractCollection)this.rows).remove(iUser);
            this.fireTableRowsDeleted(n, n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public UserTableModel(String string) {
        super(string, Preferences.getInstance());
        this.setColumns(this.columns);
    }
}

