/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.text;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class EmacsKeyBindings {
    public static final String killLineAction = "emacs-kill-line";
    public static final String killRingSaveAction = "emacs-kill-ring-save";
    public static final String killRegionAction = "emacs-kill-region";
    public static final String backwardKillWordAction = "emacs-backward-kill-word";
    public static final String capitalizeWordAction = "emacs-capitalize-word";
    public static final String downcaseWordAction = "emacs-downcase-word";
    public static final String killWordAction = "emacs-kill-word";
    public static final String setMarkCommandAction = "emacs-set-mark-command";
    public static final String upcaseWordAction = "emacs-upcase-word";
    public static final JTextComponent.KeyBinding[] EMACS_KEY_BINDINGS = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 2), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 8), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 2), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(69, 2), "caret-end-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, 2), "caret-begin-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 2), "delete-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(78, 2), "caret-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(80, 2), "caret-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 8), "caret-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 8), "caret-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 9), "caret-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 8), "caret-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 2), "caret-forward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 2), "caret-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, 2), "page-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, 8), "page-up")};

    public static void loadEmacsKeyBindings() {
        JTextComponent[] jTextComponentArray = new JTextComponent[]{new JTextArea(), new JTextPane(), new JTextField(), new JEditorPane()};
        int n = 0;
        while (n < jTextComponentArray.length) {
            Keymap keymap = jTextComponentArray[n].getKeymap();
            JTextComponent.loadKeymap(keymap, EMACS_KEY_BINDINGS, jTextComponentArray[n].getActions());
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(68, 8), new KillWordAction(killWordAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(8, 8), new BackwardKillWordAction(backwardKillWordAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(32, 2), new SetMarkCommandAction(setMarkCommandAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(87, 8), new KillRingSaveAction(killRingSaveAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(87, 2), new KillRegionAction(killRegionAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(75, 2), new KillLineAction(killLineAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(89, 2), new YankAction("emacs-yank"));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(89, 8), new YankPopAction("emacs-yank-pop"));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 8), new CapitalizeWordAction(capitalizeWordAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(76, 8), new DowncaseWordAction(downcaseWordAction));
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(85, 8), new UpcaseWordAction(upcaseWordAction));
            ++n;
        }
    }

    public static class KillWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    jTextComponent.setSelectionStart(n);
                    n = Utilities.getNextWord(jTextComponent, n);
                    jTextComponent.setSelectionEnd(n);
                    jTextComponent.cut();
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        KillWordAction(String string) {
            super(string);
        }
    }

    public static class BackwardKillWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    jTextComponent.setSelectionEnd(n);
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.cut();
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        BackwardKillWordAction(String string) {
            super(string);
        }
    }

    public static class KillRingSaveAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && SetMarkCommandAction.isMarked(jTextComponent)) {
                jTextComponent.setSelectionStart(SetMarkCommandAction.getCaretPosition());
                jTextComponent.moveCaretPosition(jTextComponent.getCaretPosition());
                jTextComponent.copy();
                YankAction.add(jTextComponent.getSelectedText());
                SetMarkCommandAction.reset();
            }
        }

        KillRingSaveAction(String string) {
            super(string);
        }
    }

    public static class KillRegionAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && SetMarkCommandAction.isMarked(jTextComponent)) {
                jTextComponent.setSelectionStart(SetMarkCommandAction.getCaretPosition());
                jTextComponent.moveCaretPosition(jTextComponent.getCaretPosition());
                SetMarkCommandAction.reset();
                YankAction.add(jTextComponent.getSelectedText());
                jTextComponent.cut();
            }
        }

        KillRegionAction(String string) {
            super(string);
        }
    }

    public static class KillLineAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowEnd(jTextComponent, n);
                    if (n == n2 && jTextComponent.isEditable()) {
                        Document document = jTextComponent.getDocument();
                        document.remove(n2, 1);
                    } else {
                        jTextComponent.setSelectionStart(n);
                        jTextComponent.setSelectionEnd(n2);
                        YankAction.add(jTextComponent.getSelectedText());
                        jTextComponent.cut();
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        KillLineAction(String string) {
            super(string);
        }
    }

    public static class SetMarkCommandAction
    extends TextAction {
        private static int position = -1;
        private static JTextComponent jtc;

        public void actionPerformed(ActionEvent actionEvent) {
            jtc = this.getTextComponent(actionEvent);
            if (jtc != null) {
                position = jtc.getCaretPosition();
            }
        }

        public static boolean isMarked(JTextComponent jTextComponent) {
            return jtc == jTextComponent && position != -1;
        }

        public static void reset() {
            jtc = null;
            position = -1;
        }

        public static int getCaretPosition() {
            return position;
        }

        SetMarkCommandAction(String string) {
            super(string);
        }
    }

    public static class YankAction
    extends TextAction {
        public static LinkedList killring = new LinkedList();
        public static int start = -1;
        public static int end = -1;

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    start = jTextComponent.getCaretPosition();
                    jTextComponent.paste();
                    end = jTextComponent.getCaretPosition();
                    YankAction.add(jTextComponent.getText(start, end));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void add(String string) {
            Iterator iterator = killring.iterator();
            while (iterator.hasNext()) {
                if (!string.equals((String)iterator.next())) continue;
                iterator.remove();
                break;
            }
            killring.addFirst(string);
        }

        public static String getNext(String string) {
            if (killring.size() == 0) {
                return null;
            }
            if (string == null) {
                return (String)killring.getFirst();
            }
            Object object = killring.iterator();
            while (object.hasNext()) {
                if (!string.equals((String)object.next())) continue;
                object.remove();
                if (!object.hasNext()) break;
                String string2 = (String)object.next();
                killring.addFirst(string);
                return string2;
            }
            object = (String)killring.getFirst();
            killring.addFirst(string);
            return object;
        }

        public YankAction(String string) {
            super(string);
        }
    }

    public static class YankPopAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && YankAction.killring.size() > 0) {
                jTextComponent.setSelectionStart(YankAction.start);
                jTextComponent.setSelectionEnd(YankAction.end);
                String string = YankAction.getNext(jTextComponent.getSelectedText());
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                    YankAction.end = jTextComponent.getCaretPosition();
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        public YankPopAction(String string) {
            super(string);
        }
    }

    public static class CapitalizeWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getNextWord(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    String string = jTextComponent.getText(n, n2 - n);
                    jTextComponent.replaceSelection(string.toLowerCase());
                    int n3 = Utilities.getWordStart(jTextComponent, n);
                    String string2 = jTextComponent.getText(n3, 1);
                    if (string2.equals(" ")) {
                        ++n3;
                        n3 = Utilities.getWordStart(jTextComponent, n3);
                        string2 = jTextComponent.getText(n3, 1);
                    }
                    if (Character.isLetter(string2.charAt(0))) {
                        jTextComponent.setSelectionStart(n3);
                        jTextComponent.setSelectionEnd(n3 + 1);
                        jTextComponent.replaceSelection(string2.toUpperCase());
                    }
                    n2 = Utilities.getWordEnd(jTextComponent, n3);
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        public CapitalizeWordAction(String string) {
            super(string);
        }
    }

    public static class DowncaseWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getNextWord(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    String string = jTextComponent.getText(n, n2 - n);
                    jTextComponent.replaceSelection(string.toLowerCase());
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        public DowncaseWordAction(String string) {
            super(string);
        }
    }

    public static class UpcaseWordAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getNextWord(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    String string = jTextComponent.getText(n, n2 - n);
                    jTextComponent.replaceSelection(string.toUpperCase());
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }

        public UpcaseWordAction(String string) {
            super(string);
        }
    }
}

