/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.util;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import xnap.util.EventList;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class SwingSynchronizedCache
implements ListListener {
    private LinkedList insertCache = new LinkedList();
    private ListListener listener;
    private boolean insertPending = false;
    private volatile int maxInsertsPerRun = 100;

    public void addToCache(ListEvent listEvent) {
        LinkedList linkedList = this.insertCache;
        synchronized (linkedList) {
            this.insertCache.addLast(listEvent);
            if (this.insertPending) {
                return;
            }
            this.insertPending = true;
        }
        SwingUtilities.invokeLater(new InsertRunnable());
    }

    public void elementAdded(ListEvent listEvent) {
        this.addToCache(listEvent);
    }

    public void elementRemoved(ListEvent listEvent) {
        if (listEvent.getID() == 3) {
            LinkedList linkedList = this.insertCache;
            synchronized (linkedList) {
                this.insertCache.clear();
                this.insertPending = false;
                this.addToCache(listEvent);
            }
        } else {
            this.addToCache(listEvent);
        }
    }

    public void setMaxInsertsPerRun(int n) {
        this.maxInsertsPerRun = n;
    }

    static /* synthetic */ boolean access$3(SwingSynchronizedCache swingSynchronizedCache) {
        return swingSynchronizedCache.insertPending;
    }

    public SwingSynchronizedCache(EventList eventList, ListListener listListener) {
        this.listener = listListener;
        eventList.addListListener(this);
    }

    public SwingSynchronizedCache(ListListener listListener) {
        this.listener = listListener;
    }

    private class InsertRunnable
    implements Runnable {
        public void run() {
            LinkedList linkedList = SwingSynchronizedCache.this.insertCache;
            synchronized (linkedList) {
                int n = 0;
                Iterator iterator = SwingSynchronizedCache.this.insertCache.iterator();
                while (iterator.hasNext() && n < SwingSynchronizedCache.this.maxInsertsPerRun) {
                    ListEvent listEvent = (ListEvent)iterator.next();
                    if (listEvent.getID() == 1) {
                        SwingSynchronizedCache.this.listener.elementAdded(listEvent);
                    } else {
                        SwingSynchronizedCache.this.listener.elementRemoved(listEvent);
                    }
                    iterator.remove();
                    ++n;
                }
                if (SwingSynchronizedCache.this.insertCache.size() > 0) {
                    SwingUtilities.invokeLater(this);
                } else {
                    SwingSynchronizedCache.this.insertPending = false;
                }
            }
        }

        InsertRunnable() {
        }
    }
}

