/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import xnap.XNap;
import xnap.io.ThrottledOutputStream;
import xnap.net.AbstractTransferContainer;
import xnap.net.IUpload;
import xnap.net.IUploadContainer;
import xnap.net.IUser;

public class SimpleUpload
extends AbstractTransferContainer
implements IUploadContainer {
    public static final int BUFFER_SIZE = 512;
    private IUpload upload;

    public boolean equals(Object object) {
        if (object instanceof SimpleUpload) {
            return this.getUpload().equals(((SimpleUpload)object).getUpload());
        }
        return false;
    }

    public File getFile() {
        return this.upload.getFile();
    }

    public IUser getUser() {
        return this.upload.getUser();
    }

    public IUpload getUpload() {
        return this.upload;
    }

    public void reject(String string) {
        this.setStatus(7, string);
    }

    public void run() {
        this.getUser().modifyLocalUploadCount(1);
        this.setStatus(1);
        try {
            this.upload.connect();
        }
        catch (IOException iOException) {
            AbstractTransferContainer.logger.warn("upload connect failed", iOException);
            this.setStatus(7, iOException.getMessage());
        }
        if (!this.isDone()) {
            File file = this.getFile();
            if (file == null) {
                this.setStatus(7, XNap.tr("Invalid request"));
            } else {
                this.upload(file);
            }
        }
        this.getUser().modifyLocalUploadCount(-1);
        this.died();
    }

    private final void upload(File file) {
        this.setStatus(5);
        this.startTransfer();
        try {
            block6: {
                try {
                    byte[] byArray = new byte[ThrottledOutputStream.getBlocksize()];
                    AbstractTransferContainer.logger.debug("using a blocksize of " + ThrottledOutputStream.getBlocksize() + " bytes");
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    long l = bufferedInputStream.skip(this.upload.getOffset());
                    if (l != this.upload.getOffset()) {
                        throw new IOException("Could not set offset in file: " + l + " / " + this.upload.getOffset());
                    }
                    this.totalBytesTransferred = l;
                    while (!this.die) {
                        int n = bufferedInputStream.read(byArray, 0, byArray.length);
                        if (n <= 0) break;
                        this.upload.write(byArray, n);
                        this.totalBytesTransferred += (long)n;
                        this.bytesTransferred += (long)n;
                    }
                    if (this.die) break block6;
                    this.setStatus(6);
                }
                catch (IOException iOException) {
                    AbstractTransferContainer.logger.debug("upload failed", iOException);
                    this.setStatus(7);
                    Object var3_8 = null;
                    this.upload.close();
                }
            }
            Object var3_7 = null;
            this.upload.close();
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.upload.close();
            throw throwable;
        }
    }

    public SimpleUpload(IUpload iUpload) {
        this.upload = iUpload;
    }
}

