/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.Console;
import xnap.cmdl.Executer;
import xnap.net.AbstractSearch;
import xnap.net.ISearch;
import xnap.plugin.INetworkPlugin;
import xnap.plugin.IPlugin;
import xnap.util.Formatter;
import xnap.util.JarClassLoader;
import xnap.util.SearchFilter;
import xnap.util.event.StateEvent;
import xnap.util.event.StateListener;

public class PluginManager {
    protected static Logger logger = Logger.getLogger(class$Lxnap$plugin$PluginManager != null ? class$Lxnap$plugin$PluginManager : (class$Lxnap$plugin$PluginManager = PluginManager.class$("xnap.plugin.PluginManager")));
    protected static PluginManager singleton = null;
    protected Console console = Console.getInstance();
    protected Hashtable plugins = new Hashtable();
    protected Vector stateListeners = new Vector();
    protected HashSet packages = new HashSet();
    private static /* synthetic */ Class class$Lxnap$plugin$PluginManager;
    private static /* synthetic */ Class class$Lxnap$plugin$INetworkPlugin;

    public static synchronized PluginManager getInstance() {
        if (singleton == null) {
            singleton = new PluginManager();
        }
        return singleton;
    }

    public synchronized void installPlugin(String string) {
        try {
            String string2;
            Class<?> clazz = JarClassLoader.getInstance().loadClass(string);
            if (this.isValidPlugin(clazz) && !this.packages.contains(string2 = clazz.getPackage().getName())) {
                logger.info("installing plugin: " + string);
                IPlugin iPlugin = (IPlugin)clazz.newInstance();
                this.packages.add(string2);
                this.plugins.put(string, iPlugin);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("plugin not found: " + string);
        }
        catch (Throwable throwable) {
            logger.error("could not load: " + string, throwable);
        }
    }

    public boolean isValidPlugin(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == (class$Lxnap$plugin$INetworkPlugin != null ? class$Lxnap$plugin$INetworkPlugin : PluginManager.class$("xnap.plugin.INetworkPlugin"))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void installPlugins(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.installPlugin(stringArray[n]);
            }
            catch (Exception exception) {
                logger.warn("Counld not install plugin", exception);
            }
            ++n;
        }
    }

    public IPlugin getPluginByName(String string) {
        Enumeration enumeration = this.plugins.elements();
        while (enumeration.hasMoreElements()) {
            IPlugin iPlugin = (IPlugin)enumeration.nextElement();
            if (!iPlugin.getName().equalsIgnoreCase(string)) continue;
            return iPlugin;
        }
        return null;
    }

    public IPlugin getPlugin(String string) {
        return (IPlugin)this.plugins.get(string);
    }

    public synchronized IPlugin[] getPlugins() {
        IPlugin[] iPluginArray = new IPlugin[this.plugins.size()];
        int n = 0;
        Enumeration enumeration = this.plugins.elements();
        while (enumeration.hasMoreElements()) {
            iPluginArray[n] = (IPlugin)enumeration.nextElement();
            ++n;
        }
        return iPluginArray;
    }

    public void enablePlugins(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            logger.info("plugin manager: loading " + string2);
            if (!this.plugins.containsKey(string2)) continue;
            this.setEnabled(string2, true);
        }
    }

    public String disablePlugins() {
        String string = "";
        Enumeration enumeration = this.plugins.elements();
        while (enumeration.hasMoreElements()) {
            IPlugin iPlugin = (IPlugin)enumeration.nextElement();
            if (!iPlugin.isEnabled()) continue;
            string = string + iPlugin.getClass().getName() + ";";
            this.setEnabled(iPlugin, false);
        }
        return string;
    }

    public void addStateListener(StateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(StateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    protected void fireStateChanged(IPlugin iPlugin, boolean bl) {
        Object[] objectArray = this.stateListeners.toArray();
        if (objectArray != null) {
            StateEvent stateEvent = bl ? new StateEvent(iPlugin, 1) : new StateEvent(iPlugin, 2);
            int n = objectArray.length - 1;
            while (n >= 0) {
                if (bl) {
                    ((StateListener)objectArray[n]).stateEnabled(stateEvent);
                } else {
                    ((StateListener)objectArray[n]).stateDisabled(stateEvent);
                }
                --n;
            }
        }
    }

    public synchronized void setEnabled(String string, boolean bl) {
        IPlugin iPlugin = (IPlugin)this.plugins.get(string);
        this.setEnabled(iPlugin, bl);
    }

    public synchronized void setEnabled(IPlugin iPlugin, boolean bl) {
        if (bl) {
            if (!iPlugin.isEnabled()) {
                try {
                    iPlugin.start();
                    this.fireStateChanged(iPlugin, true);
                }
                catch (Throwable throwable) {
                    logger.error("could not enable plugin", throwable);
                }
            }
        } else if (iPlugin.isEnabled()) {
            this.fireStateChanged(iPlugin, false);
            iPlugin.stop();
        }
    }

    public synchronized ISearch[] search(SearchFilter searchFilter, int n) {
        LinkedList<ISearch> linkedList = new LinkedList<ISearch>();
        ISearch[] iSearchArray = this.plugins.elements();
        while (iSearchArray.hasMoreElements()) {
            ISearch[] iSearchArray2;
            IPlugin iPlugin = (IPlugin)iSearchArray.nextElement();
            if (!(iPlugin instanceof INetworkPlugin) || !iPlugin.isEnabled() || (iSearchArray2 = ((INetworkPlugin)iPlugin).search(searchFilter, n)) == null) continue;
            int n2 = 0;
            while (n2 < iSearchArray2.length) {
                linkedList.add(iSearchArray2[n2]);
                ++n2;
            }
        }
        iSearchArray = new AbstractSearch[linkedList.size()];
        System.arraycopy(linkedList.toArray(), 0, iSearchArray, 0, iSearchArray.length);
        return iSearchArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PluginManager() {
        this.installPlugins(JarClassLoader.getInstance().getClassNames(1));
        Executer.addCommand(new InfoCmd());
        Executer.addCommand(new ListCmd());
        Executer.addCommand(new LoadCmd());
        Executer.addCommand(new UnloadCmd());
    }

    protected class InfoCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            if (stringArray.length != 2) {
                return false;
            }
            IPlugin iPlugin = PluginManager.this.getPluginByName(stringArray[1]);
            if (iPlugin == null) {
                PluginManager.this.console.println("Could not find plugin " + stringArray[1]);
            } else {
                PluginManager.this.console.println(iPlugin.getDescription());
            }
            return true;
        }

        public InfoCmd() {
            this.putValue("cmd", new String[]{"plugininfo"});
            this.putValue("parameter", "[plugin]");
            this.putValue("shortHelp", "Show info about plugin.");
        }
    }

    protected class ListCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            IPlugin[] iPluginArray = PluginManager.this.getPlugins();
            if (iPluginArray.length == 0) {
                PluginManager.this.console.println("No plugins installed.");
            } else {
                Object object;
                String[] stringArray2 = new String[iPluginArray.length];
                int n = 0;
                while (n < iPluginArray.length) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(iPluginArray[n].getName());
                    ((StringBuffer)object).append("|");
                    ((StringBuffer)object).append(iPluginArray[n].isEnabled() ? "enabled" : " disabled");
                    ((StringBuffer)object).append("|");
                    ((StringBuffer)object).append(iPluginArray[n].getClass().getName());
                    stringArray2[n] = ((StringBuffer)object).toString();
                    ++n;
                }
                n = 0;
                object = new int[]{n, n, n};
                PluginManager.this.console.println(Formatter.formatTable(stringArray2, (int[])object));
            }
            return true;
        }

        public ListCmd() {
            this.putValue("cmd", new String[]{"listplugins", "lp"});
            this.putValue("shortHelp", "Show installed plugins.");
        }
    }

    protected class LoadCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            if (stringArray.length != 2) {
                return false;
            }
            IPlugin iPlugin = PluginManager.this.getPluginByName(stringArray[1]);
            if (iPlugin == null) {
                PluginManager.this.console.println("Could not find plugin " + stringArray[1]);
            } else if (iPlugin.isEnabled()) {
                PluginManager.this.console.println("Plugin already loaded");
            } else {
                PluginManager.this.setEnabled(iPlugin, true);
            }
            return true;
        }

        public LoadCmd() {
            this.putValue("cmd", new String[]{"load"});
            this.putValue("parameter", "[plugin]");
            this.putValue("shortHelp", "Load plugin.");
        }
    }

    protected class UnloadCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            if (stringArray.length != 2) {
                return false;
            }
            IPlugin iPlugin = PluginManager.this.getPluginByName(stringArray[1]);
            if (iPlugin == null) {
                PluginManager.this.console.println("Could not find plugin " + stringArray[1]);
            } else if (!iPlugin.isEnabled()) {
                PluginManager.this.console.println("Plugin not loaded");
            } else {
                PluginManager.this.setEnabled(iPlugin, false);
            }
            return true;
        }

        public UnloadCmd() {
            this.putValue("cmd", new String[]{"unload"});
            this.putValue("parameter", "[plugin]");
            this.putValue("shortHelp", "Unload plugin.");
        }
    }
}

