/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import xnap.io.ThrottledOutputStream;
import xnap.net.AbstractUpload;
import xnap.net.NetHelper;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.UploadSocket;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.AcceptFailedMessage;
import xnap.plugin.nap.net.msg.client.UploadAckMessage;
import xnap.plugin.nap.net.msg.client.UploadCompleteMessage;
import xnap.plugin.nap.net.msg.client.UploadingFileMessage;
import xnap.plugin.nap.net.msg.server.AltDownloadAckMessage;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.util.Debug;

public class Upload
extends AbstractUpload
implements MessageListener {
    public static final int CONNECT_TIMEOUT = 60000;
    protected Server server;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    protected String requestFilename;
    protected String host;
    protected int port;
    private Object lock = new Object();

    public void connect() throws IOException {
        if (!this.server.isConnected()) {
            throw new IOException(Plugin.tr("Server disconnected"));
        }
        if (!this.server.getUser(this.getUser().getName()).isAllowedToDownload()) {
            throw new IOException(Plugin.tr("Leecher rejected"));
        }
        MessageHandler.subscribe(501, this);
        MessageHandler.send(this.server, new UploadAckMessage(this.user.getName(), this.requestFilename));
        UploadSocket uploadSocket = null;
        if (this.server.getLocalPort() != 0) {
            uploadSocket = new UploadSocket(this.getUser().getName(), this.requestFilename);
            uploadSocket = (UploadSocket)this.server.getListener().waitForSocket(uploadSocket, 60000L);
        } else {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        MessageHandler.unsubscribe(501, this);
        if (uploadSocket == null && this.host == null && this.port == 0) {
            throw new IOException(Plugin.tr("Listener timeout"));
        }
        if (!this.server.getUser(this.getUser().getName()).isAllowedToDownload()) {
            if (uploadSocket != null && uploadSocket.socket != null) {
                uploadSocket.socket.close();
            }
            throw new IOException(Plugin.tr("Leecher rejected"));
        }
        if (uploadSocket != null) {
            this.socket = uploadSocket.socket;
            try {
                this.socket.setSoTimeout(60000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.offset = uploadSocket.offset;
            try {
                this.out = new ThrottledOutputStream(this.socket.getOutputStream());
                this.establishStream();
            }
            catch (IOException iOException) {
                this.close(false);
                throw iOException;
            }
        }
        try {
            this.socket = NetHelper.connect(this.host, this.port, 60000L);
            try {
                this.socket.setSoTimeout(60000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.out = new ThrottledOutputStream(this.socket.getOutputStream());
            this.establishReverseStream();
        }
        catch (IOException iOException) {
            this.close(false);
            throw iOException;
        }
        MessageHandler.send(new UploadingFileMessage());
    }

    public void close(boolean bl) {
        if (bl) {
            MessageHandler.send(new UploadCompleteMessage());
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        this.close(true);
    }

    public boolean equals(Object object) {
        if (object instanceof Upload) {
            Upload upload = (Upload)object;
            return this.file.equals(upload.getFile()) && this.user.equals(upload.getUser());
        }
        return false;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void reject() {
        MessageHandler.send(this.server, new AcceptFailedMessage(this.getUser().getName(), this.requestFilename));
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.out.write(byArray, 0, n);
    }

    protected void establishStream() throws IOException {
        if (this.file == null) {
            String string = "INVALID REQUEST";
            this.out.write(string.getBytes());
            throw new IOException(Plugin.tr("Invalid request"));
        }
        this.out.write(new Long(this.file.length()).toString().getBytes());
    }

    protected void establishReverseStream() throws IOException {
        char c = (char)this.in.read();
        if (c != '1') {
            throw new IOException(Plugin.tr("Invalid request"));
        }
        String string = "SEND";
        this.out.write(string.getBytes());
        this.out.flush();
        string = this.server.getUsername() + " \"" + this.requestFilename + "\" " + this.file.length();
        Debug.log("nap ul: -> " + string);
        this.out.write(string.getBytes());
        this.out.flush();
        byte[] byArray = new byte[1000];
        int n = this.in.read(byArray);
        if (n <= 0) {
            throw new IOException(Plugin.tr("Socket error"));
        }
        String string2 = new String(byArray, 0, n);
        Debug.log("nap ul: <- " + string2);
        try {
            this.offset = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.log(numberFormatException);
            throw new IOException(Plugin.tr("Invalid request"));
        }
        Debug.log("nap ul: offset <- " + string2);
    }

    public void messageReceived(ServerMessage serverMessage) {
        if (serverMessage instanceof AltDownloadAckMessage) {
            AltDownloadAckMessage altDownloadAckMessage = (AltDownloadAckMessage)serverMessage;
            if (altDownloadAckMessage.nick.equals(this.user.getName()) && altDownloadAckMessage.filename.equals(this.requestFilename)) {
                altDownloadAckMessage.consume();
                this.host = altDownloadAckMessage.ip;
                this.port = altDownloadAckMessage.port;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
        }
    }

    static /* synthetic */ File access$0(Upload upload) {
        return upload.file;
    }

    public Upload(String string, File file, Server server, String string2) {
        super(server.getUser(string));
        this.file = file;
        this.server = server;
        this.requestFilename = string2;
    }
}

