/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.SendMessage;
import xnap.plugin.nap.net.msg.SendWorker;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.util.Connector;

public class MessageSender {
    public static final int SEND_WORKER_COUNT = 3;
    protected static Logger logger = Logger.getLogger(class$Lxnap$plugin$nap$net$msg$MessageSender != null ? class$Lxnap$plugin$nap$net$msg$MessageSender : (class$Lxnap$plugin$nap$net$msg$MessageSender = MessageSender.class$("xnap.plugin.nap.net.msg.MessageSender")));
    protected static MessageSender singleton;
    protected boolean died = true;
    protected LinkedList queue = new LinkedList();
    protected HashSet lockedServers = new HashSet();
    protected LinkedList sendWorkers = new LinkedList();
    private static /* synthetic */ Class class$Lxnap$plugin$nap$net$msg$MessageSender;

    public static synchronized MessageSender getInstance() {
        if (singleton == null) {
            singleton = new MessageSender();
        }
        return singleton;
    }

    public static void ensureLiveness() {
        if (MessageSender.getInstance().lockedServers.size() >= MessageSender.getInstance().sendWorkers.size()) {
            MessageSender.getInstance().startNewSendWorker();
        }
    }

    public static void send(Server server, ClientMessage clientMessage, boolean bl) {
        MessageSender.getInstance().add(server, clientMessage, bl, true);
    }

    public static void send(ClientMessage clientMessage) {
        Object[] objectArray = Connector.getInstance().getConnectedServers().toArray();
        int n = 0;
        while (n < objectArray.length) {
            MessageSender.getInstance().add((Server)objectArray[n], clientMessage, true, true);
            ++n;
        }
    }

    public static void sendLater(Server server, ClientMessage clientMessage) {
        MessageSender.getInstance().add(server, clientMessage, true, false);
    }

    public static void sendPending(Server server) {
        MessageSender.getInstance().notifyServer(server);
    }

    public synchronized void add(Server server, ClientMessage clientMessage, boolean bl, boolean bl2) {
        if (bl) {
            this.queue.addLast(new SendMessage(server, clientMessage));
        } else {
            this.queue.addFirst(new SendMessage(server, clientMessage));
        }
        if (bl2) {
            this.notifyServer(server);
        }
    }

    public synchronized void failed(Server server) {
        logger.debug("removing all messages for: " + server);
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            SendMessage sendMessage = (SendMessage)iterator.next();
            if (sendMessage.server != server) continue;
            iterator.remove();
            if (sendMessage.msg.listener == null) continue;
            sendMessage.msg.listener.exceptionThrown(new IOException(Plugin.tr("Server disconnected")));
        }
    }

    public Stats getStats() {
        return new Stats();
    }

    public boolean hasDied() {
        return this.died;
    }

    public synchronized SendMessage next() {
        logger.debug("fetching next: send queue size: " + this.queue.size() + ", " + this.lockedServers.size() + " locked servers");
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            SendMessage sendMessage = (SendMessage)iterator.next();
            if (this.lockedServers.contains(sendMessage.server)) continue;
            iterator.remove();
            this.lockedServers.add(sendMessage.server);
            MessageSender.ensureLiveness();
            return sendMessage;
        }
        return null;
    }

    public synchronized void notifyServer(Server server) {
        if (!this.lockedServers.contains(server)) {
            this.notify();
        }
    }

    public synchronized void sent(SendMessage sendMessage) {
        this.lockedServers.remove(sendMessage.server);
    }

    public void start() {
        this.died = false;
        int n = 0;
        while (n < 3) {
            this.startNewSendWorker();
            ++n;
        }
    }

    public void startNewSendWorker() {
        String string = "SendWorker " + (this.sendWorkers.size() + 1);
        SendWorker sendWorker = new SendWorker(string, this);
        this.sendWorkers.add(sendWorker);
        logger.info(this.sendWorkers.size() + " SendWorkers running");
    }

    public synchronized void stop() {
        this.died = true;
        this.notifyAll();
        singleton = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected MessageSender() {
    }

    public class Stats {
        public int sendQueueSize;
        public int busySendWorkerCount;
        public int sendWorkerCount;

        public Stats() {
            this.sendQueueSize = MessageSender.this.queue.size();
            this.busySendWorkerCount = MessageSender.this.lockedServers.size();
            this.sendWorkerCount = MessageSender.this.sendWorkers.size();
        }
    }
}

