/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import xnap.plugin.nap.net.Server;
import xnap.util.QuotedStringTokenizer;

public class ServerFile {
    private BufferedReader in = null;
    private BufferedWriter out = null;
    private String filename;

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public BufferedWriter getOut() {
        return this.out;
    }

    public void openReader() throws IOException {
        this.in = new BufferedReader(new FileReader(this.getFilename()));
    }

    public void openWriter() throws IOException {
        this.out = new BufferedWriter(new FileWriter(this.getFilename(), false));
    }

    public Server readServer() throws IOException {
        String string;
        while ((string = this.getIn().readLine()) != null) {
            try {
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string, " :");
                if (quotedStringTokenizer.countTokens() < 2) continue;
                String string2 = quotedStringTokenizer.nextToken();
                int n = Integer.parseInt(quotedStringTokenizer.nextToken());
                String string3 = "";
                if (quotedStringTokenizer.countTokens() > 0) {
                    string3 = quotedStringTokenizer.nextToken();
                }
                Server server = new Server(string2, n, string3);
                if (quotedStringTokenizer.countTokens() >= 3) {
                    server.setUsername(quotedStringTokenizer.nextToken());
                }
                if (quotedStringTokenizer.countTokens() > 0) {
                    server.setPassword(quotedStringTokenizer.nextToken());
                }
                if (quotedStringTokenizer.countTokens() > 0) {
                    server.setEmail(quotedStringTokenizer.nextToken());
                }
                return server;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void writeServer(Server server) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(server.getHost());
        stringBuffer.append(":");
        stringBuffer.append(server.getPort());
        stringBuffer.append(" ");
        stringBuffer.append(server.getNetwork().length() > 0 ? server.getNetwork() : "\"\"");
        if (server.isLoginCustomized()) {
            stringBuffer.append(" ");
            stringBuffer.append(server.getUsername());
            stringBuffer.append(" ");
            stringBuffer.append(server.getPassword());
            stringBuffer.append(" ");
            stringBuffer.append(server.getEmail());
        }
        this.out.write(stringBuffer.toString());
        this.out.newLine();
    }

    public ServerFile(String string) {
        this.filename = string;
    }
}

