/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import xnap.util.SearchFilter;
import xnap.util.SearchFilterData;

public class SearchFilterHelper {
    public static int getIndexFromBitrate(int n) {
        int n2 = 0;
        while (n2 < SearchFilter.BITRATES.length) {
            if (n == SearchFilter.getBitrateFromIndex(n2)) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public static int getMediatypeFromExtension(String string) {
        int n = 0;
        while (n < SearchFilter.mediaTypes.length) {
            if (SearchFilterHelper.occursIn(SearchFilter.mediaTypes[n], string)) {
                return n + 1;
            }
            ++n;
        }
        return 0;
    }

    public static boolean occursIn(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String toString(SearchFilter searchFilter) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("search for " + searchFilter.getSearchText());
        if (searchFilter.getBitrateCompare() != 0) {
            stringBuffer.append(", bitrate " + SearchFilter.COMPARES[searchFilter.getBitrateCompare()] + " " + searchFilter.getBitrate());
        }
        if (searchFilter.getFilesizeCompare() != 0) {
            stringBuffer.append(", filesize " + SearchFilter.COMPARES[searchFilter.getFilesizeCompare()] + " " + searchFilter.getFilesize());
        }
        if (searchFilter.getMediaType() != 0) {
            stringBuffer.append(", media type " + SearchFilter.media[searchFilter.getMediaType()]);
        }
        return stringBuffer.toString();
    }

    public static SearchFilter.Data convert(SearchFilterData searchFilterData) {
        SearchFilter searchFilter = new SearchFilter(searchFilterData.searchText, searchFilterData.bitrateCompare, searchFilterData.bitrate, searchFilterData.filesizeCompare, searchFilterData.filesize, searchFilterData.mediaType);
        return searchFilter.getData();
    }

    public static SearchFilterData convert(SearchFilter.Data data) {
        SearchFilter searchFilter = new SearchFilter(data);
        return new SearchFilterData(searchFilter.getSearchText(), searchFilter.getBitrateCompare(), searchFilter.getBitrate(), searchFilter.getFilesizeCompare(), searchFilter.getFilesize(), searchFilter.getMediaType());
    }
}

