/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JRadioButton;

public class AirportInfoRadioButton
extends JRadioButton
implements AirportInfoComponent {
    private Vector theRecords = new Vector();

    public AirportInfoRadioButton(String string) {
        super(string);
    }

    public AirportInfoRadioButton(String string, AirportInfoRecord airportInfoRecord, String string2) {
        super(string);
        this.addInfoRecord(airportInfoRecord, string2);
    }

    public void addInfoRecord(AirportInfoRecord airportInfoRecord, String string) {
        RecordSettings recordSettings = new RecordSettings();
        recordSettings.theRecord = airportInfoRecord;
        recordSettings.selectedValue = string;
        this.theRecords.insertElementAt(recordSettings, this.theRecords.size());
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        boolean bl = true;
        Enumeration enumeration = this.theRecords.elements();
        while (enumeration.hasMoreElements()) {
            RecordSettings recordSettings = (RecordSettings)enumeration.nextElement();
            String string = recordSettings.theRecord.toString();
            String string2 = recordSettings.selectedValue;
            try {
                if (Integer.parseInt(string, 16) == Integer.parseInt(string2, 16)) continue;
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        this.setSelected(bl);
    }

    public void writeValue() throws ValueFormatException {
        boolean bl = this.isSelected();
        if (bl) {
            Enumeration enumeration = this.theRecords.elements();
            while (enumeration.hasMoreElements()) {
                RecordSettings recordSettings = (RecordSettings)enumeration.nextElement();
                recordSettings.writeValue();
            }
        }
    }

    private class RecordSettings {
        public AirportInfoRecord theRecord;
        public String selectedValue;

        public void writeValue() throws ValueFormatException {
            this.theRecord.setBytesFromString(this.selectedValue);
        }

        RecordSettings() {
        }
    }
}

