/*
 * Decompiled with CFR 0.152.
 */
import airport.AirportDiscoverer;
import airport.AirportInfo;
import airport.AirportInfoRecord;
import airport.AirportInfoTabbedPane;
import airport.ValueFormatException;
import byteblock.ByteBlock;
import byteblock.ByteBlockMultiWindow;
import byteblock.ByteBlockRectangularWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPInteger;
import snmp.SNMPOctetString;
import snmp.SNMPSequence;
import snmp.SNMPSetException;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class AirportBaseStationConfigurator
extends JFrame
implements ActionListener {
    public static final String encryptionKeySizeString = "05";
    public static final int encryptionKeySize = 5;
    public static final String aboutString = "Airport Base Station Configurator ";
    JButton discoverDevicesButton;
    JButton retrieveItemButton;
    JButton updateBaseStationButton;
    JTextField hostIDField;
    JTextField communityField;
    GridBagLayout mainLayout = new GridBagLayout();
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem quitItem;
    MenuItem openItem;
    MenuItem saveItem;
    MenuItem aboutItem;
    MenuItem uploadFirmwareItem;
    private final int baseBlockSize = 17408;
    private ByteBlock baseBlock = new ByteBlock(1088, 16);
    private final int configurationSize = 17336;
    AirportInfo airportInfo = new AirportInfo(this.baseBlock);
    AirportInfoTabbedPane infoPane;
    JTextArea messagesArea;
    SNMPv1CommunicationInterface comInterface;
    SNMPVarBindList retrievedVars;

    public AirportBaseStationConfigurator() {
        this.setUpDisplay();
        this.retrievedVars = new SNMPVarBindList();
    }

    private void setUpDisplay() {
        Insets insets;
        Object object;
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.setTitle("AirPort Base Station Configurator");
        this.getRootPane().setBorder(new BevelBorder(0));
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.openItem = new MenuItem("Open saved settings...");
        this.openItem.setShortcut(new MenuShortcut(111));
        this.openItem.setActionCommand("open settings");
        this.openItem.addActionListener(this);
        this.fileMenu.add(this.openItem);
        this.saveItem = new MenuItem("Save settings...");
        this.saveItem.setShortcut(new MenuShortcut(115));
        this.saveItem.setActionCommand("save settings");
        this.saveItem.addActionListener(this);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.addSeparator();
        this.uploadFirmwareItem = new MenuItem("Upload new base station firmware...");
        this.uploadFirmwareItem.setActionCommand("upload firmware");
        this.uploadFirmwareItem.addActionListener(this);
        this.fileMenu.add(this.uploadFirmwareItem);
        this.fileMenu.addSeparator();
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setShortcut(new MenuShortcut(113));
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        object = new JLabel("Device address:");
        this.hostIDField = new JTextField(10);
        this.hostIDField.setText("10.0.1.1");
        JLabel jLabel = new JLabel("Community name (password):");
        this.communityField = new JPasswordField(10);
        this.discoverDevicesButton = new JButton("Discover Devices");
        this.discoverDevicesButton.setActionCommand("discover devices");
        this.discoverDevicesButton.addActionListener(this);
        this.retrieveItemButton = new JButton("Retrieve Settings");
        this.retrieveItemButton.setActionCommand("retrieve data");
        this.retrieveItemButton.addActionListener(this);
        this.updateBaseStationButton = new JButton("Update Base Station");
        this.updateBaseStationButton.setActionCommand("update base station");
        this.updateBaseStationButton.addActionListener(this);
        this.updateBaseStationButton.setEnabled(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.discoverDevicesButton, gridBagConstraints);
        jPanel.add(this.discoverDevicesButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.retrieveItemButton, gridBagConstraints);
        jPanel.add(this.retrieveItemButton);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.updateBaseStationButton, gridBagConstraints);
        jPanel.add(this.updateBaseStationButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        jPanel2.add((Component)object);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hostIDField, gridBagConstraints);
        jPanel2.add(this.hostIDField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.communityField, gridBagConstraints);
        jPanel2.add(this.communityField);
        this.infoPane = new AirportInfoTabbedPane(this.airportInfo);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        this.messagesArea = new JTextArea(4, 60);
        JScrollPane jScrollPane = new JScrollPane(this.messagesArea);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        JLabel jLabel2 = new JLabel("Messages:");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel3.add(jScrollPane);
        this.getContentPane().setLayout(this.mainLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.mainLayout.setConstraints(jPanel2, gridBagConstraints);
        this.getContentPane().add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.mainLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.mainLayout.setConstraints(this.infoPane, gridBagConstraints);
        this.getContentPane().add(this.infoPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.mainLayout.setConstraints(jPanel3, gridBagConstraints);
        this.getContentPane().add(jPanel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        JLabel jLabel3 = new JLabel(" Version 1.5.2        J. Sevy, November 2001 ");
        jLabel3.setFont(new Font("SansSerif", 2, 8));
        this.mainLayout.setConstraints(jLabel3, gridBagConstraints);
        this.getContentPane().add(jLabel3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block39: {
            int n;
            Object[] objectArray;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            Object object5;
            String string = actionEvent.getActionCommand();
            if (string.equals("quit")) {
                System.exit(0);
            }
            if (string == "about") {
                object5 = new AboutDialog(this);
            }
            if (string.equals("discover devices")) {
                object5 = new AirportDiscoverer();
            }
            if (string.equals("retrieve data")) {
                try {
                    if (this.comInterface != null) {
                        this.comInterface.closeConnection();
                    }
                    object5 = this.communityField.getText();
                    serializable = InetAddress.getByName(this.hostIDField.getText());
                    int n2 = 0;
                    this.messagesArea.append("Retrieving settings from base station " + serializable + "......\n");
                    this.comInterface = new SNMPv1CommunicationInterface(n2, (InetAddress)serializable, (String)object5);
                    int n3 = 1;
                    while (n3 <= 68) {
                        object4 = "1.3.6.1.4.1.762.2.2.1.1." + n3;
                        object3 = this.comInterface.getMIBEntry((String)object4);
                        object2 = (SNMPSequence)((SNMPSequence)object3).getSNMPObjectAt(0);
                        object = (SNMPOctetString)((SNMPSequence)object2).getSNMPObjectAt(1);
                        objectArray = (byte[])((SNMPOctetString)object).getValue();
                        n = (n3 - 1) * 256;
                        int n4 = 16;
                        int n5 = 16;
                        ByteBlockRectangularWindow byteBlockRectangularWindow = new ByteBlockRectangularWindow(n, n4, n5, this.baseBlock);
                        byteBlockRectangularWindow.writeBytes((byte[])objectArray);
                        ++n3;
                    }
                    this.messagesArea.append("Settings retrieved.\n");
                    this.refreshInfoPane();
                    this.updateBaseStationButton.setEnabled(true);
                }
                catch (UnknownHostException unknownHostException) {
                    this.messagesArea.append("Error retrieving settings: unknown host.\n");
                }
                catch (SocketException socketException) {
                    this.messagesArea.append("Error retrieving settings: " + socketException + "\n");
                }
                catch (IOException iOException) {
                    this.messagesArea.append("Error retrieving settings: timed out waiting for response.\n");
                }
                catch (SNMPBadValueException sNMPBadValueException) {
                    this.messagesArea.append("Error retrieving settings: bad SNMP value received.\n");
                }
                catch (SNMPGetException sNMPGetException) {
                    this.messagesArea.append("Error retrieving settings: incorrect community name (password).\n");
                }
                catch (Exception exception) {
                    this.messagesArea.append("Error retrieving settings: " + exception.getMessage() + "\n");
                }
            }
            if (string.equals("save settings")) {
                try {
                    this.infoPane.writeData();
                    this.setDependentData();
                    this.setStaticData();
                    this.setChecksum(this.baseBlock, 17334);
                    object5 = new FileDialog((Frame)this, "Save current settings as...", 1);
                    ((Dialog)object5).show();
                    if (((FileDialog)object5).getFile() != null) {
                        serializable = new File(((FileDialog)object5).getDirectory(), ((FileDialog)object5).getFile());
                        FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
                        fileOutputStream.write(this.baseBlock.bytes, 0, 17336);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                }
                catch (ValueFormatException valueFormatException) {
                    this.messagesArea.append("Problem with supplied value: " + valueFormatException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    this.messagesArea.append("Error saving settings: " + exception.getMessage() + "\n");
                }
            }
            if (string.equals("update base station")) {
                try {
                    this.infoPane.writeData();
                    this.setDependentData();
                    this.setStaticData();
                    this.setChecksum(this.baseBlock, 17334);
                    this.transmitBlocks(this.baseBlock, 17336);
                }
                catch (ValueFormatException valueFormatException) {
                    this.messagesArea.append("Problem with supplied value: " + valueFormatException.getMessage() + "\n");
                }
            }
            if (string.equals("open settings")) {
                try {
                    object5 = new FileDialog((Frame)this, "Open settings file...", 0);
                    ((Dialog)object5).show();
                    if (((FileDialog)object5).getFile() != null) {
                        boolean bl;
                        serializable = new File(((FileDialog)object5).getDirectory(), ((FileDialog)object5).getFile());
                        FileInputStream fileInputStream = new FileInputStream((File)serializable);
                        byte[] byArray = new byte[17408];
                        fileInputStream.read(byArray);
                        fileInputStream.close();
                        object4 = this.baseBlock.bytes;
                        this.baseBlock.bytes = byArray;
                        boolean bl2 = bl = (actionEvent.getModifiers() & 1) > 0;
                        if (((File)serializable).length() < 17336L || !bl && !this.checksumValid()) {
                            this.baseBlock.bytes = (byte[])object4;
                            throw new Exception("invalid settings file.");
                        }
                        this.refreshInfoPane();
                        this.updateBaseStationButton.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    this.messagesArea.append("Error opening settings: " + exception.getMessage() + "\n");
                }
            }
            if (!string.equals("upload firmware")) break block39;
            try {
                object5 = new FileDialog((Frame)this, "Select firmware file...", 0);
                ((Dialog)object5).show();
                if (((FileDialog)object5).getFile() == null) break block39;
                serializable = new File(((FileDialog)object5).getDirectory(), ((FileDialog)object5).getFile());
                FileInputStream fileInputStream = new FileInputStream((File)serializable);
                int n6 = (int)((File)serializable).length();
                int n7 = (int)Math.ceil((double)n6 / 256.0);
                object3 = new ByteBlock(n7 * 16, 16);
                fileInputStream.read(((ByteBlock)object3).bytes);
                fileInputStream.close();
                if (n6 < 17336) {
                    throw new Exception("invalid firmware file.");
                }
                if (!this.appleFirmwareChecksumValid((ByteBlock)object3) && !this.checksumValid((ByteBlock)object3)) {
                    throw new Exception("invalid firmware file.");
                }
                object2 = "Upload firmware to base station " + this.hostIDField.getText() + "?";
                object = new String("Cancel");
                if (this.updateBaseStationButton.isEnabled()) {
                    objectArray = new String[]{"Upload firmware with current settings", "Upload firmware with default settings", "Cancel"};
                    n = JOptionPane.showOptionDialog(null, object2, "Firmware Upload", 0, 1, null, objectArray, objectArray[0]);
                    if (n != -1) {
                        object = objectArray[n];
                    }
                } else {
                    objectArray = new String[]{"Upload firmware with default settings", "Cancel"};
                    n = JOptionPane.showOptionDialog(null, object2, "Firmware Upload", 0, 1, null, objectArray, objectArray[0]);
                    if (n != -1) {
                        object = objectArray[n];
                    }
                }
                if (((String)object).equals("Upload firmware with current settings")) {
                    this.infoPane.writeData();
                    this.setDependentData();
                    this.setStaticData();
                    this.setCommunityNames();
                    this.setChecksum(this.baseBlock, 17334);
                    int n8 = 0;
                    while (n8 < 17336) {
                        ((ByteBlock)object3).bytes[n8] = this.baseBlock.bytes[n8];
                        ++n8;
                    }
                    this.transmitBlocks((ByteBlock)object3, n6);
                } else if (((String)object).equals("Upload firmware with default settings")) {
                    this.transmitBlocks((ByteBlock)object3, n6);
                }
            }
            catch (ValueFormatException valueFormatException) {
                this.messagesArea.append("Problem with supplied value: " + valueFormatException.getMessage() + "\n");
            }
            catch (Exception exception) {
                this.messagesArea.append("Error updating firmware: " + exception.getMessage() + "\n");
            }
        }
    }

    private void refreshInfoPane() {
        Insets insets;
        this.remove(this.infoPane);
        this.infoPane = new AirportInfoTabbedPane(this.airportInfo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.mainLayout.setConstraints(this.infoPane, gridBagConstraints);
        this.getContentPane().add(this.infoPane);
        this.validate();
    }

    private void setDependentData() throws ValueFormatException {
        AirportInfoRecord airportInfoRecord;
        String string;
        AirportInfoRecord airportInfoRecord2;
        String string2;
        AirportInfoRecord airportInfoRecord3;
        String string3;
        AirportInfoRecord airportInfoRecord4;
        String string4;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        AirportInfoRecord airportInfoRecord5 = this.airportInfo.get("Ethernet/Modem switch 1");
        String string5 = airportInfoRecord5.toString();
        AirportInfoRecord airportInfoRecord6 = this.airportInfo.get("Configuration interface");
        String string6 = airportInfoRecord6.toString();
        if (string5.equals("60") || string6.equals("00")) {
            bl = true;
        }
        if (string5.equals("62") || string6.equals("03")) {
            bl2 = true;
        }
        if ((string4 = (airportInfoRecord4 = this.airportInfo.get("Base station configuration mode switch")).toString()).equals("00")) {
            bl4 = true;
        }
        if (string4.equals("20")) {
            bl3 = true;
        }
        if ((string3 = (airportInfoRecord3 = this.airportInfo.get("DHCP switch")).toString()).equals("80")) {
            bl6 = true;
        }
        if ((string2 = (airportInfoRecord2 = this.airportInfo.get("NAT switch")).toString()).equals("02")) {
            bl5 = true;
        }
        if ((string = (airportInfoRecord = this.airportInfo.get("Port mapping switch")).toString()).equals("04")) {
            bl7 = true;
        }
        AirportInfoRecord airportInfoRecord7 = this.airportInfo.get("NAT inbound private IP address");
        AirportInfoRecord airportInfoRecord8 = this.airportInfo.get("NAT inbound private subnet mask");
        AirportInfoRecord airportInfoRecord9 = this.airportInfo.get("NAT outbound private IP address");
        AirportInfoRecord airportInfoRecord10 = this.airportInfo.get("NAT outbound private subnet mask");
        AirportInfoRecord airportInfoRecord11 = this.airportInfo.get("NAT outbound public IP address");
        AirportInfoRecord airportInfoRecord12 = this.airportInfo.get("NAT outbound public subnet mask");
        AirportInfoRecord airportInfoRecord13 = this.airportInfo.get("DHCP server router address");
        AirportInfoRecord airportInfoRecord14 = this.airportInfo.get("DHCP server subnet mask");
        AirportInfoRecord airportInfoRecord15 = this.airportInfo.get("Base station IP address");
        AirportInfoRecord airportInfoRecord16 = this.airportInfo.get("Subnet mask");
        AirportInfoRecord airportInfoRecord17 = this.airportInfo.get("Router IP address");
        if (bl5) {
            if (bl2) {
                airportInfoRecord11.setBytesFromString("0.0.0.0");
                airportInfoRecord12.setBytesFromString("255.255.255.0");
            }
            if (bl) {
                if (bl4) {
                    airportInfoRecord11.setBytesFromString(airportInfoRecord15.toString());
                    airportInfoRecord12.setBytesFromString(airportInfoRecord16.toString());
                } else if (bl3) {
                    airportInfoRecord11.setBytesFromString("0.0.0.0");
                    airportInfoRecord12.setBytesFromString("255.255.255.0");
                }
            }
        }
        if (bl6) {
            if (bl5) {
                airportInfoRecord13.setBytesFromString(airportInfoRecord7.toString());
                airportInfoRecord14.setBytesFromString(airportInfoRecord8.toString());
            } else {
                airportInfoRecord13.setBytesFromString(airportInfoRecord17.toString());
                airportInfoRecord14.setBytesFromString(airportInfoRecord16.toString());
            }
        }
        if (bl7 && bl && bl4) {
            AirportInfoRecord airportInfoRecord18 = this.airportInfo.get("Count of port mappings");
            int n = Integer.parseInt(airportInfoRecord18.toString());
            int n2 = 3442;
            int n3 = 1;
            int n4 = 2;
            int n5 = 3482;
            int n6 = 1;
            int n7 = 2;
            int n8 = 1;
            int n9 = 0;
            while (n9 < n) {
                ByteBlockMultiWindow byteBlockMultiWindow = new ByteBlockMultiWindow();
                ByteBlockRectangularWindow byteBlockRectangularWindow = new ByteBlockRectangularWindow(n2, n3, n4, this.baseBlock);
                byteBlockMultiWindow.addWindow(byteBlockRectangularWindow);
                ByteBlockRectangularWindow byteBlockRectangularWindow2 = new ByteBlockRectangularWindow(n5, n6, n7, this.baseBlock);
                byteBlockMultiWindow.addWindow(byteBlockRectangularWindow2);
                AirportInfoRecord airportInfoRecord19 = new AirportInfoRecord(n8, byteBlockMultiWindow);
                airportInfoRecord19.setBytesFromString(airportInfoRecord15.toString());
                n2 += 2;
                n5 += 2;
                ++n9;
            }
        }
    }

    private void setStaticData() throws ValueFormatException {
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Read community");
        airportInfoRecord.setBytesFromString("public");
    }

    private void setCommunityNames() throws ValueFormatException {
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Read/write community");
        String string = airportInfoRecord.toString();
        if (string.equals("")) {
            string = this.communityField.getText();
        }
        airportInfoRecord.setBytesFromString(string);
        AirportInfoRecord airportInfoRecord2 = this.airportInfo.get("Trap community");
        airportInfoRecord2.setBytesFromString("public");
        AirportInfoRecord airportInfoRecord3 = this.airportInfo.get("Remaining community count");
        airportInfoRecord3.setBytesFromString("06");
        AirportInfoRecord airportInfoRecord4 = this.airportInfo.get("Remaining community");
        airportInfoRecord4.setBytesFromString("public");
    }

    private void transmitBlocks(ByteBlock byteBlock, int n) {
        try {
            Object object;
            int n2;
            byte[] byArray;
            String string;
            String string2 = this.communityField.getText();
            InetAddress inetAddress = InetAddress.getByName(this.hostIDField.getText());
            this.messagesArea.append("Sending data to base station " + inetAddress + "......\n");
            if (this.comInterface == null) {
                int n3 = 0;
                this.comInterface = new SNMPv1CommunicationInterface(n3, inetAddress, string2);
            }
            this.comInterface.requestID = 1;
            byte[] byArray2 = byteBlock.bytes;
            int n4 = (int)Math.ceil((double)(n + 2) / 256.0);
            int n5 = 1;
            while (n5 < n4) {
                string = "1.3.6.1.4.1.762.2.3.1.1." + n5;
                byArray = new byte[256];
                n2 = 0;
                while (n2 < 256) {
                    byArray[n2] = byArray2[256 * (n5 - 1) + n2];
                    ++n2;
                }
                SNMPOctetString sNMPOctetString = new SNMPOctetString(byArray);
                object = this.comInterface.setMIBEntry(string, sNMPOctetString);
                ++n5;
            }
            string = "1.3.6.1.4.1.762.2.3.1.1." + n4;
            byArray = new byte[256];
            n2 = n - (n4 - 1) * 256;
            int n6 = 0;
            while (n6 < n2) {
                byArray[n6] = byArray2[256 * (n4 - 1) + n6];
                ++n6;
            }
            object = new ByteBlock(16, 16, byArray);
            short s = this.computeChecksum(byteBlock.bytes, n);
            this.setChecksum(s, (ByteBlock)object, n2);
            SNMPOctetString sNMPOctetString = new SNMPOctetString(((ByteBlock)object).bytes);
            SNMPVarBindList sNMPVarBindList = this.comInterface.setMIBEntry(string, sNMPOctetString);
            SNMPInteger sNMPInteger = new SNMPInteger(n);
            string = "1.3.6.1.4.1.762.2.1.2.0";
            sNMPVarBindList = this.comInterface.setMIBEntry(string, sNMPInteger);
            string = "1.3.6.1.4.1.762.2.1.3.0";
            sNMPVarBindList = this.comInterface.setMIBEntry(string, sNMPInteger);
            this.messagesArea.append("Data transmitted; base station restarting.\n");
        }
        catch (UnknownHostException unknownHostException) {
            this.messagesArea.append("Error transmitting data: unknown host.\n");
        }
        catch (SocketException socketException) {
            this.messagesArea.append("Error transmitting data: " + socketException.getMessage() + "\n");
        }
        catch (IOException iOException) {
            this.messagesArea.append("Error transmitting data: timed out waiting for response.\n");
        }
        catch (SNMPSetException sNMPSetException) {
            this.messagesArea.append("Error transmitting data: " + sNMPSetException.getMessage() + "\n");
        }
        catch (SNMPBadValueException sNMPBadValueException) {
            this.messagesArea.append("Error transmitting data: bad SNMP value.\n");
        }
    }

    private short computeChecksum(byte[] byArray, int n) {
        short s = 0;
        int n2 = 0;
        while (n2 < n) {
            s = (short)(s + byArray[n2]);
            if (byArray[n2] < 0) {
                s = (short)(s + 256);
            }
            ++n2;
        }
        return s;
    }

    private void setChecksum(short s, ByteBlock byteBlock, int n) {
        String string = this.littleEndianHexString(s);
        int n2 = 1;
        int n3 = 2;
        int n4 = n;
        ByteBlockRectangularWindow byteBlockRectangularWindow = new ByteBlockRectangularWindow(n4, n2, n3, byteBlock);
        int n5 = 2;
        AirportInfoRecord airportInfoRecord = new AirportInfoRecord(n5, byteBlockRectangularWindow);
        airportInfoRecord.byteBlockWindow.clearBytes();
        try {
            airportInfoRecord.setBytesFromString(string);
        }
        catch (ValueFormatException valueFormatException) {
            this.messagesArea.append("Problem writing checksum with value " + string + ".\n");
        }
    }

    private void setChecksum(ByteBlock byteBlock, int n) {
        short s = this.computeChecksum(byteBlock.bytes, n);
        this.setChecksum(s, byteBlock, n);
    }

    private String littleEndianHexString(short n) {
        int n2 = n;
        int n3 = ((n2 &= 0xFFFF) << 8 | n2 >>> 8) & 0xFFFF;
        String string = Integer.toHexString(n3);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return string;
    }

    private boolean checksumValid(ByteBlock byteBlock) {
        int n;
        int n2;
        int n3;
        int n4;
        AirportInfoRecord airportInfoRecord;
        String string;
        short s = this.computeChecksum(byteBlock.bytes, 17334);
        String string2 = this.littleEndianHexString(s);
        return string2.equals(string = (airportInfoRecord = new AirportInfoRecord(n4 = 17334, n3 = 1, n2 = 2, n = 2, byteBlock)).toString());
    }

    private boolean checksumValid() {
        return this.checksumValid(this.baseBlock);
    }

    private boolean appleFirmwareChecksumValid(ByteBlock byteBlock) {
        int n;
        int n2;
        int n3;
        int n4;
        AirportInfoRecord airportInfoRecord;
        String string;
        short s = this.computeChecksum(byteBlock.bytes, 17334);
        String string2 = this.littleEndianHexString(s = (short)(s - 2562));
        return string2.equals(string = (airportInfoRecord = new AirportInfoRecord(n4 = 17334, n3 = 1, n2 = 2, n = 2, byteBlock)).toString());
    }

    public static void main(String[] stringArray) {
        try {
            AirportBaseStationConfigurator airportBaseStationConfigurator = new AirportBaseStationConfigurator();
            airportBaseStationConfigurator.pack();
            Dimension dimension = airportBaseStationConfigurator.getSize();
            dimension.height += 20;
            dimension.width += 20;
            ((Component)airportBaseStationConfigurator).setSize(dimension);
            airportBaseStationConfigurator.show();
        }
        catch (Exception exception) {}
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        WindowCloseAdapter() {
        }
    }
}

