/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportDiscoveryInfo;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AirportDiscoverer
extends JFrame
implements ActionListener,
Runnable {
    JButton stopDiscoveryButton;
    JButton closeButton;
    JTextArea theArea;
    Thread discoveryThread;

    public AirportDiscoverer() {
        this.setUpDisplay();
        this.pack();
        this.show();
        this.discoveryThread = new Thread(this);
        this.discoveryThread.start();
    }

    private void setUpDisplay() {
        Insets theMargin;
        this.setTitle("Base Station Discovery");
        this.stopDiscoveryButton = new JButton("Stop Discovery");
        this.stopDiscoveryButton.setActionCommand("stop discovery");
        this.stopDiscoveryButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        this.theArea = new JTextArea(20, 70);
        this.theArea.setLineWrap(true);
        this.theArea.setFont(new Font("Monospaced", 0, 10));
        JScrollPane messagesScroll = new JScrollPane(this.theArea);
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(theLayout);
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.stopDiscoveryButton, c);
        buttonPanel.add(this.stopDiscoveryButton);
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.closeButton, c);
        buttonPanel.add(this.closeButton);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("North", buttonPanel);
        this.getContentPane().add("Center", messagesScroll);
    }

    public void actionPerformed(ActionEvent theEvent) {
        String command = theEvent.getActionCommand();
        try {
            if (command == "close") {
                this.discoveryThread.interrupt();
                this.hide();
                this.dispose();
            }
            if (command == "stop discovery") {
                this.discoveryThread.interrupt();
            }
        }
        catch (Exception exception) {}
    }

    public void run() {
        try {
            DatagramSocket dSocket = new DatagramSocket();
            dSocket.setSoTimeout(1000);
            int AIRPORT_PORT = 192;
            InetAddress broadcastAddress = InetAddress.getByName("255.255.255.255");
            byte[] bytes = new byte[116];
            bytes[0] = 1;
            DatagramPacket outPacket = new DatagramPacket(bytes, bytes.length, broadcastAddress, AIRPORT_PORT);
            dSocket.send(outPacket);
            while (!Thread.interrupted()) {
                DatagramPacket inPacket = new DatagramPacket(bytes, bytes.length);
                try {
                    dSocket.receive(inPacket);
                    bytes = inPacket.getData();
                    String sourceAddress = inPacket.getAddress().getHostAddress();
                    AirportDiscoveryInfo theInfo = new AirportDiscoveryInfo(bytes);
                    long upTime = Long.parseLong(theInfo.get("Base station uptime").toString());
                    long days = (upTime /= 100L) / 86400L;
                    long hours = upTime / 3600L % 24L;
                    long minutes = upTime / 60L % 60L;
                    long seconds = upTime % 60L;
                    String dayString = new String();
                    dayString = String.valueOf(dayString) + days;
                    String hourString = new String();
                    hourString = String.valueOf(hourString) + hours;
                    if (hourString.length() < 2) {
                        hourString = "0" + hourString;
                    }
                    String minuteString = new String();
                    if ((minuteString = String.valueOf(minuteString) + minutes).length() < 2) {
                        minuteString = "0" + minuteString;
                    }
                    String secondString = new String();
                    if ((secondString = String.valueOf(secondString) + seconds).length() < 2) {
                        secondString = "0" + secondString;
                    }
                    String timeString = String.valueOf(dayString) + ":" + hourString + ":" + minuteString;
                    this.theArea.append("Access point found:\n");
                    this.theArea.append("  Local LAN IP address:     " + theInfo.get("Base station IP address").toString() + "\n");
                    this.theArea.append("  External IP address:      " + sourceAddress + "\n");
                    this.theArea.append("  MAC address:              " + theInfo.get("Base station Mac address").toString() + "\n");
                    this.theArea.append("  Device name:              " + theInfo.get("System name").toString() + "\n");
                    this.theArea.append("  Device type:              " + theInfo.get("Device identifying string").toString() + "\n");
                    this.theArea.append("  Uptime (days:hrs:mins):   " + timeString + "\n");
                    this.theArea.append("\n");
                }
                catch (InterruptedIOException interruptedIOException) {}
            }
        }
        catch (Exception e) {
            this.theArea.append("Exception during discovery: " + e + "\n");
        }
        this.theArea.append("Discovery finished.\n");
    }

    private String hexByte(byte b) {
        int pos = b;
        if (pos < 0) {
            pos += 256;
        }
        String returnString = new String();
        returnString = String.valueOf(returnString) + Integer.toHexString(pos / 16);
        returnString = String.valueOf(returnString) + Integer.toHexString(pos % 16);
        return returnString;
    }
}

