// This may look like C code, but it is really -*- C++ -*-
/*
 ************************************************************************
 *
 *		Histogram of an integer-valued distribution
 *
 * $Id: histogram.h,v 1.2 1998/03/15 22:57:51 oleg Exp oleg $
 *
 ************************************************************************
 */

#ifndef __GNUC__
#pragma once
#endif

#ifndef _histogram_h
#define _histogram_h

#ifdef __GNUC__
#pragma interface
#endif

				// Computes the histogram of a sequence
				// of integers with unit bin size
class Histogram
{
  unsigned int * counts;		// Counts for the symbols

  Histogram(const Histogram&);		// Private and unimplemented: cloning is
  void operator = (const Histogram&);	// not allowed

public:
  typedef short Symbol;

  const Symbol symbol_lwb;		// Region potential input symbols
  const Symbol symbol_upb;		// are expected in
  const int no_potential_symbols;	// Width of the region
  
					// Construct a model for symbols
					// in [lwb,upb]
  Histogram(const Symbol lwb, const Symbol upb);
  ~Histogram(void);

  void put(const Symbol symbol);	// Count a symbol
  void put_coerce(const Symbol symbol);	// Count a symbol coercing it to
  					// the interval [lwb,upb]
  int get(const Symbol symbol) const;	// Get a count for a specific symbol
  int no_distinct_symbols() const;	// Give the no. of distinct symbols

  double estimate_entropy(void) const;	// Estimate zero-order entropy of a
					// source represented by the histogram

					// Print the histogram
  void print(const char * title="") const;
};


#endif
