/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson, Paul Mineiro

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
        pmineiro@ffem.org <Paul Mineiro>
*/


/*
 * GskActorCli:  an actorparser which executes callbacks identified 
 *               via the first whitespace delimited token.
 */

/*
 * GskActorCli
 * 
 * Parsed its input line-by-line, making a callback the
 * first whitespace delimited portion of its input (skipping
 * leading whitespace) and executes the callback registered
 * with gsk_actor_cli_register_command or the callback registered with
 * the name "default".
 * 
 * The initial default handler always returns FALSE.
 * 
 * Note GskActorCli works in TERMINATED mode with chomp = TRUE
 */

#ifndef __GSK_ACTOR_CLI_H
#define __GSK_ACTOR_CLI_H_

typedef struct _GskActorCliClass GskActorCliClass;
typedef struct _GskActorCli GskActorCli;

#include "gskactorparser.h"

/* --- type macros --- */
GtkType gsk_actor_cli_get_type();
#define GSK_TYPE_ACTOR_CLI		(gsk_actor_cli_get_type ())
#define GSK_ACTOR_CLI(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_ACTOR_CLI, GskActorCli))
#define GSK_ACTOR_CLI_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_ACTOR_CLI, GskActorCliClass))
#define GSK_IS_ACTOR_CLI(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_ACTOR_CLI))
#define GSK_IS_ACTOR_CLI_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_ACTOR_CLI))

/* --- structures & typedefs --- */
struct _GskActorCliClass
{
  GskActorParserClass klass;
};

struct _GskActorCli
{
  GskActorParser actor;

  /* private */

  GHashTable* commands; 
};


/*
 * GskActorCliCommand prototype:
 * 
 *          Parameters:
 *              cli         The cli which finished the token.
 *              head        NULL terminated head of the request
 *                              (not including leading or delimiting
 *                               whitespace) or "default" for
 *                               non-matching
 *              rest        NULL terminated rest of the request
 *                              (not including whitespace delimiter)
 */

typedef gboolean (*GskActorCliCommand) (GskActorCli* cli,
                                        gchar* head,
                                        gchar* rest,
                                        gpointer user_data);

/* --- public methods --- */

/*
 * gsk_actor_cli_register_command
 * 
 *      Associate a command with a particular head in a GskActorCli.
 * 
 *      Parameters:
 * 
 *              cli         The cli which is to have the association.
 *              head        NULL terminated head to associate with the
 *                            command. Note that it does not make
 *                            sense to use a head that contains
 *                            whitespace.
 *              command     The command to associate with the head.
 *                            Use NULL to un-associate head.
 *              user_data   Pointer to pass to command on callback.
 *                            This data must not be deallocated while
 *                            the command is subject to invocation.
 */

void gsk_actor_cli_register_command       (GskActorCli        *cli,
                                           const gchar        *head,
                                           GskActorCliCommand  command,
                                           gpointer            user_data);
#endif
