dnl GSK detection macros.  (gsk.m4)
dnl
dnl
dnl This file defines macros that should be used by
dnl packages which depend upon GSK.
dnl
dnl
dnl If you are a developer, it might be helpful
dnl to copy this file to `/usr/share/aclocal/gsk.m4'.
dnl Then it will get automatically "picked up" by `aclocal'.
dnl
dnl More specifically, using these macros and starting from CVS [*],
dnl requires that this file is installed somewhere in 
dnl aclocal's M4 searchpath.  (try running `aclocal --print-ac-dir')
dnl
dnl
dnl Macros:
dnl
dnl    AM_PATH_GSK           Generic (optional) detection of GSK.
dnl    AM_PATH_GSK_FULL      Detection of GSK for an application that
dnl                          completely depends upon it.
dnl
dnl
dnl [*] Or any version control system, the point is that this file
dnl     should not be required from a distribution tarball.
dnl

dnl AM_PATH_GSK([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
AC_DEFUN(AM_PATH_GSK, [
  AC_ARG_ENABLE(
    gsk-debug,
    [  --enable-gsk-debug   Turn on GSK-level debugging.],
    [case "${enableval}" in
      yes)
        GSK_DEBUG_MODE=1
        ;;
      no)
        GSK_DEBUG_MODE=0
        ;;
      *)
        AC_MSG_ERROR(bad value ${enableval} for --enable-gsk-debug)
        ;;
    esac],
    [GSK_DEBUG_MODE=0]
  )

  AC_ARG_ENABLE(
    gsk-checks,
    [  --disable-gsk-checks Turn off all unnecessary assertions and checks.],
    [case "${enableval}" in
      yes)
        GSK_DISABLE_CHECKS=0
        ;;
      no)
        GSK_DISABLE_CHECKS=1
        ;;
      *)
        AC_MSG_ERROR(bad value ${enableval} for --disable-gsk-checks)
        ;;
    esac],
    [GSK_DISABLE_CHECKS=0]
  )

  AC_ARG_ENABLE(
    gsk-compat,
    [  --disable-gsk-compat Turn off GSK compatibility macros.],
    [case "${enableval}" in
      yes)
        GSK_DISABLE_COMPAT=1
        ;;
      no)
        GSK_DISABLE_COMPAT=0
        ;;
      *)
        AC_MSG_ERROR(bad value ${enableval} for --enable-gsk-compat)
        ;;
    esac],
    [GSK_DISABLE_COMPAT=0]
  )

  if test "$GSK_DISABLE_CHECKS" = 1 && test "$GSK_DEBUG_MODE" = 1 ; then
    AC_MSG_ERROR(--enable-gsk-debug and --disable-gsk-checks conflict)
  fi

  GSK_CFLAGS=""
  GSK_LIBS=""

  dnl Find the name of gsk-config (and thus whether GSK is installed)
  if test "$GSK_DISABLE_CHECKS" = "1"; then
    gsk_config_name=gsk-config-ndebug
  elif test "$GSK_DEBUG_MODE" = "0"; then
    gsk_config_name=gsk-config
  else
    gsk_config_name=gsk-config-debug
  fi
  AC_PATH_PROG(GSK_CONFIG, $gsk_config_name, ./$gsk_config_name)
  if test -r "$GSK_CONFIG" ; then
    dnl Find the version number.
    gsk_version=`"$GSK_CONFIG" --version`
    too_old=0
    test "x$1" = x || {
      echo "$gsk_version" | 
	sed -e 's/\./ /g;' | 
	read found_major found_minor found_micro
      test "x$req_major" = x || {
	test $found_major -lt $req_major && too_old=1
      }
      test "x$req_minor" = x || {
	test $found_minor -lt $req_minor && too_old=1
      }
      test "x$req_micro" = x || {
	test $found_micro -lt $req_micro && too_old=1
      }
    }
    if test $too_old = 1; then
      :
      [$3]
    else
      :
      GSK_CFLAGS=`"$GSK_CONFIG" --cflags $4`
      GSK_LIBS=`"$GSK_CONFIG" --libs $4`
      if test "x$GSK_DISABLE_COMPAT" = "x1" ; then
        GSK_CFLAGS="$GSK_CFLAGS -DGSK_DISABLE_COMPAT=1"
      fi
      [$2]
      AC_SUBST(GSK_CFLAGS)
      AC_SUBST(GSK_LIBS)
    fi
  else
    [$3]
  fi
])

dnl AM_PATH_GSK_FULL(MINIMUM-VERSION, MODULES)
dnl
dnl Add the necessary GSK flags so that compilation and linking will
dnl occur automatically.
AC_DEFUN(AM_PATH_GSK_FULL, [
  AM_PATH_GSK([$1],
    [LDFLAGS="$LDFLAGS $GSK_LIBS"
     CFLAGS="$CFLAGS $GSK_CFLAGS"]
     AC_SUBST(LDFLAGS)
     AC_SUBST(CFLAGS),
    [echo "sorry; gsk-config could not be found and $PROJECT needs it." 1>&2
     exit 1],
    [$2]
  )
])
