/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/


/*
 * GskActorDatagramSocket: DATAGRAM_SOCKET sending and receiving actor.
 *              DATAGRAM_SOCKET is an unreliable, packet-based transport.
 */

#ifndef __GSK_ACTOR_DATAGRAM_SOCKET_H_
#define __GSK_ACTOR_DATAGRAM_SOCKET_H_

#include "gskactor.h"
#include "gsksocketaddress.h"
#include "gskdatagramsocket.h"

/* --- type macros --- */
GtkType gsk_actor_datagram_socket_get_type();
#define GSK_TYPE_ACTOR_DATAGRAM_SOCKET		(gsk_actor_datagram_socket_get_type ())
#define GSK_ACTOR_DATAGRAM_SOCKET(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_ACTOR_DATAGRAM_SOCKET, GskActorDatagramSocket))
#define GSK_ACTOR_DATAGRAM_SOCKET_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_ACTOR_DATAGRAM_SOCKET, GskActorDatagramSocketClass))
#define GSK_ACTOR_DATAGRAM_SOCKET_GET_CLASS(obj)    (GSK_ACTOR_DATAGRAM_SOCKET_CLASS(GTK_OBJECT(obj)->klass))
#define GSK_IS_ACTOR_DATAGRAM_SOCKET(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_ACTOR_DATAGRAM_SOCKET))
#define GSK_IS_ACTOR_DATAGRAM_SOCKET_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_ACTOR_DATAGRAM_SOCKET))

/* --- structures & typedefs --- */
typedef struct _GskActorDatagramSocket GskActorDatagramSocket;
typedef struct _GskActorDatagramSocketClass GskActorDatagramSocketClass;
typedef struct _GskActorDatagramSocketPacket GskActorDatagramSocketPacket;

struct _GskActorDatagramSocketPacket
{
  GskSocketAddress    	address;
  int			length;
  gpointer		packet;
};

struct _GskActorDatagramSocketClass
{
  GskActorClass actor_class;
  gboolean      (*on_input)        (GskActorDatagramSocket       *actor,
				    GskActorDatagramSocketPacket *packet);
  gboolean      (*on_write_error)  (GskActorDatagramSocket       *actor);
  gboolean      (*on_error)        (GskActorDatagramSocket       *actor);
};

struct _GskActorDatagramSocket
{
  GskActor		actor;

  GskDatagramSocket    *socket;
  GskSource            *source;

  GSList               *first_outgoing;
  GSList               *last_outgoing;

  guint			deferred_write_shutdown : 1;
};

/* --- public methods --- */
void    gsk_actor_datagram_socket_set_socket(GskActorDatagramSocket    *actor,
			                     GskDatagramSocket         *socket);


/* The actor_datagram_socket will free the packet, possibly
   before returning. */
void    gsk_actor_datagram_socket_add_packet(GskActorDatagramSocket    *actor,
					     const GskSocketAddress    *addr,
					     guint                      len,
					     gpointer                   packet);

/* The actor_datagram_socket will copy the packet, if needed. */
void    gsk_actor_datagram_socket_add_const (GskActorDatagramSocket    *actor,
					     const GskSocketAddress    *addr,
					     guint                      len,
					     gconstpointer              packet);


#endif
