#ifndef __GSK_BUFFER_ITERATOR__
#define __GSK_BUFFER_ITERATOR__

#include "gskbuffer.h"

typedef struct _GskBufferIterator GskBufferIterator;
struct _GskBufferIterator
{
  GskBufferWalker *walker;
  guint in_cur;
  guint cur_length;
  const guint8 *cur_data;
  guint offset;
};

void  gsk_buffer_iterator_construct (GskBufferIterator *iterator,
				     GskBuffer         *to_iterate);
guint gsk_buffer_iterator_peek      (GskBufferIterator *iterator,
				     gpointer           out,
				     guint              max_length);
guint gsk_buffer_iterator_read      (GskBufferIterator *iterator,
				     gpointer           out,
				     guint              max_length);
guint gsk_buffer_iterator_skip      (GskBufferIterator *iterator,
				     guint              max_length);

#define gsk_buffer_iterator_offset(iterator)  ((iterator)->offset)

#endif
