/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/


/*
 * A collection of utility functions.
 */

#ifndef __GSK_UTIL_H_
#define __GSK_UTIL_H_

#include "gskbasic.h"

/* read/write repeatedly until the entire buffer is processed. */
gboolean gsk_readn (int         fd, 
                    void       *in,
		    int         in_length);
gboolean gsk_writen(int         fd,
                    const void *out,
		    int         out_length);

int      gsk_get_randomness_fd();

/* Various characters and strings, macroized to avoid confusing
 * vi's matching-brace detection (%).
 */
#define GSK_CHAR_LEFT_BRACKET		'['
#define GSK_CHAR_RIGHT_BRACKET		']'
#define GSK_CHAR_LEFT_CURLY		'{'
#define GSK_CHAR_RIGHT_CURLY		'}'
#define GSK_CHAR_LEFT_PAREN		'('
#define GSK_CHAR_RIGHT_PAREN		')'
#define GSK_STRING_LEFT_BRACKET		"["
#define GSK_STRING_RIGHT_BRACKET	"]"
#define GSK_STRING_LEFT_CURLY		"{"
#define GSK_STRING_RIGHT_CURLY		"}"
#define GSK_STRING_LEFT_PAREN		"("
#define GSK_STRING_RIGHT_PAREN		")"

/* Set/clear/test whether a socket is nonblocking, ie. so reads
 * return immediately -1/EWOULDBLOCK. */
gboolean gsk_set_nonblocking(int fd);
gboolean gsk_clear_nonblocking(int fd);
gboolean gsk_is_nonblocking(int fd);

gboolean gsk_is_ready_to_read(int fd);
gboolean gsk_is_ready_to_write(int fd);

#endif
