#ifndef __GSK_LISP_INPUT_H_
#define __GSK_LISP_INPUT_H_

typedef struct _GskLispLexer GskLispLexer;

#include "gsklispnode.h"
#include "../gskgtk.h"

GskLispLexer   *gsk_lisp_lexer_new             ();
GSList         *gsk_lisp_lexer_feed            (GskLispLexer    *lexer,
				                guint            length,
				                const char      *txt);
GSList         *gsk_lisp_lexer_feed_str        (GskLispLexer    *lexer,
				                const char      *txt);
void            gsk_lisp_lexer_destroy         (GskLispLexer    *lexer);

gboolean        gsk_lisp_lexer_has_partial     (GskLispLexer    *lexer);
                                               

/* helper function to clean up the return of lisp_stream_feed.
 *
 * just calls g_slist_foreach (list, lisp_node_destroy_recursive, NULL)
 */
void            gsk_lisp_lexer_free_list       (GSList          *list);

/* helper atom parsing functions. */
gboolean        gsk_lisp_atom_parse_int        (const char      *atom,
                                                gint            *out);
gboolean        gsk_lisp_atom_parse_uint       (const char      *atom,
                                                guint           *out);
gboolean        gsk_lisp_atom_parse_bool       (const char      *atom,
                                                gboolean        *out);
gboolean        gsk_lisp_atom_parse_double     (const char      *atom,
                                                gdouble         *out);
gboolean        gsk_lisp_atom_parse_enum       (const char      *atom,
						GtkType          enum_type,
						guint           *value_out);

#endif
