/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

#ifndef __GSK_XML_TOKEN_H_
#define __GSK_XML_TOKEN_H_

#define GSK_XML_TOKEN_OPEN	1
#define GSK_XML_TOKEN_CLOSE	2
#define GSK_XML_TOKEN_TEXT	3
#define GSK_XML_TOKEN_COMMENT	4

#include "../gskbasic.h"

/* --- typedefs & structures --- */
typedef struct _GskXmlTokenOpen GskXmlTokenOpen;
typedef struct _GskXmlTokenClose GskXmlTokenClose;
typedef struct _GskXmlTokenText GskXmlTokenText;
typedef struct _GskXmlTokenComment GskXmlTokenComment;
typedef struct _GskXmlTokenAny  GskXmlTokenAny;
typedef union _GskXmlToken GskXmlToken;

struct _GskXmlTokenAny
{
  int                     type;
  int                     ref_count;
  const char             *filename;
  guint                   lineno;
};
struct _GskXmlTokenOpen
{
  int                     type;
  int                     ref_count;
  const char             *filename;
  guint                   lineno;

  char                   *tag_name;
  int                     num_param;
  char                  **params;
};
struct _GskXmlTokenClose
{
  int                     type;
  int                     ref_count;
  const char             *filename;
  guint                   lineno;

  char                   *tag_name;
};
struct _GskXmlTokenText
{
  int                     type;
  int                     ref_count;
  const char             *filename;
  guint                   lineno;

  char                   *text;
};
struct _GskXmlTokenComment
{
  int                     type;
  int                     ref_count;
  const char             *filename;
  guint                   lineno;

  char                   *comment;
};
union _GskXmlToken
{
  int                     type;
  GskXmlTokenText         text_token;
  GskXmlTokenOpen         open_token;
  GskXmlTokenClose        close_token;
  GskXmlTokenComment      comment_token;
  GskXmlTokenAny          any_token;
};

/* --- prototypes --- */
const char* gsk_xml_token_type_name(int type);

/* param_value_len[i] must include quotation marks!
   (they will be stripped out automatically!) */
GskXmlToken *gsk_xml_token_open_new   (const char  *tag_name,
                                       int          tag_name_len,
                                       const char  *tag,
                                       int          num_params,
                                       const int   *param_start,
                                       const int   *param_name_len,
                                       const int   *param_value_len);
GskXmlToken *gsk_xml_token_comment_new(const char  *comment,
				       guint        comment_len);
GskXmlToken *gsk_xml_token_close_new  (const char  *tag_name,
                                       int          tag_name_len);
GskXmlToken *gsk_xml_token_text_new   (const char  *text,
                                       int          text_len);

void         gsk_xml_token_unref      (GskXmlToken *token);
void         gsk_xml_token_ref        (GskXmlToken *token);

#endif
