##############################################################################
#
# Jarl - GPG Tk Interface Functions
#   Perl code to handle the Tk interface to the GPG code.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlGPGIF_PromptPassphrase - prompt the user for their passphrase
#
##############################################################################
sub jarlGPGIF_PromptPassphrase {

  if (Exists($GUI{GPGPassphrase}->{window}) && $GUI{PresenceRequeste
d}->{$jid}->{window}->ismapped()) {
    $GUI{GPGPassphrase}->{window}->raise();
    return;
  }

  $GUI{GPGPassphrase}->{window} = $GUI{top}->Toplevel();
  $GUI{GPGPassphrase}->{window}->title("GPG Passphrase");
  $GUI{GPGPassphrase}->{window}->resizable(0,0);

  $GUI{GPGPassphrase}->{vars}->{sempahore} = 0;

  $GUI{GPGPassphrase}->{top} = 
    $GUI{GPGPassphrase}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
            -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
           )->pack(-side=>"top",
                   -fill=>"y",
                   -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad},
                   -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
                   -expand=>1);
  
  $GUI{GPGPassphrase}->{Text}->{top} =
    $GUI{GPGPassphrase}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
            -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
           )->pack(-side=>"top",
                   -fill=>"both",
                   -expand=>1);
  $GUI{GPGPassphrase}->{Text}->{Label} =
    $GUI{GPGPassphrase}->{Text}->{top}->
      Label(-text=>"Please enter your GPG passphrase:",
            -anchor=>"w",
            -font=>$GUI{fonts}->{normal},
            -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
            -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
           )->pack(-side=>"left",
                   -fill=>"x",
                   -anchor=>"w");
  
  $GUI{GPGPassphrase}->{Entry1}->{top} =
    $GUI{GPGPassphrase}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
            -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
           )->pack(-side=>"top",
                   -fill=>"both",
                   -expand=>1);
  $GUI{GPGPassphrase}->{Entry1}->{Label} =
    $GUI{GPGPassphrase}->{Entry1}->{top}->
      Label(-text=>"Passphrase:",
	    -width=>12,
            -anchor=>"e",
            -font=>$GUI{fonts}->{normal},
            -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
            -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
           )->pack(-side=>"left",
                   -fill=>"y",
                   -anchor=>"e");
  $GUI{GPGPassphrase}->{Entry1}->{Entry} =
    $GUI{GPGPassphrase}->{Entry1}->{top}->
      Entry(-textvariable=>\$GUI{GPGPassphrase}->{vars}->{pass1},
	    -show=>"*",
	    -width=>30,
            -font=>$GUI{fonts}->{normal},
            -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
            -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{light}
           )->pack(-side=>"left",
                   -fill=>"x",
                   -anchor=>"w");
  $GUI{GPGPassphrase}->{Entry1}->{Entry}->
    bind("<Return>", 
	 sub {
	   &jarlGPGIF_PassphraseCheckCB();
	 });
	       
  $GUI{GPGPassphrase}->{Buttons}->{top} = 
    $GUI{GPGPassphrase}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
            -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
           )->pack(-side=>"top",
                   -fill=>"both",
                   -expand=>1);
  $GUI{GPGPassphrase}->{Buttons}->{Save} =
    $GUI{GPGPassphrase}->{Buttons}->{top}->
      Button(-text=>"Ok",
             -background=>$GUI{color}->{bg}->{normal},
             -foreground=>$GUI{color}->{fg}->{dark},
             -disabledforeground=>$GUI{color}->{fg}->{light},
             -font=>$GUI{fonts}->{normal},
             -command=>sub{
	       &jarlGPGIF_PassphraseCheckCB();
             }
            )->pack(-side=>"right",
                    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
                    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
  $GUI{GPGPassphrase}->{Buttons}->{Save} =
    $GUI{GPGPassphrase}->{Buttons}->{top}->
      Button(-text=>"Disable GPG",
             -background=>$GUI{color}->{bg}->{normal},
             -foreground=>$GUI{color}->{fg}->{dark},
             -disabledforeground=>$GUI{color}->{fg}->{light},
             -font=>$GUI{fonts}->{normal},
             -command=>sub{
	       $config{gpg}->{active} = -1;
               &jarlGPGIF_PassphrasePromptCloseCB();
             }
            )->pack(-side=>"right",
                    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
                    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

  $GUI{top}->waitVariable(\$GUI{GPGPassphrase}->{vars}->{semaphore});
}


##############################################################################
#
# jarlGPGIF_PassphraseCheckCB - checks if the password is correct.
#
##############################################################################
sub jarlGPGIF_PassphraseCheckCB {
  return if ($GUI{GPGPassphrase}->{vars}->{pass1} eq "");
  if (&jarlGPG_TestPassphrase($GUI{GPGPassphrase}->{vars}->{pass1}) == 0) {
    $GUI{GPGPassphrase}->{vars}->{pass1} = "";
    return;
  }
  $config{gpg}->{passphrase} = $GUI{GPGPassphrase}->{vars}->{pass1};
  &jarlGPGIF_PassphrasePromptCloseCB();
}


##############################################################################
#
# jarlGPGIF_PassphrasePromptCloseCB - closes the passphrase prompt GUI.
#
##############################################################################
sub jarlGPGIF_PassphrasePromptCloseCB {
  $GUI{GPGPassphrase}->{vars}->{semaphore} = 1;
  $GUI{GPGPassphrase}->{window}->destroy;
  delete($GUI{GPGPassphrase});
}


1;
