##############################################################################
#
# Jarl - Headline Tk Interface Code
#
#   Perl code to handle showing the Jarl Headline GUI and interfacing with the
# headlines.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlHeadlineIF_PopupGUI - creates the headline popup GUI.
#
##############################################################################
sub jarlHeadlineIF_PopupGUI {

  $GUI{HeadlinePopup} =
    $GUI{Main}->{top}->
      Menu(-tearoff=>0,
	   -borderwidth=>2,
	   -relief=>"raised",
	   -background=>$GUI{color}->{jarl}->{menu}->{background},
	   -foreground=>$GUI{color}->{jarl}->{menu}->{text},
	  );

  $GUI{HeadlinePopup}->
    add("command",
	-label=>"Delete Headline",
	-font=>$GUI{fonts}->{normal},
	-foreground=>$GUI{color}->{jarl}->{menu}->{text},
	-background=>$GUI{color}->{jarl}->{menu}->{background},
	-command=>sub{
	  return if ($GUI{Headline}->{MulColListbox}->curselection eq "");
	  splice(@headlines,$GUI{Headline}->{MulColListbox}->curselection,1);
	  $GUI{Headline}->{MulColListbox}->
	    delete($GUI{Headline}->{MulColListbox}->curselection);
	  &jarlHeadlineIF_Show();
	});

  $GUI{HeadlinePopup}->
    add("command",
	-label=>"Fetch URL",
	-font=>$GUI{fonts}->{normal},
	-foreground=>$GUI{color}->{jarl}->{menu}->{text},
	-background=>$GUI{color}->{jarl}->{menu}->{background},
	-command=>sub{
	  return if ($GUI{Headline}->{MulColListbox}->curselection eq "");
	  my $message = $headlines[$GUI{Headline}->{MulColListbox}->curselection];
	  &jarlFetchURL($message);
	});
}


##############################################################################
#
# jarlHeadlineIF_AddMessage - adds the headline based on the <message/>.
#
##############################################################################
sub jarlHeadlineIF_AddMessage {
  my ($message,$doNotStore) = @_;

  $doNotStore = 0 unless defined($doNotStore);

  $Debug->Log1("jarlHeadlineIF_AddMessage: message($message) doNotStore($doNotStore)");

  splice(@headlines,0,0,$message) unless ($doNotStore == 1);

  return unless (Exists($TabBar) &&
		 $TabBar->ismapped());

  if (!($TabBar->ExistsTab("headline"))) {
    $Debug->Log1("jarlHeadlineIF_AddMessage: New GUI");

    $GUI{Headline}->{top} =
      $TabBar->AddTab(-type=>"docked",
		      -tag=>"headline",
		      -text=>"Headlines");

    &jarlHeadlineIF_NewGUI();
  } else {
    my $fromJID = $message->GetFrom("jid");
    my $channel = $fromJID->GetJID();
    my $rosterName = $Roster->GetValue($fromJID->GetJID("full"),"name");
    $channel = $rosterName unless($rosterName eq "");

    my $date;
    my @xDelays = $message->GetX("jabber:x:delay");
    if ($#xDelays > -1) {
      $date = &Net::Jabber::GetTimeStamp("utcdelaylocal",$xDelays[0]->GetStamp());
    } else {
      $date = &Net::Jabber::GetTimeStamp("local",time);
    }

    $GUI{Headline}->{MulColListbox}->
      insert({
	      date=>$date,
	      headline=>$message->GetSubject(),
	      channel=>$channel
	     }
	    );
  }
  $TabBar->HighlightTab("headline");
  $GUI{Headline}->{top}->bell() unless ($doNotStore == 1);
}


##############################################################################
#
# jarlHeadlineIF_NewGUI - populates the headline GUI.
#
##############################################################################
sub jarlHeadlineIF_NewGUI {

  $GUI{Headline}->{Header} =
    $GUI{Headline}->{top}->
      Label(-text=>"Headlines",
	    -anchor=>"w",
	    -font=>$GUI{fonts}->{header},
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");

  $GUI{Headline}->{MulColListbox} =
    $GUI{Headline}->{top}->
      MulColListbox(-headerbackground=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
		    -headerforeground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
		    -headerborderwidth=>1,
		    -marker=>1,
		    -markerstyle=>"diamond",
		    -background=>$GUI{color}->{jarl}->{main}->{bg}->{light},
		    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
		    -relief=>"sunken",
		    -borderwidth=>2,
		    -height=>0,
		    -width=>0,
		    -font=>$GUI{fonts}->{normal},
		    -selectbackground=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
		    -selectforeground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
		    -scrollbarborderwidth=>1,
		    -scrollbarrelief=>"flat",
		   )->pack(-side=>"top",
			   -fill=>"both",
			   -expand=>1,
			   -padx=>5,
			   -pady=>5);

  $GUI{Headline}->{MulColListbox}->
    AddColumn(-header=>"Channel",
	      -key=>"channel",
	      -width=>10);
  $GUI{Headline}->{MulColListbox}->
    AddColumn(-header=>"Headline",
	      -key=>"headline",
	      -width=>100);
  $GUI{Headline}->{MulColListbox}->
    AddColumn(-header=>"Date",
	      -key=>"date",
	      -width=>10);

  $GUI{Headline}->{MulColListbox}->
    bind("<Button-1>",
	 sub {
	   return
	     if ($GUI{Headline}->{MulColListbox}->curselection eq "");
	   &jarlHeadlineIF_Show($GUI{Headline}->{MulColListbox}->curselection);
	 }
	);

  $GUI{Headline}->{MulColListbox}->
    bind("<Button-3>",
         [ sub{
             my ($mcl,$y) = @_;

             $mcl->selectionClear(0,"end");
             $mcl->selectionSet($mcl->nearest($y));
             return if ($mcl->curselection eq "");
             $GUI{HeadlinePopup}->Popup(-popover=>"cursor",
                                        -popanchor=>"nw");
           },
           Ev('y')
         ]
        );


  $GUI{Headline}->{Body}->{top} =
    $GUI{Headline}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -padx=>5,
		   -pady=>5);


  $GUI{Headline}->{Body}->{Scrolled} =
    $GUI{Headline}->{Body}->{top}->
      Scrolled("Text",
	       -scrollbars=>"oe",
	       -background=>$GUI{color}->{jarl}->{main}->{bg}->{light},
	       -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -height=>5,
	       -width=>0,
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -takefocus=>0,
	       -wrap=>"word",
	       -state=>"disabled"
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  $GUI{Headline}->{Body}->{Scrollbar} =
    $GUI{Headline}->{Body}->{Scrolled}->Subwidget("yscrollbar");
  $GUI{Headline}->{Body}->{Scrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -relief=>"flat");
  $GUI{Headline}->{Body}->{Text} =
    $GUI{Headline}->{Body}->{Scrolled}->Subwidget("text");

  $GUI{Headline}->{Body}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{Headline}->{Body}->{Text}->
	     yviewScroll(-1,"units");
	 });
  $GUI{Headline}->{Body}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{Headline}->{Body}->{Text}->
	     yviewScroll(1,"units");
	 });

  $GUI{HeadlineButtons}->{top} =
    $GUI{Headline}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"x");

  $GUI{HeadlineButtons}->{Close} =
    $GUI{HeadlineButtons}->{top}->
      Button(-text=>"Close",
	     -width=>$GUI{width}->{jarl}->{config}->{profile}->{button},
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       $TabBar->DeleteTab("headline");
	       delete($GUI{Headline});
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  $GUI{HeadlineButtons}->{DeleteAll} =
    $GUI{HeadlineButtons}->{top}->
      Button(-text=>"Delete All",
	     -width=>$GUI{width}->{jarl}->{config}->{profile}->{button},
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       splice(@headlines,0,($#headlines+1));
	       $GUI{Headline}->{MulColListbox}->delete(0,"end");
	       &jarlHeadlineIF_Show();
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  $GUI{HeadlineButtons}->{FetchURL} =
    $GUI{HeadlineButtons}->{top}->
      Button(-text=>"Fetch URL",
	     -width=>$GUI{width}->{jarl}->{config}->{profile}->{button},
	     -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{config}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       return if ($GUI{Headline}->{MulColListbox}->curselection eq "");
	       my $message = $headlines[$GUI{Headline}->{MulColListbox}->curselection];
	       &jarlFetchURL($message);
	     }
	    )->pack(-side=>"right",
		    -padx=>$GUI{width}->{jarl}->{config}->{pad});

  &jarlHeadlineIF_List();
}


##############################################################################
#
# jarlHeadlineIF_List - lists the headlines.
#
##############################################################################
sub jarlHeadlineIF_List {

  if (exists($GUI{Headline}) &&
      Exists($GUI{Headline}->{MulColListbox})) {
    $GUI{Headline}->{MulColListbox}->delete(0,"end");
    $GUI{Headline}->{MulColListbox}->draw(0);
  }

  my $index;
  foreach $index (0..$#headlines) {
    &jarlHeadlineIF_AddMessage($headlines[$index],1);
  }

  if (exists($GUI{Headline}) &&
      Exists($GUI{Headline}->{MulColListbox})) {
    $GUI{Headline}->{MulColListbox}->draw(1);
    $GUI{Headline}->{top}->bell() if ($#headlines > -1);
  }
}


##############################################################################
#
# jarlHeadlineIF_Show - shows the current headline.
#
##############################################################################
sub jarlHeadlineIF_Show {
  my ($index) = @_;

  $index = "" unless defined($index);

  $GUI{Headline}->{Body}->{Text}->configure(-state=>"normal");
  $GUI{Headline}->{Body}->{Text}->delete("1.0","end");
  $GUI{Headline}->{Body}->{Text}->insert("end",$headlines[$index]->GetBody()) unless ($index eq "");
  $GUI{Headline}->{Body}->{Text}->configure(-state=>"disabled");
}


##############################################################################
#
# Stuff to do when we load the headline code.
#
##############################################################################
&jarlHeadlineIF_PopupGUI();


1;
